/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.teams;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationSaveData;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.util.DebugUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class Team {
    public static final int MAX_NAME_LENGTH = 32;
    public static final byte CATEGORY_MEMBER = 0;
    public static final byte CATEGORY_ADMIN = 1;
    public static final byte CATEGORY_REMOVE = 2;
    public static final byte CATEGORY_OWNER = 10;
    private long id;
    PlayerReference owner = null;
    String teamName = "Some Team";
    private boolean isClient = false;
    List<PlayerReference> admins = Lists.newArrayList();
    List<PlayerReference> members = Lists.newArrayList();
    int bankAccountLimit = 2;
    BankAccount bankAccount = null;

    public long getID() {
        return this.id;
    }

    public void overrideID(long newID) {
        this.id = newID;
    }

    public PlayerReference getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.teamName;
    }

    public void flagAsClient() {
        this.isClient = true;
    }

    public List<PlayerReference> getAdmins() {
        return this.admins;
    }

    public List<PlayerReference> getMembers() {
        return this.members;
    }

    public List<PlayerReference> getAllMembers() {
        ArrayList<PlayerReference> result = new ArrayList<PlayerReference>();
        result.addAll(this.members);
        result.addAll(this.admins);
        result.add(this.owner);
        return result;
    }

    public int getBankLimit() {
        return this.bankAccountLimit;
    }

    public boolean hasBankAccount() {
        return this.bankAccount != null;
    }

    public boolean canAccessBankAccount(class_1657 player) {
        if (this.bankAccountLimit < 1) {
            return this.isMember(player);
        }
        if (this.bankAccountLimit < 2) {
            return this.isAdmin(player);
        }
        return this.isOwner(player);
    }

    public BankAccount getBankAccount() {
        return this.bankAccount;
    }

    public boolean isOwner(class_1657 player) {
        return this.owner != null && this.owner.is((class_1297)player) || CommandLCAdmin.isAdminPlayer(player);
    }

    public boolean isOwner(UUID playerID) {
        return this.owner != null && this.owner.is(playerID);
    }

    public boolean isAdmin(class_1657 player) {
        return PlayerReference.listContains(this.admins, player.method_5667()) || this.isOwner(player);
    }

    public boolean isAdmin(UUID playerID) {
        return PlayerReference.listContains(this.admins, playerID) || this.isOwner(playerID);
    }

    public boolean isMember(class_1657 player) {
        return player != null && (PlayerReference.listContains(this.members, player.method_5667()) || this.isAdmin(player));
    }

    public boolean isMember(UUID playerID) {
        return PlayerReference.listContains(this.members, playerID) || this.isAdmin(playerID);
    }

    public void changeAddMember(class_1657 requestor, String name) {
        this.changeAny(requestor, name, (byte)0);
    }

    public void changeAddAdmin(class_1657 requestor, String name) {
        this.changeAny(requestor, name, (byte)1);
    }

    public void changeRemoveMember(class_1657 requestor, String name) {
        this.changeAny(requestor, name, (byte)2);
    }

    public void changeOwner(class_1657 requestor, String name) {
        this.changeAny(requestor, name, (byte)10);
    }

    public void changeName(class_1657 requestor, String newName) {
        if (this.isAdmin(requestor)) {
            this.teamName = newName;
            if (this.bankAccount != null) {
                this.bankAccount.updateOwnersName(this.teamName);
            }
            this.markDirty();
        }
    }

    public void changeAny(class_1657 requestor, String playerName, byte category) {
        LightmansCurrency.LogDebug("Member change request received on the " + DebugUtil.getSideText((class_1297)requestor));
        PlayerReference player = PlayerReference.of(this.isClient, playerName);
        if (player == null) {
            LightmansCurrency.LogDebug("No player found with the name " + playerName + "!");
            return;
        }
        LightmansCurrency.LogDebug(playerName + " found with id " + player.id.toString());
        LightmansCurrency.LogDebug("Request made: " + (switch (category) {
            case 0 -> "Add Member";
            case 1 -> "Add Admin";
            case 2 -> "Remove Member/Admin";
            case 10 -> "Set Owner";
            default -> "ERROR";
        }));
        if (category == 0 && this.isAdmin(requestor)) {
            if (this.isMember(player.id)) {
                return;
            }
            this.members.add(player);
            this.markDirty();
        } else if (category == 1 && this.isAdmin(requestor)) {
            if (this.isAdmin(player.id)) {
                if (this.isOwner(player.id)) {
                    return;
                }
                if (PlayerReference.of(requestor).is(player) || this.isOwner(requestor)) {
                    PlayerReference.removeFromList(this.admins, player);
                    this.members.add(player);
                    this.markDirty();
                }
            } else if (this.isOwner(requestor)) {
                if (this.isMember(player.id)) {
                    PlayerReference.removeFromList(this.members, player);
                }
                this.admins.add(player);
                this.markDirty();
            }
        } else if (category == 2 && (this.isAdmin(requestor) || PlayerReference.of(requestor).is(player))) {
            if (!this.isMember(player.id)) {
                return;
            }
            if (this.isAdmin(player.id) && !this.isOwner(requestor) && !PlayerReference.of(requestor).is(player)) {
                return;
            }
            if (this.isOwner(player.id)) {
                return;
            }
            boolean notFound = true;
            if (this.isAdmin(player.id)) {
                PlayerReference.removeFromList(this.admins, player);
            } else {
                PlayerReference.removeFromList(this.members, player);
            }
            if (notFound) {
                return;
            }
            this.markDirty();
        } else if (category == 10 && this.isOwner(requestor)) {
            if (this.owner.is(player)) {
                return;
            }
            this.admins.add(this.owner);
            this.owner = player;
            PlayerReference.removeFromList(this.admins, player);
            PlayerReference.removeFromList(this.members, player);
            this.markDirty();
        }
    }

    public void createBankAccount(class_1657 requestor) {
        if (this.hasBankAccount() || !this.isOwner(requestor)) {
            return;
        }
        this.bankAccount = new BankAccount(() -> this.markDirty());
        this.bankAccount.updateOwnersName(this.teamName);
        this.bankAccount.setNotificationConsumer(this::notificationSender);
        this.markDirty();
    }

    private void notificationSender(Supplier<Notification> notification) {
        ArrayList<PlayerReference> sendTo = new ArrayList<PlayerReference>();
        if (this.bankAccountLimit < 1) {
            sendTo.addAll(this.members);
        }
        if (this.bankAccountLimit < 2) {
            sendTo.addAll(this.admins);
        }
        sendTo.add(this.owner);
        for (PlayerReference player : sendTo) {
            if (player == null || player.id == null) continue;
            NotificationSaveData.PushNotification(player.id, notification.get());
        }
    }

    public void changeBankLimit(class_1657 requestor, int newLimit) {
        if (this.isOwner(requestor) && this.bankAccountLimit != newLimit) {
            this.bankAccountLimit = newLimit;
            this.markDirty();
        }
    }

    public static int NextBankLimit(int currentLimit) {
        int result = currentLimit - 1;
        if (result < 0) {
            result = 2;
        }
        return result;
    }

    private Team(@NotNull long teamID, @NotNull PlayerReference owner, @NotNull String name) {
        this.id = teamID;
        this.owner = owner;
        this.teamName = name;
    }

    public void markDirty() {
        if (!this.isClient) {
            TeamSaveData.MarkTeamDirty(this.id);
        }
    }

    public class_2487 save() {
        class_2487 compound = new class_2487();
        compound.method_10544("ID", this.id);
        if (this.owner != null) {
            compound.method_10566("Owner", (class_2520)this.owner.save());
        }
        compound.method_10582("Name", this.teamName);
        class_2499 memberList = new class_2499();
        for (int i = 0; i < this.members.size(); ++i) {
            class_2487 thisMember = this.members.get(i).save();
            memberList.add((Object)thisMember);
        }
        compound.method_10566("Members", (class_2520)memberList);
        class_2499 adminList = new class_2499();
        for (int i = 0; i < this.admins.size(); ++i) {
            class_2487 thisAdmin = this.admins.get(i).save();
            adminList.add((Object)thisAdmin);
        }
        compound.method_10566("Admins", (class_2520)adminList);
        if (this.bankAccount != null) {
            compound.method_10566("BankAccount", (class_2520)this.bankAccount.save());
            compound.method_10569("BankLimit", this.bankAccountLimit);
        }
        return compound;
    }

    public static Team load(@NotNull class_2487 compound) {
        PlayerReference owner = null;
        long id = -1L;
        if (compound.method_10545("ID")) {
            id = compound.method_10537("ID");
        }
        if (compound.method_10573("Owner", 10)) {
            owner = PlayerReference.load(compound.method_10562("Owner"));
        }
        String name = compound.method_10558("Name");
        if (owner != null) {
            Team team = Team.of(id, owner, name);
            class_2499 adminList = compound.method_10554("Admins", 10);
            for (int i = 0; i < adminList.size(); ++i) {
                PlayerReference admin = PlayerReference.load(adminList.method_10602(i));
                if (admin == null) continue;
                team.admins.add(admin);
            }
            class_2499 memberList = compound.method_10554("Members", 10);
            for (int i = 0; i < memberList.size(); ++i) {
                PlayerReference member = PlayerReference.load(memberList.method_10602(i));
                if (member == null) continue;
                team.members.add(member);
            }
            if (compound.method_10573("BankAccount", 10)) {
                team.bankAccount = new BankAccount(team::markDirty, compound.method_10562("BankAccount"));
                if (compound.method_10573("BankLimit", 3)) {
                    team.bankAccountLimit = compound.method_10550("BankLimit");
                }
                team.bankAccount.updateOwnersName(team.teamName);
                team.bankAccount.setNotificationConsumer(team::notificationSender);
            }
            return team;
        }
        return null;
    }

    public static Team of(@NotNull long id, @NotNull PlayerReference owner, @NotNull String name) {
        return new Team(id, owner, name);
    }

    public static Comparator<Team> sorterFor(class_1657 player) {
        return new TeamSorter(player);
    }

    private static class TeamSorter
    implements Comparator<Team> {
        private final class_1657 player;

        private TeamSorter(class_1657 player) {
            this.player = player;
        }

        @Override
        public int compare(Team o1, Team o2) {
            if (o1.isOwner(this.player) && !o2.isOwner(this.player)) {
                return -1;
            }
            if (!o1.isOwner(this.player) && o2.isOwner(this.player)) {
                return 1;
            }
            if (o1.isAdmin(this.player) && !o2.isAdmin(this.player)) {
                return -1;
            }
            if (!o1.isAdmin(this.player) && o2.isAdmin(this.player)) {
                return 1;
            }
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    }
}

