/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.client.gui.screen.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.settings.input.InputTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.settings.input.InputTabAddon;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.settings.ChangeSettingNotification;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.options.BooleanPermission;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.options.PermissionOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public abstract class InputTraderData
extends TraderData {
    public final ImmutableList<class_2350> ignoreSides;
    private final Map<class_2350, Boolean> inputSides = new HashMap<class_2350, Boolean>();
    private final Map<class_2350, Boolean> outputSides = new HashMap<class_2350, Boolean>();

    public static class_5250 getFacingName(class_2350 side) {
        return class_2561.method_43471((String)("gui.lightmanscurrency.settings.side." + side.toString().toLowerCase()));
    }

    @Override
    protected void modifyDefaultAllyPermissions(Map<String, Integer> defaultValues) {
        defaultValues.put("changeExternalInputs", 1);
    }

    protected InputTraderData(class_2960 type) {
        this(type, (ImmutableList<class_2350>)ImmutableList.of());
    }

    protected InputTraderData(class_2960 type, ImmutableList<class_2350> ignoreSides) {
        super(type);
        this.ignoreSides = ignoreSides;
    }

    protected InputTraderData(class_2960 type, class_1937 level, class_2338 pos) {
        this(type, level, pos, (ImmutableList<class_2350>)ImmutableList.of());
    }

    protected InputTraderData(class_2960 type, class_1937 level, class_2338 pos, ImmutableList<class_2350> ignoreSides) {
        super(type, level, pos);
        this.ignoreSides = ignoreSides;
    }

    public boolean allowInputSide(class_2350 side) {
        if (this.ignoreSides.contains((Object)side)) {
            return false;
        }
        return this.inputSides.getOrDefault(side, false);
    }

    public final boolean hasInputSide() {
        for (class_2350 side : class_2350.values()) {
            if (!this.allowInputSide(side)) continue;
            return true;
        }
        return false;
    }

    public boolean allowOutputSide(class_2350 side) {
        if (this.ignoreSides.contains((Object)side)) {
            return false;
        }
        return this.outputSides.getOrDefault(side, false);
    }

    public final boolean hasOutputSide() {
        for (class_2350 side : class_2350.values()) {
            if (!this.allowOutputSide(side)) continue;
            return true;
        }
        return false;
    }

    public void setInputSide(class_1657 player, class_2350 side, boolean value) {
        if (this.hasPermission(player, "changeExternalInputs") && value != this.allowInputSide(side)) {
            if (this.ignoreSides.contains((Object)side)) {
                return;
            }
            this.inputSides.put(side, value);
            this.markDirty(this::saveInputSides);
            if (player != null) {
                this.pushLocalNotification(new ChangeSettingNotification.Simple(PlayerReference.of(player), "Input-" + InputTraderData.getFacingName(side).getString(), String.valueOf(this.allowInputSide(side))));
            }
        }
    }

    public void setOutputSide(class_1657 player, class_2350 side, boolean value) {
        if (this.hasPermission(player, "changeExternalInputs") && value != this.allowOutputSide(side)) {
            if (this.ignoreSides.contains((Object)side)) {
                return;
            }
            this.outputSides.put(side, value);
            this.markDirty(this::saveOutputSides);
            if (player != null) {
                this.pushLocalNotification(new ChangeSettingNotification.Simple(PlayerReference.of(player), "Output-" + InputTraderData.getFacingName(side).getString(), String.valueOf(this.allowOutputSide(side))));
            }
        }
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        this.saveInputSides(compound);
        this.saveOutputSides(compound);
    }

    protected final void saveInputSides(class_2487 compound) {
        class_2487 tag = new class_2487();
        for (class_2350 side : class_2350.values()) {
            if (this.ignoreSides.contains((Object)side)) continue;
            tag.method_10556(side.toString(), this.allowInputSide(side));
        }
        compound.method_10566("InputSides", (class_2520)tag);
    }

    protected final void saveOutputSides(class_2487 compound) {
        class_2487 tag = new class_2487();
        for (class_2350 side : class_2350.values()) {
            if (this.ignoreSides.contains((Object)side)) continue;
            tag.method_10556(side.toString(), this.allowOutputSide(side));
        }
        compound.method_10566("OutputSides", (class_2520)tag);
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        class_2487 tag;
        if (compound.method_10545("InputSides")) {
            this.inputSides.clear();
            tag = compound.method_10562("InputSides");
            for (class_2350 side : class_2350.values()) {
                if (this.ignoreSides.contains((Object)side) || !tag.method_10545(side.toString())) continue;
                this.inputSides.put(side, tag.method_10577(side.toString()));
            }
        }
        if (compound.method_10545("OutputSides")) {
            this.outputSides.clear();
            tag = compound.method_10562("OutputSides");
            for (class_2350 side : class_2350.values()) {
                if (this.ignoreSides.contains((Object)side) || !tag.method_10545(side.toString())) continue;
                this.outputSides.put(side, tag.method_10577(side.toString()));
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public abstract IconData inputSettingsTabIcon();

    @Environment(value=EnvType.CLIENT)
    public abstract class_5250 inputSettingsTabTooltip();

    @Environment(value=EnvType.CLIENT)
    public abstract int inputSettingsTabColor();

    @Environment(value=EnvType.CLIENT)
    public abstract int inputSettingsTextColor();

    @Environment(value=EnvType.CLIENT)
    public List<InputTabAddon> inputSettingsAddons() {
        return ImmutableList.of();
    }

    @Override
    public void receiveNetworkMessage(class_1657 player, class_2487 message) {
        class_2350 side;
        boolean newValue;
        super.receiveNetworkMessage(player, message);
        if (message.method_10545("SetInputSide")) {
            newValue = message.method_10577("SetInputSide");
            side = class_2350.method_10143((int)message.method_10550("Side"));
            this.setInputSide(player, side, newValue);
        }
        if (message.method_10545("SetOutputSide")) {
            newValue = message.method_10577("SetOutputSide");
            side = class_2350.method_10143((int)message.method_10550("Side"));
            this.setOutputSide(player, side, newValue);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addSettingsTabs(List<SettingsTab> tabs) {
        tabs.add(InputTab.INSTANCE);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addPermissionOptions(List<PermissionOption> options) {
        options.add(BooleanPermission.of("changeExternalInputs"));
    }
}

