/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders;

import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menu.slots.trader.InteractionSlot;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.money.wallet.WalletHandler;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.storage.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;

public class TradeContext {
    public final boolean isStorageMode;
    private final TraderData trader;
    private final class_1657 player;
    private final PlayerReference playerReference;
    private final BankAccount.AccountReference bankAccount;
    private final class_1263 coinSlots;
    private final CoinValue storedMoney;
    private final BiConsumer<CoinValue, Boolean> moneyListener;
    private final InteractionSlot interactionSlot;
    private final TraderItemStorage itemStorage;
    private final class_1263 inventory;

    public boolean hasTrader() {
        return this.trader != null;
    }

    public TraderData getTrader() {
        return this.trader;
    }

    public boolean hasPlayer() {
        return this.player != null;
    }

    public class_1657 getPlayer() {
        return this.player;
    }

    public boolean hasPlayerReference() {
        return this.playerReference != null;
    }

    public final PlayerReference getPlayerReference() {
        return this.playerReference;
    }

    private boolean hasBankAccount() {
        return this.bankAccount != null && this.bankAccount.get() != null;
    }

    private boolean hasCoinSlots() {
        return this.hasPlayer() && this.coinSlots != null;
    }

    private boolean hasStoredMoney() {
        return this.storedMoney != null;
    }

    private boolean hasInteractionSlot(String type) {
        return this.getInteractionSlot(type) != null;
    }

    private InteractionSlot getInteractionSlot(String type) {
        if (this.interactionSlot == null) {
            return null;
        }
        if (this.interactionSlot.isType(type)) {
            return this.interactionSlot;
        }
        return null;
    }

    private class_1799 getInteractionSlotStack(String type) {
        InteractionSlot slot = this.getInteractionSlot(type);
        return slot == null ? class_1799.field_8037 : slot.method_7677();
    }

    private boolean hasItemStorage() {
        return this.itemStorage != null;
    }

    private boolean hasInventory() {
        return this.inventory != null;
    }

    private TradeContext(Builder builder) {
        this.isStorageMode = builder.storageMode;
        this.trader = builder.trader;
        this.player = builder.player;
        this.playerReference = builder.playerReference;
        this.bankAccount = builder.bankAccount;
        this.coinSlots = builder.coinSlots;
        this.storedMoney = builder.storedCoins;
        this.moneyListener = builder.moneyListener;
        this.interactionSlot = builder.interactionSlot;
        this.itemStorage = builder.itemStorage;
        this.inventory = builder.inventory;
    }

    public boolean hasPaymentMethod() {
        return this.hasPlayer() || this.hasCoinSlots() || this.hasBankAccount() || this.hasStoredMoney();
    }

    public boolean hasFunds(CoinValue price) {
        return this.getAvailableFunds() >= price.getRawValue();
    }

    public long getAvailableFunds() {
        WalletHandler walletHandler;
        class_1799 wallet;
        long funds = 0L;
        if (this.hasBankAccount()) {
            funds += this.bankAccount.get().getCoinStorage().getRawValue();
        }
        if (this.hasPlayer() && WalletItem.isWallet((wallet = (walletHandler = WalletHandler.getWallet(this.player)).getWallet()).method_7909())) {
            funds += MoneyUtil.getValue(WalletItem.getWalletInventory(wallet));
        }
        if (this.hasStoredMoney()) {
            funds += this.storedMoney.getRawValue();
        }
        if (this.hasCoinSlots() && this.hasPlayer()) {
            funds += MoneyUtil.getValue(this.coinSlots);
        }
        return funds;
    }

    public boolean getPayment(CoinValue price) {
        if (this.hasFunds(price)) {
            WalletHandler walletHandler;
            class_1799 wallet;
            if (this.moneyListener != null) {
                this.moneyListener.accept(price, false);
            }
            long amountToWithdraw = price.getRawValue();
            if (this.hasCoinSlots() && this.hasPlayer() && (amountToWithdraw = MoneyUtil.takeObjectsOfValue(amountToWithdraw, this.coinSlots, true)) < 0L) {
                List<class_1799> change = MoneyUtil.getCoinsOfValue(-amountToWithdraw);
                for (class_1799 stack : change) {
                    class_1799 c = InventoryUtil.TryPutItemStack(this.coinSlots, stack);
                    if (c.method_7960()) continue;
                    InventoryUtil.GiveToPlayer(this.player, c);
                }
            }
            if (this.hasStoredMoney() && amountToWithdraw > 0L) {
                long removeAmount = Math.min(amountToWithdraw, this.storedMoney.getRawValue());
                amountToWithdraw -= removeAmount;
                this.storedMoney.loadFromOldValue(this.storedMoney.getRawValue() - removeAmount);
            }
            if (this.hasBankAccount() && amountToWithdraw > 0L) {
                CoinValue withdrawAmount = this.bankAccount.get().withdrawCoins(new CoinValue(amountToWithdraw));
                amountToWithdraw -= withdrawAmount.getRawValue();
                if (this.hasTrader() && withdrawAmount.getRawValue() > 0L) {
                    this.bankAccount.get().LogInteraction(this.getTrader(), withdrawAmount, false);
                }
            }
            if (this.hasPlayer() && amountToWithdraw > 0L && WalletItem.isWallet((wallet = (walletHandler = WalletHandler.getWallet(this.player)).getWallet()).method_7909())) {
                class_2371<class_1799> walletInventory = WalletItem.getWalletInventory(wallet);
                amountToWithdraw = MoneyUtil.takeObjectsOfValue(amountToWithdraw, walletInventory, true);
                WalletItem.putWalletInventory(wallet, walletInventory);
                if (amountToWithdraw < 0L) {
                    for (class_1799 stack : MoneyUtil.getCoinsOfValue(-amountToWithdraw)) {
                        class_1799 c = WalletItem.PickupCoin(wallet, stack);
                        if (c.method_7960()) continue;
                        InventoryUtil.GiveToPlayer(this.player, c);
                    }
                    amountToWithdraw = 0L;
                }
            }
            return true;
        }
        return false;
    }

    public boolean givePayment(CoinValue price) {
        if (this.moneyListener != null) {
            this.moneyListener.accept(price, true);
        }
        if (this.hasBankAccount()) {
            this.bankAccount.get().depositCoins(price);
            if (this.hasTrader()) {
                this.bankAccount.get().LogInteraction(this.getTrader(), price, true);
            }
            return true;
        }
        if (this.hasStoredMoney()) {
            this.storedMoney.addValue(price);
            return true;
        }
        if (this.hasPlayer()) {
            List<class_1799> coins = MoneyUtil.getCoinsOfValue(price);
            WalletHandler walletHandler = WalletHandler.getWallet(this.player);
            class_1799 wallet = walletHandler.getWallet();
            if (WalletItem.isWallet(wallet.method_7909())) {
                ArrayList<class_1799> change = new ArrayList<class_1799>();
                for (class_1799 itemStack : coins) {
                    class_1799 coin = WalletItem.PickupCoin(wallet, itemStack);
                    if (coin.method_7960()) continue;
                    change.add(coin);
                }
                coins = change;
            }
            if (this.hasCoinSlots() && coins.size() > 0) {
                for (class_1799 itemStack : coins) {
                    class_1799 remainder = InventoryUtil.TryPutItemStack(this.coinSlots, itemStack);
                    if (remainder.method_7960()) continue;
                    InventoryUtil.GiveToPlayer(this.player, remainder);
                }
            } else if (coins.size() > 0) {
                InventoryUtil.GiveToPlayer(this.player, coins);
            }
            return true;
        }
        return false;
    }

    public boolean hasItem(class_1799 item) {
        if (this.hasItemStorage()) {
            return this.itemStorage.hasItem(item);
        }
        if (this.hasInventory()) {
            return InventoryUtil.GetItemCount(this.inventory, item) >= item.method_7947();
        }
        if (this.hasPlayer()) {
            return InventoryUtil.GetItemCount((class_1263)this.player.method_31548(), item) >= item.method_7947();
        }
        return false;
    }

    public boolean hasItems(class_1799 ... items) {
        for (class_1799 item : InventoryUtil.combineQueryItems(items)) {
            if (this.hasItem(item)) continue;
            return false;
        }
        return true;
    }

    public boolean hasTicket(UUID ticketID) {
        block4: {
            block5: {
                block3: {
                    if (!this.hasItemStorage()) break block3;
                    for (int i = 0; i < this.itemStorage.getSlots(); ++i) {
                        UUID id;
                        class_1799 stack = this.itemStorage.getStackInSlot(i);
                        if (stack.method_7909() != ModItems.TICKET || (id = TicketItem.GetTicketID(stack)) == null || !id.equals(ticketID)) continue;
                        return true;
                    }
                    break block4;
                }
                if (!this.hasInventory()) break block5;
                for (int i = 0; i < this.inventory.method_5439(); ++i) {
                    class_1799 stack = this.inventory.method_5438(i);
                    if (stack.method_7909() != ModItems.TICKET || !ticketID.equals(TicketItem.GetTicketID(stack))) continue;
                    return true;
                }
                break block4;
            }
            if (!this.hasPlayer()) break block4;
            class_1661 inventory = this.player.method_31548();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                UUID id;
                class_1799 stack = inventory.method_5438(i);
                if (stack.method_7909() != ModItems.TICKET || (id = TicketItem.GetTicketID(stack)) == null || !id.equals(ticketID)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean collectItem(class_1799 item) {
        if (this.hasItem(item)) {
            if (this.hasItemStorage()) {
                this.itemStorage.removeItem(item);
                return true;
            }
            if (this.hasInventory()) {
                return InventoryUtil.RemoveItemCount(this.inventory, item);
            }
            if (this.hasPlayer()) {
                InventoryUtil.RemoveItemCount((class_1263)this.player.method_31548(), item);
                return true;
            }
        }
        return false;
    }

    public boolean collectTicket(UUID ticketID) {
        block3: {
            block5: {
                block4: {
                    if (!this.hasTicket(ticketID)) break block3;
                    if (!this.hasItemStorage()) break block4;
                    for (int i = 0; i < this.itemStorage.getSlots(); ++i) {
                        UUID id;
                        class_1799 stack = this.itemStorage.getStackInSlot(i);
                        if (stack.method_7909() != ModItems.TICKET || (id = TicketItem.GetTicketID(stack)) == null || !id.equals(ticketID)) continue;
                        class_1799 extractStack = stack.method_7972();
                        extractStack.method_7939(1);
                        this.itemStorage.removeItem(extractStack);
                    }
                    break block3;
                }
                if (!this.hasInventory()) break block5;
                for (int i = 0; i < this.inventory.method_5439(); ++i) {
                    UUID id;
                    class_1799 stack = this.inventory.method_5438(i);
                    if (stack.method_7909() != ModItems.TICKET || (id = TicketItem.GetTicketID(stack)) == null || !id.equals(ticketID)) continue;
                    this.inventory.method_5434(i, 1);
                    this.inventory.method_5431();
                    return true;
                }
                break block3;
            }
            if (!this.hasPlayer()) break block3;
            class_1661 inventory = this.player.method_31548();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                UUID id;
                class_1799 stack = inventory.method_5438(i);
                if (stack.method_7909() != ModItems.TICKET || (id = TicketItem.GetTicketID(stack)) == null || !id.equals(ticketID)) continue;
                inventory.method_5434(i, 1);
                inventory.method_5431();
                return true;
            }
        }
        return false;
    }

    public boolean canFitItem(class_1799 item) {
        if (item.method_7960()) {
            return true;
        }
        if (this.hasItemStorage()) {
            return this.itemStorage.canFitItem(item);
        }
        if (this.hasInventory()) {
            return InventoryUtil.CanPutItemStack(this.inventory, item);
        }
        return this.hasPlayer();
    }

    public boolean canFitItems(class_1799 ... items) {
        if (this.hasItemStorage()) {
            return this.itemStorage.canFitItems(items);
        }
        if (this.hasInventory()) {
            return InventoryUtil.CanPutItemStacks(this.inventory, items);
        }
        return this.hasPlayer();
    }

    public boolean canFitItems(List<class_1799> items) {
        if (this.hasItemStorage()) {
            return this.itemStorage.canFitItems(items);
        }
        if (this.hasInventory()) {
            return InventoryUtil.CanPutItemStacks(this.inventory, items);
        }
        return this.hasPlayer();
    }

    public boolean putItem(class_1799 item) {
        if (this.canFitItem(item)) {
            if (this.hasItemStorage()) {
                this.itemStorage.forceAddItem(item);
                return true;
            }
            if (this.hasInventory()) {
                return InventoryUtil.PutItemStack(this.inventory, item);
            }
            if (this.hasPlayer()) {
                InventoryUtil.GiveToPlayer(this.player, item);
                return true;
            }
        }
        return false;
    }

    public static TradeContext createStorageMode(TraderData trader) {
        return new Builder(trader).build();
    }

    public static Builder create(TraderData trader, class_1657 player) {
        return new Builder(trader, player);
    }

    public static Builder create(TraderData trader, PlayerReference player) {
        return new Builder(trader, player);
    }

    public static class Builder {
        private final boolean storageMode;
        private final TraderData trader;
        private final class_1657 player;
        private final PlayerReference playerReference;
        private BankAccount.AccountReference bankAccount;
        private class_1263 coinSlots;
        private CoinValue storedCoins;
        private BiConsumer<CoinValue, Boolean> moneyListener;
        private InteractionSlot interactionSlot;
        private TraderItemStorage itemStorage;
        private class_1263 inventory;

        private Builder(TraderData trader) {
            this.storageMode = true;
            this.trader = trader;
            this.player = null;
            this.playerReference = null;
        }

        private Builder(TraderData trader, class_1657 player) {
            this.trader = trader;
            this.player = player;
            this.playerReference = PlayerReference.of(player);
            this.storageMode = false;
        }

        private Builder(TraderData trader, PlayerReference player) {
            this.trader = trader;
            this.playerReference = player;
            this.player = null;
            this.storageMode = false;
        }

        public Builder withBankAccount(BankAccount.AccountReference bankAccount) {
            this.bankAccount = bankAccount;
            return this;
        }

        public Builder withCoinSlots(class_1263 coinSlots) {
            this.coinSlots = coinSlots;
            return this;
        }

        public Builder withStoredCoins(CoinValue storedCoins) {
            this.storedCoins = storedCoins;
            return this;
        }

        public Builder withMoneyListener(BiConsumer<CoinValue, Boolean> moneyListener) {
            this.moneyListener = moneyListener;
            return this;
        }

        public Builder withInteractionSlot(InteractionSlot interactionSlot) {
            this.interactionSlot = interactionSlot;
            return this;
        }

        public Builder withItemStorage(TraderItemStorage itemStorage) {
            this.itemStorage = itemStorage;
            return this;
        }

        public Builder withInventory(class_1263 inventory) {
            this.inventory = inventory;
            return this;
        }

        public TradeContext build() {
            return new TradeContext(this);
        }
    }

    public static enum TradeResult {
        SUCCESS(null),
        FAIL_OUT_OF_STOCK("lightmanscurrency.remotetrade.fail.nostock"),
        FAIL_CANNOT_AFFORD("lightmanscurrency.remotetrade.fail.cantafford"),
        FAIL_NO_OUTPUT_SPACE("lightmanscurrency.remotetrade.fail.nospace.output"),
        FAIL_NO_INPUT_SPACE("lightmanscurrency.remotetrade.fail.nospace.input"),
        FAIL_TRADE_RULE_DENIAL("lightmanscurrency.remotetrade.fail.traderule"),
        FAIL_INVALID_TRADE("lightmanscurrency.remotetrade.fail.invalid"),
        FAIL_NOT_SUPPORTED("lightmanscurrency.remotetrade.fail.notsupported"),
        FAIL_NULL("lightmanscurrency.remotetrade.fail.null");

        public final class_2561 failMessage;

        public boolean hasMessage() {
            return this.failMessage != null;
        }

        public boolean isSuccess() {
            return this == SUCCESS;
        }

        private TradeResult(String message) {
            this.failMessage = message == null ? null : class_2561.method_43471((String)message);
        }
    }
}

