/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.client.data.ClientTraderData;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.PersistentAuctionData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageClearClientTraders;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageRemoveClientTrader;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageUpdateClientTrader;
import io.github.lightman314.lightmanscurrency.server.ServerHook;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class TraderSaveData
extends class_18 {
    public static final String PERSISTENT_TRADER_FILENAME = "config/lightmanscurrency/PersistentTraders.json";
    public static final String PERSISTENT_TRADER_SECTION = "Traders";
    public static final String PERSISTENT_AUCTION_SECTION = "Auctions";
    private long nextID = 0L;
    private final Map<Long, TraderData> traderData = new HashMap<Long, TraderData>();
    private final Map<String, PersistentData> persistentTraderData = new HashMap<String, PersistentData>();
    private final List<PersistentAuctionData> persistentAuctionData = new ArrayList<PersistentAuctionData>();
    private JsonObject persistentTraderJson = new JsonObject();

    private void validateAuctionHouse() {
        if (!((Boolean)LCConfig.SERVER.auctionHouseEnabled.get()).booleanValue()) {
            LightmansCurrency.LogInfo("Will not create or validate the auction house as the auction house is disabled.");
            return;
        }
        AtomicBoolean hasAuctionHouse = new AtomicBoolean(false);
        this.traderData.forEach((id, data) -> {
            if (data instanceof AuctionHouseTrader) {
                hasAuctionHouse.set(true);
            }
        });
        if (!hasAuctionHouse.get()) {
            AuctionHouseTrader ah = new AuctionHouseTrader();
            ah.setCreative(null, true);
            long traderID = this.getNextID();
            ah.setID(traderID);
            LightmansCurrency.LogInfo("Successfully created an auction house trader with id '" + traderID + "'!");
            this.traderData.put(traderID, ah);
            this.method_80();
            class_2487 compound = ah.save();
            new SMessageUpdateClientTrader(compound).sendToAll();
        }
    }

    private long getNextID() {
        long id = this.nextID++;
        this.method_80();
        return id;
    }

    public TraderSaveData() {
        this.validateAuctionHouse();
        this.loadPersistentTraders();
    }

    public TraderSaveData(class_2487 compound) {
        this.nextID = compound.method_10537("NextID");
        LightmansCurrency.LogInfo("Loaded NextID (" + this.nextID + ") from tag.");
        class_2499 traderData = compound.method_10554("TraderData", 10);
        for (int i = 0; i < traderData.size(); ++i) {
            try {
                class_2487 traderTag = traderData.method_10602(i);
                TraderData trader = TraderData.Deserialize(false, traderTag);
                if (trader != null) {
                    this.traderData.put(trader.getID(), trader.allowMarkingDirty());
                    continue;
                }
                LightmansCurrency.LogError("Error loading TraderData entry at index " + i);
                continue;
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error loading TraderData", t);
            }
        }
        class_2499 persistentData = compound.method_10554("PersistentData", 10);
        for (int i = 0; i < persistentData.size(); ++i) {
            try {
                class_2487 c = persistentData.method_10602(i);
                String name = c.method_10558("Name");
                long id = c.method_10537("ID");
                class_2487 tag = c.method_10562("Tag");
                this.persistentTraderData.put(name, new PersistentData(id, tag));
                continue;
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error loading Persistent Data", t);
            }
        }
        this.validateAuctionHouse();
        this.loadPersistentTraders();
    }

    public class_2487 method_75(class_2487 compound) {
        compound.method_10544("NextID", this.nextID);
        class_2499 traderData = new class_2499();
        this.traderData.forEach((id, trader) -> {
            if (trader.isPersistent()) {
                try {
                    this.putPersistentTag(trader.getPersistentID(), trader.savePersistentData());
                }
                catch (Throwable t) {
                    LightmansCurrency.LogError("Error saving persistent trader data:", t);
                }
            } else {
                try {
                    traderData.add((Object)trader.save());
                }
                catch (Throwable t) {
                    LightmansCurrency.LogError("Error saving trader data:", t);
                }
            }
        });
        compound.method_10566("TraderData", (class_2520)traderData);
        class_2499 persistentData = new class_2499();
        this.persistentTraderData.forEach((id, data) -> {
            try {
                class_2487 c = new class_2487();
                c.method_10582("Name", id);
                c.method_10544("ID", data.id);
                c.method_10566("Tag", (class_2520)data.tag);
                persistentData.add((Object)c);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error saving Persistent Data:", t);
            }
        });
        compound.method_10566("PersistentData", (class_2520)persistentData);
        return compound;
    }

    private long getPersistentID(String traderID) {
        if (this.persistentTraderData.containsKey(traderID)) {
            return this.persistentTraderData.get((Object)traderID).id;
        }
        return -1L;
    }

    private void putPersistentID(String traderID, long id) {
        if (this.persistentTraderData.containsKey(traderID)) {
            this.persistentTraderData.get((Object)traderID).id = id;
        } else {
            this.persistentTraderData.put(traderID, new PersistentData(id, new class_2487()));
        }
        this.method_80();
    }

    private class_2487 getPersistentTag(String traderID) {
        if (this.persistentTraderData.containsKey(traderID)) {
            return this.persistentTraderData.get((Object)traderID).tag;
        }
        return new class_2487();
    }

    private void putPersistentTag(String traderID, class_2487 tag) {
        if (this.persistentTraderData.containsKey(traderID)) {
            this.persistentTraderData.get((Object)traderID).tag = tag == null ? new class_2487() : tag;
        } else {
            this.persistentTraderData.put(traderID, new PersistentData(-1L, tag == null ? new class_2487() : tag));
        }
        this.method_80();
    }

    public static JsonObject getPersistentTraderJson() {
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null) {
            return tsd.persistentTraderJson;
        }
        return new JsonObject();
    }

    public static JsonArray getPersistentTraderJson(String section) {
        JsonObject json = TraderSaveData.getPersistentTraderJson();
        if (json != null) {
            if (!json.has(section)) {
                JsonArray newSection = new JsonArray();
                json.add(section, (JsonElement)newSection);
            }
            if (json.get(section).isJsonArray()) {
                return json.get(section).getAsJsonArray();
            }
            LightmansCurrency.LogError("Cannot get Persistent Data section '" + section + "' as it is not a JsonArray.");
        }
        return null;
    }

    public static void setPersistentTraderJson(JsonObject newData) {
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null) {
            File ptf = new File(PERSISTENT_TRADER_FILENAME);
            try {
                tsd.loadPersistentTrader(newData);
            }
            catch (Exception e) {
                LightmansCurrency.LogError("Error loading modified Persistent Trader Data. Ignoring request.", e);
                return;
            }
            tsd.persistentTraderJson = newData;
            tsd.savePersistentTraderJson(ptf);
            tsd.resendTraderData();
        }
    }

    public static void setPersistentTraderSection(String section, JsonArray newData) {
        JsonObject json = TraderSaveData.getPersistentTraderJson();
        json.add(section, (JsonElement)newData);
        TraderSaveData.setPersistentTraderJson(json);
    }

    public static void ReloadPersistentTraders() {
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null) {
            tsd.loadPersistentTraders();
            tsd.resendTraderData();
        }
    }

    private void loadPersistentTraders() {
        File ptf = new File(PERSISTENT_TRADER_FILENAME);
        if (!ptf.exists()) {
            this.persistentTraderJson = TraderSaveData.generateDefaultPersistentTraderJson();
            this.savePersistentTraderJson(ptf);
        }
        try {
            this.persistentTraderJson = class_3518.method_15285((String)Files.readString(ptf.toPath()));
            this.loadPersistentTrader(this.persistentTraderJson);
        }
        catch (Throwable e) {
            LightmansCurrency.LogError("Error loading Persistent Traders.", e);
            this.persistentTraderJson = TraderSaveData.generateDefaultPersistentTraderJson();
        }
    }

    private static JsonObject generateDefaultPersistentTraderJson() {
        JsonObject fileData = new JsonObject();
        JsonArray traderList = new JsonArray();
        fileData.add(PERSISTENT_TRADER_SECTION, (JsonElement)traderList);
        JsonArray auctions = new JsonArray();
        fileData.add(PERSISTENT_AUCTION_SECTION, (JsonElement)auctions);
        return fileData;
    }

    private void loadPersistentTrader(JsonObject fileData) throws Exception {
        boolean hadNone = true;
        if (fileData.has(PERSISTENT_TRADER_SECTION)) {
            hadNone = false;
            ArrayList removeTraderList = new ArrayList();
            this.traderData.forEach((id, trader) -> {
                if (trader.isPersistent()) {
                    this.putPersistentTag(trader.getPersistentID(), trader.savePersistentData());
                    removeTraderList.add(id);
                }
            });
            Iterator iterator = removeTraderList.iterator();
            while (iterator.hasNext()) {
                long id2 = (Long)iterator.next();
                this.traderData.remove(id2);
            }
            ArrayList<String> loadedIDs = new ArrayList<String>();
            JsonArray traderList = fileData.getAsJsonArray(PERSISTENT_TRADER_SECTION);
            for (int i = 0; i < traderList.size(); ++i) {
                try {
                    String traderID;
                    JsonObject traderTag = traderList.get(i).getAsJsonObject();
                    if (traderTag.has("ID")) {
                        traderID = traderTag.get("ID").getAsString();
                    } else if (traderTag.has("id")) {
                        traderID = traderTag.get("id").getAsString();
                    } else {
                        throw new Exception("Trader has no defined id.");
                    }
                    if (loadedIDs.contains(traderID)) {
                        throw new Exception("Trader with id '" + traderID + "' already exists. Cannot have duplicate ids.");
                    }
                    TraderData data = TraderData.Deserialize(traderTag);
                    data.loadPersistentData(this.getPersistentTag(traderID));
                    long id3 = this.getPersistentID(traderID);
                    if (id3 < 0L) {
                        id3 = this.getNextID();
                        this.putPersistentID(traderID, id3);
                        this.method_80();
                        LightmansCurrency.LogInfo("Generated new ID for persistent trader '" + traderID + "' (" + id3 + ")");
                    }
                    data.makePersistent(id3, traderID);
                    this.traderData.put(id3, data);
                    loadedIDs.add(traderID);
                    LightmansCurrency.LogInfo("Successfully loaded persistent trader '" + traderID + "' with ID " + id3 + ".");
                    continue;
                }
                catch (Throwable e) {
                    LightmansCurrency.LogError("Error loading Persistent Trader at index " + i, e);
                }
            }
        }
        if (fileData.has(PERSISTENT_AUCTION_SECTION)) {
            hadNone = false;
            this.persistentAuctionData.clear();
            ArrayList<String> loadedIDs = new ArrayList<String>();
            JsonArray auctionList = fileData.getAsJsonArray(PERSISTENT_AUCTION_SECTION);
            for (int i = 0; i < auctionList.size(); ++i) {
                try {
                    JsonObject auctionTag = auctionList.get(i).getAsJsonObject();
                    PersistentAuctionData data = PersistentAuctionData.load(auctionTag);
                    if (loadedIDs.contains(data.id)) {
                        throw new Exception("Auction with id '" + data.id + "' already exists. Cannot have duplicate ids.");
                    }
                    loadedIDs.add(data.id);
                    this.persistentAuctionData.add(data);
                    LightmansCurrency.LogInfo("Successfully loaded persistent auction '" + data.id + "'");
                    continue;
                }
                catch (Throwable e) {
                    LightmansCurrency.LogError("Error loading Persistent Auction at index " + i, e);
                }
            }
        }
        if (hadNone) {
            throw new Exception("Json Data has no 'Traders' or 'Auctions' entry.");
        }
    }

    private void savePersistentTraderJson(File ptf) {
        File dir = new File(ptf.getParent());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (dir.exists()) {
            try {
                ptf.createNewFile();
                String jsonString = FileUtil.GSON.toJson((JsonElement)this.persistentTraderJson);
                FileUtil.writeStringToFile(ptf, jsonString);
                LightmansCurrency.LogInfo("PersistentTraders.json does not exist. Creating a fresh copy.");
            }
            catch (Throwable e) {
                LightmansCurrency.LogError("Error attempting to create 'persistentTraders.json' file.", e);
            }
        }
    }

    private static TraderSaveData get() {
        class_3218 level;
        MinecraftServer server = ServerHook.getServer();
        if (server != null && (level = server.method_30002()) != null) {
            return (TraderSaveData)level.method_17983().method_17924(TraderSaveData::new, TraderSaveData::new, "lightmanscurrency_trader_data");
        }
        return null;
    }

    public static void MarkTraderDirty(class_2487 updateMessage) {
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null) {
            tsd.method_80();
            new SMessageUpdateClientTrader(updateMessage).sendToAll();
        }
    }

    public static long RegisterTrader(TraderData newTrader, @Nullable class_1657 player) {
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null) {
            long newID = tsd.getNextID();
            newTrader.setID(newID);
            tsd.traderData.put(newID, newTrader.allowMarkingDirty());
            tsd.method_80();
            new SMessageUpdateClientTrader(newTrader.save()).sendToAll();
            return newID;
        }
        return -1L;
    }

    public static TraderData DeleteTrader(long traderID) {
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null && tsd.traderData.containsKey(traderID)) {
            TraderData trader = tsd.traderData.get(traderID);
            tsd.traderData.remove(traderID);
            tsd.method_80();
            new SMessageRemoveClientTrader(traderID).sendToAll();
            return trader;
        }
        return null;
    }

    public static List<TraderData> GetAllTraders(boolean isClient) {
        if (isClient) {
            return ClientTraderData.GetAllTraders();
        }
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null) {
            return new ArrayList<TraderData>(tsd.traderData.values());
        }
        return new ArrayList<TraderData>();
    }

    public static List<TraderData> GetAllTerminalTraders(boolean isClient) {
        return TraderSaveData.GetAllTraders(isClient).stream().filter(trader -> trader.showOnTerminal()).collect(Collectors.toList());
    }

    public static TraderData GetTrader(boolean isClient, long traderID) {
        if (isClient) {
            return ClientTraderData.GetTrader(traderID);
        }
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null && tsd.traderData.containsKey(traderID)) {
            return tsd.traderData.get(traderID);
        }
        return null;
    }

    public static void onServerTick(MinecraftServer server) {
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null) {
            if (server.method_3780() % 1200 == 0) {
                tsd.traderData.values().removeIf(traderData -> {
                    if (!traderData.isPersistent() && traderData.shouldRemove(server)) {
                        if (((Boolean)LCConfig.SERVER.safelyEjectMachineContents.get()).booleanValue()) {
                            try {
                                class_3218 level = server.method_3847(traderData.getLevel());
                                class_2338 pos = traderData.getPos();
                                EjectionData e = EjectionData.create((class_1937)level, pos, null, traderData, false);
                                EjectionSaveData.HandleEjectionData((class_1937)level, pos, e);
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                        new SMessageRemoveClientTrader(traderData.getID()).sendToAll();
                        return true;
                    }
                    return false;
                });
            }
            if (server.method_3780() % 20 == 0 && tsd.persistentAuctionData.size() > 0) {
                List traders = tsd.traderData.values().stream().collect(Collectors.toList());
                AuctionHouseTrader ah = null;
                for (int i = 0; i < traders.size() && ah == null; ++i) {
                    if (!(traders.get(i) instanceof AuctionHouseTrader)) continue;
                    ah = (AuctionHouseTrader)traders.get(i);
                }
                if (ah != null) {
                    for (PersistentAuctionData pad : tsd.persistentAuctionData) {
                        AuctionTradeData trade;
                        if (ah.hasPersistentAuction(pad.id) || (trade = pad.createAuction()) == null) continue;
                        ah.addTrade(trade, true);
                        LightmansCurrency.LogInfo("Successfully added Persistent Auction '" + pad.id + "' into the auction house.");
                    }
                }
            }
            tsd.traderData.values().forEach(trader -> trader.onServerTick(server));
        }
    }

    public static void OnPlayerLogin(class_3222 player, PacketSender sender) {
        TraderSaveData tsd = TraderSaveData.get();
        if (tsd != null) {
            new SMessageClearClientTraders().sendTo(player);
            tsd.traderData.forEach((id, trader) -> new SMessageUpdateClientTrader(trader.save()).sendTo(sender));
        }
    }

    private void resendTraderData() {
        new SMessageClearClientTraders().sendToAll();
        this.traderData.forEach((id, trader) -> new SMessageUpdateClientTrader(trader.save()).sendToAll());
    }

    private static class PersistentData {
        public long id;
        public class_2487 tag;

        public PersistentData(long id, class_2487 tag) {
            this.id = id;
            this.tag = tag == null ? new class_2487() : tag;
        }
    }
}

