/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.auction;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.screen.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menu.TraderMenu;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.auction.AuctionCreateTab;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.auction.AuctionStorageTab;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.auction.AuctionTradeCancelTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.money.wallet.WalletHandler;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionPlayerStorage;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.options.PermissionOption;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.network.client.messages.auction.SMessageAttemptBid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class AuctionHouseTrader
extends TraderData {
    public static final class_2960 TYPE = new class_2960("lightmanscurrency", "auction_house");
    public static final IconData ICON = IconData.of(new class_2960("lightmanscurrency", "textures/gui/icons.png"), 96, 16);
    List<AuctionTradeData> trades = new ArrayList<AuctionTradeData>();
    Map<UUID, AuctionPlayerStorage> storage = new HashMap<UUID, AuctionPlayerStorage>();

    @Override
    public boolean showOnTerminal() {
        return true;
    }

    @Override
    public boolean isCreative() {
        return true;
    }

    public AuctionHouseTrader() {
        super(TYPE);
        this.getOwner().SetCustomOwner(class_2561.method_43471((String)"gui.lightmanscurrency.universaltrader.auction.owner"));
    }

    @Override
    public class_5250 getName() {
        return class_2561.method_43471((String)"gui.lightmanscurrency.universaltrader.auction");
    }

    @Override
    public int getTradeCount() {
        return this.trades.size();
    }

    public AuctionTradeData getTrade(int tradeIndex) {
        try {
            return this.trades.get(tradeIndex);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasPersistentAuction(String id) {
        for (AuctionTradeData trade : this.trades) {
            if (!trade.isPersistentID(id) || !trade.isValid()) continue;
            return true;
        }
        return false;
    }

    public int getTradeIndex(AuctionTradeData trade) {
        return this.trades.indexOf(trade);
    }

    @Override
    public void markTradesDirty() {
        this.markDirty(this::saveTrades);
    }

    public AuctionPlayerStorage getStorage(class_1657 player) {
        return this.getStorage(PlayerReference.of(player));
    }

    public AuctionPlayerStorage getStorage(PlayerReference player) {
        if (player == null) {
            return null;
        }
        if (!this.storage.containsKey(player.id)) {
            this.storage.put(player.id, new AuctionPlayerStorage(player));
            this.markStorageDirty();
        }
        return this.storage.get(player.id);
    }

    public void markStorageDirty() {
        this.markDirty(this::saveStorage);
    }

    @Override
    public void onServerTick(MinecraftServer server) {
        long currentTime = System.currentTimeMillis();
        boolean changed = false;
        boolean canDelete = this.getUserCount() <= 0;
        for (int i = 0; i < this.trades.size(); ++i) {
            AuctionTradeData trade = this.trades.get(i);
            if (trade.hasExpired(currentTime)) {
                trade.ExecuteTrade(this);
                changed = true;
            }
            if (!canDelete || trade.isValid()) continue;
            this.trades.remove(i);
            --i;
        }
        if (changed) {
            this.markDirty(this::saveTrades);
            this.markDirty(this::saveStorage);
        }
    }

    @Override
    public int getPermissionLevel(PlayerReference player, String permission) {
        if (Objects.equals(permission, "openStorage")) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getPermissionLevel(class_1657 player, String permission) {
        if (Objects.equals(permission, "openStorage")) {
            return 1;
        }
        return 0;
    }

    @Override
    public void saveAdditional(class_2487 compound) {
        this.saveTrades(compound);
        this.saveStorage(compound);
    }

    @Override
    protected final void saveTrades(class_2487 compound) {
        class_2499 list = new class_2499();
        for (AuctionTradeData trade : this.trades) {
            list.add((Object)trade.getAsNBT());
        }
        compound.method_10566("Trades", (class_2520)list);
    }

    protected final class_2487 saveStorage(class_2487 compound) {
        class_2499 list = new class_2499();
        this.storage.forEach((player, storage) -> list.add((Object)storage.save(new class_2487())));
        compound.method_10566("StorageData", (class_2520)list);
        return compound;
    }

    @Override
    public void loadAdditional(class_2487 compound) {
        int i;
        if (compound.method_10545("Trades")) {
            this.trades.clear();
            class_2499 tradeList = compound.method_10554("Trades", 10);
            for (i = 0; i < tradeList.size(); ++i) {
                this.trades.add(new AuctionTradeData(tradeList.method_10602(i)));
            }
        }
        if (compound.method_10545("StorageData")) {
            this.storage.clear();
            class_2499 storageList = compound.method_10554("StorageData", 10);
            for (i = 0; i < storageList.size(); ++i) {
                AuctionPlayerStorage storageEntry = new AuctionPlayerStorage(storageList.method_10602(i));
                if (storageEntry.getOwner() == null) continue;
                this.storage.put(storageEntry.getOwner().id, storageEntry);
            }
        }
        if (!this.getOwner().hasOwner()) {
            this.getOwner().SetCustomOwner(class_2561.method_43471((String)"gui.lightmanscurrency.universaltrader.auction.owner"));
        }
    }

    @Override
    public void addTrade(class_1657 requestor) {
    }

    @Override
    public void removeTrade(class_1657 requestor) {
    }

    public void addTrade(AuctionTradeData trade, boolean persistent) {
        trade.startTimer();
        if (trade.isValid()) {
            this.trades.add(trade);
            this.markTradesDirty();
        } else {
            LightmansCurrency.LogError("Auction Trade is not fully valid. Unable to add it to the list.");
        }
    }

    @Override
    public TradeContext.TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        if (!context.hasPlayer()) {
            return TradeContext.TradeResult.FAIL_NOT_SUPPORTED;
        }
        new SMessageAttemptBid(this.getID(), tradeIndex).sendTo(context.getPlayer());
        return TradeContext.TradeResult.SUCCESS;
    }

    public void makeBid(class_1657 player, TraderMenu menu, int tradeIndex, CoinValue bidAmount) {
        AuctionTradeData trade = this.getTrade(tradeIndex);
        if (trade == null) {
            return;
        }
        if (trade.hasExpired(System.currentTimeMillis())) {
            return;
        }
        class_1799 wallet = WalletHandler.getWallet(player).getWallet();
        long inventoryValue = MoneyUtil.getValue(menu.getCoinInventory());
        if (!wallet.method_7960()) {
            inventoryValue += MoneyUtil.getValue(WalletItem.getWalletInventory(wallet));
        }
        if (inventoryValue < bidAmount.getRawValue()) {
            return;
        }
        if (trade.tryMakeBid(this, player, bidAmount)) {
            MoneyUtil.ProcessPayment(menu.getCoinInventory(), player, bidAmount);
            this.markDirty(this::saveTrades);
            this.markDirty(this::saveStorage);
        }
    }

    @Override
    public List<? extends TradeData> getTradeData() {
        return this.trades;
    }

    @Override
    public IconData getIcon() {
        return ICON;
    }

    @Override
    public boolean canMakePersistent() {
        return false;
    }

    @Override
    public void saveAdditionalPersistentData(class_2487 compound) {
    }

    @Override
    public void loadAdditionalPersistentData(class_2487 data) {
    }

    @Override
    public Function<TradeData, Boolean> getStorageDisplayFilter(TraderStorageMenu menu) {
        return trade -> {
            if (trade instanceof AuctionTradeData) {
                AuctionTradeData at = (AuctionTradeData)trade;
                return at.isOwner(menu.player) && at.isValid();
            }
            return false;
        };
    }

    @Override
    public void initStorageTabs(TraderStorageMenu menu) {
        menu.setTab(1, new AuctionStorageTab(menu));
        menu.setTab(2, new AuctionTradeCancelTab(menu));
        menu.setTab(10, new AuctionCreateTab(menu));
    }

    @Override
    public boolean shouldRemove(MinecraftServer server) {
        return false;
    }

    @Override
    public void getAdditionalContents(List<class_1799> contents) {
    }

    @Override
    protected class_5250 getDefaultName() {
        return this.getName();
    }

    @Override
    public boolean hasValidTrade() {
        return true;
    }

    @Override
    protected void saveAdditionalToJson(JsonObject json) {
    }

    @Override
    protected void loadAdditionalFromJson(JsonObject json) {
    }

    @Override
    public void addInteractionSlots(List<InteractionSlotData> interactionSlots) {
    }

    @Override
    protected boolean allowAdditionalUpgradeType(UpgradeType type) {
        return false;
    }

    @Override
    public int getTradeStock(int tradeIndex) {
        return 0;
    }

    @Override
    protected void addSettingsTabs(List<SettingsTab> tabs) {
    }

    @Override
    protected void addPermissionOptions(List<PermissionOption> options) {
    }

    @Override
    protected void modifyDefaultAllyPermissions(Map<String, Integer> defaultValues) {
        defaultValues.clear();
    }
}

