/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item.storage;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.traders.item.storage.TraderItemStorage;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;

public class TraderItemInventory
implements class_1278 {
    private final TraderItemStorage storage;
    private final Runnable markDirty;
    private final Function<class_2350, Boolean> allowInputs;
    private final Function<class_2350, Boolean> allowOutputs;

    public TraderItemInventory(TraderItemStorage storage, @Nullable Runnable markDirty, Function<class_2350, Boolean> allowInputs, Function<class_2350, Boolean> allowOutputs) {
        this.storage = storage;
        this.markDirty = markDirty == null ? () -> {} : markDirty;
        this.allowInputs = allowInputs;
        this.allowOutputs = allowOutputs;
    }

    private final List<class_1799> getStorageItems() {
        return this.storage.getContents();
    }

    public int method_5439() {
        return this.getStorageItems().size() + 1;
    }

    public boolean method_5442() {
        return this.getStorageItems().size() == 0;
    }

    public class_1799 method_5438(int slot) {
        return slot == 0 ? class_1799.field_8037 : this.getStorageItems().get(slot - 1);
    }

    public class_1799 method_5434(int slot, int amount) {
        if (slot == 0) {
            return class_1799.field_8037;
        }
        class_1799 removalStack = this.method_5438(slot);
        class_1799 removed = removalStack.method_7972();
        removed.method_7939(Math.min(removalStack.method_7947(), amount));
        if (removed.method_7960()) {
            return class_1799.field_8037;
        }
        return removed;
    }

    public class_1799 method_5441(int slot) {
        return this.method_5434(slot, 64);
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot == 0 && this.storage.allowExternalInput(stack)) {
            this.storage.tryAddItem(stack);
        } else if (slot != 0) {
            LightmansCurrency.LogWarning("Attempted to place item in a non-zero slot of the TraderItemInventory extension. This should not be happening as input is only allowed on slot 0");
        }
    }

    public void method_5431() {
        this.markDirty.run();
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
    }

    public int[] method_5494(class_2350 side) {
        boolean input = this.allowInputs.apply(side);
        boolean output = this.allowOutputs.apply(side);
        if (input && output) {
            return IntStream.range(0, this.method_5439() - 1).toArray();
        }
        if (input) {
            return new int[]{1};
        }
        if (output) {
            return IntStream.range(1, this.method_5439() - 1).toArray();
        }
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 side) {
        return slot == 0 && this.storage.allowExternalInput(stack) && this.allowInputs.apply(side) != false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 side) {
        return slot > 0 && this.storage.allowExternalOutput(stack) && this.allowOutputs.apply(side) != false;
    }
}

