/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.util.FabricStorageUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class TraderItemStorage {
    private final ITraderItemFilter filter;
    private final List<class_1799> storage = new ArrayList<class_1799>();

    public TraderItemStorage(@NotNull ITraderItemFilter filter) {
        this.filter = filter;
    }

    public class_2487 save(class_2487 compound, String tag) {
        class_2499 list = new class_2499();
        for (class_1799 item : this.storage) {
            if (item.method_7960()) continue;
            class_2487 itemTag = new class_2487();
            item.method_7953(itemTag);
            itemTag.method_10569("Count", item.method_7947());
            list.add((Object)itemTag);
        }
        compound.method_10566(tag, (class_2520)list);
        return compound;
    }

    public void load(class_2487 compound, String tag) {
        if (compound.method_10573(tag, 9)) {
            class_2499 list = compound.method_10554(tag, 10);
            this.storage.clear();
            for (int i = 0; i < list.size(); ++i) {
                class_2487 itemTag = list.method_10602(i);
                class_1799 item = class_1799.method_7915((class_2487)itemTag);
                item.method_7939(itemTag.method_10550("Count"));
                if (item.method_7960()) continue;
                this.storage.add(item);
            }
        }
    }

    public List<class_1799> getContents() {
        return this.storage;
    }

    public List<class_1799> getSplitContents() {
        ArrayList<class_1799> contents = new ArrayList<class_1799>();
        for (class_1799 s : this.storage) {
            class_1799 stack = s.method_7972();
            int maxCount = stack.method_7914();
            while (stack.method_7947() > maxCount) {
                contents.add(stack.method_7971(maxCount));
            }
            contents.add(stack);
        }
        return contents;
    }

    public final boolean allowExternalInput(class_1799 stack) {
        ITraderItemFilter iTraderItemFilter = this.filter;
        if (iTraderItemFilter instanceof ITraderInputOutputFilter) {
            ITraderInputOutputFilter f = (ITraderInputOutputFilter)iTraderItemFilter;
            return this.filter.isItemRelevant(stack) && f.allowInput(stack);
        }
        return this.filter.isItemRelevant(stack);
    }

    public final boolean allowExternalOutput(class_1799 stack) {
        ITraderItemFilter iTraderItemFilter = this.filter;
        if (iTraderItemFilter instanceof ITraderInputOutputFilter) {
            ITraderInputOutputFilter f = (ITraderInputOutputFilter)iTraderItemFilter;
            return !this.filter.isItemRelevant(stack) || f.allowOutput(stack);
        }
        return !this.filter.isItemRelevant(stack);
    }

    public int getSlotCount() {
        return this.storage.size();
    }

    public boolean hasItem(class_1799 item) {
        for (class_1799 stack : this.storage) {
            if (!InventoryUtil.ItemMatches(stack, item)) continue;
            return stack.method_7947() >= item.method_7947();
        }
        return false;
    }

    public boolean hasItems(class_1799 ... items) {
        for (class_1799 item : InventoryUtil.combineQueryItems(items)) {
            if (this.hasItem(item)) continue;
            return false;
        }
        return true;
    }

    public boolean allowItem(class_1799 item) {
        if (item.method_7960()) {
            return false;
        }
        return this.filter.isItemRelevant(item);
    }

    public int getMaxAmount() {
        return this.filter.getStorageStackLimit();
    }

    public int getItemCount(class_1799 item) {
        ImmutableList storageCopy = ImmutableList.copyOf(this.storage);
        for (class_1799 stack : storageCopy) {
            if (!InventoryUtil.ItemMatches(item, stack)) continue;
            return stack.method_7947();
        }
        return 0;
    }

    public int getItemTagCount(class_2960 itemTag, class_1792 ... blacklistItems) {
        ArrayList blacklist = Lists.newArrayList((Object[])blacklistItems);
        int count = 0;
        ImmutableList storageCopy = ImmutableList.copyOf(this.storage);
        for (class_1799 stack : storageCopy) {
            if (!InventoryUtil.ItemHasTag(stack, itemTag) || blacklist.contains(stack.method_7909())) continue;
            count += stack.method_7947();
        }
        return count;
    }

    public int getFittableAmount(class_1799 item) {
        if (!this.allowItem(item)) {
            return 0;
        }
        return this.getMaxAmount() - this.getItemCount(item);
    }

    public boolean canFitItem(class_1799 item) {
        return this.getFittableAmount(item) >= item.method_7947();
    }

    public boolean canFitItems(List<class_1799> items) {
        for (class_1799 item : InventoryUtil.combineQueryItems(items)) {
            if (this.canFitItem(item)) continue;
            return false;
        }
        return true;
    }

    public boolean canFitItems(class_1799 ... items) {
        for (class_1799 item : InventoryUtil.combineQueryItems(items)) {
            if (this.canFitItem(item)) continue;
            return false;
        }
        return true;
    }

    public boolean addItem(class_1799 item) {
        if (!this.canFitItem(item)) {
            return false;
        }
        this.forceAddItem(item);
        return true;
    }

    public void tryAddItem(class_1799 item) {
        if (!this.allowItem(item)) {
            return;
        }
        int amountToAdd = Math.min(item.method_7947(), this.getFittableAmount(item));
        if (amountToAdd > 0) {
            class_1799 addStack = item.method_7971(amountToAdd);
            this.forceAddItem(addStack);
        }
    }

    public void forceAddItem(class_1799 item) {
        if (item.method_7960()) {
            return;
        }
        for (class_1799 stack : this.storage) {
            if (!InventoryUtil.ItemMatches(stack, item)) continue;
            stack.method_7933(item.method_7947());
            return;
        }
        this.storage.add(item.method_7972());
    }

    public class_1799 removeItem(class_1799 item) {
        if (!this.hasItem(item)) {
            return class_1799.field_8037;
        }
        for (int i = 0; i < this.storage.size(); ++i) {
            class_1799 stack = this.storage.get(i);
            if (!InventoryUtil.ItemMatches(item, stack)) continue;
            int amountToRemove = Math.min(item.method_7947(), item.method_7914());
            class_1799 output = stack.method_7971(amountToRemove);
            if (stack.method_7960()) {
                this.storage.remove(i);
            }
            return output;
        }
        return class_1799.field_8037;
    }

    public void removeItemTagCount(class_2960 itemTag, int count, List<class_1799> ignoreIfPossible, class_1792 ... blacklistItems) {
        int amountToTake;
        class_1799 stack;
        int i;
        ArrayList blacklist = Lists.newArrayList((Object[])blacklistItems);
        for (i = 0; i < this.storage.size() && count > 0; ++i) {
            stack = this.storage.get(i);
            if (!InventoryUtil.ItemHasTag(stack, itemTag) || blacklist.contains(stack.method_7909()) || TraderItemStorage.ListContains(ignoreIfPossible, stack)) continue;
            amountToTake = Math.min(count, stack.method_7947());
            count -= amountToTake;
            stack.method_7934(amountToTake);
            if (!stack.method_7960()) continue;
            this.storage.remove(i);
            --i;
        }
        for (i = 0; i < this.storage.size() && count > 0; ++i) {
            stack = this.storage.get(i);
            if (!InventoryUtil.ItemHasTag(stack, itemTag) || blacklist.contains(stack.method_7909())) continue;
            amountToTake = Math.min(count, stack.method_7947());
            count -= amountToTake;
            stack.method_7934(amountToTake);
            if (!stack.method_7960()) continue;
            this.storage.remove(i);
            --i;
        }
    }

    private static boolean ListContains(List<class_1799> list, class_1799 stack) {
        for (class_1799 item : list) {
            if (!InventoryUtil.ItemMatches(item, stack)) continue;
            return true;
        }
        return false;
    }

    public int getSlots() {
        return this.storage.size();
    }

    public class_1799 getStackInSlot(int slot) {
        if (slot >= 0 && slot < this.storage.size()) {
            return this.storage.get(slot);
        }
        return class_1799.field_8037;
    }

    public Storage<ItemVariant> BuildStorage(@NotNull Supplier<Boolean> allowInput, @NotNull Supplier<Boolean> allowOutput, @NotNull Runnable markDirty) {
        return new Handler(allowInput, allowOutput, markDirty);
    }

    public static interface ITraderItemFilter {
        public boolean isItemRelevant(class_1799 var1);

        public int getStorageStackLimit();
    }

    public static interface ITraderInputOutputFilter
    extends ITraderItemFilter {
        public boolean allowInput(class_1799 var1);

        public boolean allowOutput(class_1799 var1);
    }

    private class Handler
    implements Storage<ItemVariant> {
        private final Supplier<Boolean> allowInput;
        private final Supplier<Boolean> allowOutput;
        private final Runnable markDirty;

        protected Handler(@NotNull Supplier<Boolean> allowInput, @NotNull Supplier<Boolean> allowOutput, Runnable markDirty) {
            this.allowInput = allowInput;
            this.allowOutput = allowOutput;
            this.markDirty = markDirty;
        }

        protected final TraderItemStorage getStorage() {
            return TraderItemStorage.this;
        }

        protected final void markStorageDirty() {
            this.markDirty.run();
        }

        public boolean supportsInsertion() {
            return this.allowInput.get();
        }

        public boolean supportsExtraction() {
            return this.allowOutput.get();
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (!this.supportsInsertion()) {
                return 0L;
            }
            class_1799 insertStack = FabricStorageUtil.getStack(resource, maxAmount);
            if (this.getStorage().allowExternalInput(insertStack)) {
                class_1799 fillStack = insertStack.method_7972();
                fillStack.method_7939(Math.min(this.getStorage().getFittableAmount(fillStack), (int)maxAmount));
                if (fillStack.method_7960()) {
                    return 0L;
                }
                transaction.addOuterCloseCallback(result -> {
                    if (result.wasCommitted()) {
                        this.getStorage().forceAddItem(fillStack.method_51164());
                        this.markStorageDirty();
                    }
                });
                return fillStack.method_7947();
            }
            return 0L;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (!this.supportsExtraction()) {
                return 0L;
            }
            class_1799 drainStack = FabricStorageUtil.getStack(resource, maxAmount);
            if (this.getStorage().allowExternalOutput(drainStack)) {
                class_1799 removalStack = drainStack.method_7972();
                removalStack.method_7939(Math.min(this.getStorage().getItemCount(removalStack), (int)maxAmount));
                if (removalStack.method_7960()) {
                    return 0L;
                }
                transaction.addOuterCloseCallback(result -> {
                    if (result.wasCommitted()) {
                        this.getStorage().removeItem(removalStack.method_51164());
                        this.markStorageDirty();
                    }
                });
                return removalStack.method_7947();
            }
            return 0L;
        }

        public Iterator<StorageView<ItemVariant>> iterator() {
            ArrayList<HandlerSlot> slotView = new ArrayList<HandlerSlot>();
            List<class_1799> storageItems = this.getStorage().getContents();
            for (int i = 0; i < storageItems.size(); ++i) {
                slotView.add(new HandlerSlot(this, i));
            }
            return FabricStorageUtil.createIterator(slotView);
        }

        private record HandlerSlot(Handler parent, int slot) implements StorageView<ItemVariant>
        {
            private class_1799 getStack() {
                List<class_1799> contents = this.parent.getStorage().getContents();
                return this.slot >= contents.size() ? class_1799.field_8037 : contents.get(this.slot);
            }

            public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
                return this.parent.extract(resource, maxAmount, transaction);
            }

            public boolean isResourceBlank() {
                return this.getResource().isBlank();
            }

            public ItemVariant getResource() {
                return ItemVariant.of((class_1799)this.getStack());
            }

            public long getAmount() {
                return this.getStack().method_7947();
            }

            public long getCapacity() {
                return this.parent.getStorage().getMaxAmount();
            }
        }
    }

    public static class LockedTraderStorage
    extends TraderItemStorage {
        public LockedTraderStorage(ITraderItemFilter filter) {
            super(filter);
        }

        @Override
        public boolean allowItem(class_1799 item) {
            return false;
        }
    }
}

