/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.common.traders.item.storage.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class ItemTradeRestriction {
    public static final class_2960 DEFAULT_BACKGROUND = new class_2960("lightmanscurrency", "item/empty_item_slot");
    public static final Pair<class_2960, class_2960> BACKGROUND = Pair.of((Object)class_1723.field_21668, (Object)DEFAULT_BACKGROUND);
    public static final ItemTradeRestriction NONE = new ItemTradeRestriction();

    public class_1799 modifySellItem(class_1799 sellItem, String customName, ItemTradeData trade) {
        return sellItem;
    }

    public boolean allowSellItem(class_1799 itemStack) {
        return true;
    }

    public class_1799 filterSellItem(class_1799 itemStack) {
        return itemStack;
    }

    public boolean allowItemSelectItem(class_1799 itemStack) {
        return true;
    }

    public boolean allowExtraItemInStorage(class_1799 itemStack) {
        return false;
    }

    public int getSaleStock(TraderItemStorage traderStorage, class_1799 ... sellItemList) {
        int minStock = Integer.MAX_VALUE;
        for (class_1799 sellItem : InventoryUtil.combineQueryItems(sellItemList)) {
            minStock = Math.min(this.getItemStock(sellItem, traderStorage), minStock);
        }
        return minStock;
    }

    protected final int getItemStock(class_1799 sellItem, TraderItemStorage traderStorage) {
        if (sellItem.method_7960()) {
            return Integer.MAX_VALUE;
        }
        return traderStorage.getItemCount(sellItem) / sellItem.method_7947();
    }

    public void removeItemsFromStorage(TraderItemStorage traderStorage, class_1799 ... sellItemList) {
        for (class_1799 sellItem : sellItemList) {
            this.removeFromStorage(sellItem, traderStorage);
        }
    }

    protected final void removeFromStorage(class_1799 sellItem, TraderItemStorage traderStorage) {
        if (sellItem.method_7960()) {
            return;
        }
        traderStorage.removeItem(sellItem);
    }

    @Environment(value=EnvType.CLIENT)
    public Pair<class_2960, class_2960> getEmptySlotBG() {
        return BACKGROUND;
    }
}

