/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.paygate;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.screen.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.PaygateBlockEntity;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.paygate.PaygateTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.paygate.PaygateNotification;
import io.github.lightman314.lightmanscurrency.common.traders.ITradeSource;
import io.github.lightman314.lightmanscurrency.common.traders.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.PaygateTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.options.PermissionOption;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.server.ServerHook;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class PaygateTraderData
extends TraderData
implements ITradeSource<PaygateTradeData> {
    public static final class_2960 TYPE = new class_2960("lightmanscurrency", "paygate");
    public static final int DURATION_MIN = 1;
    public static final int DURATION_MAX = 1200;
    protected List<PaygateTradeData> trades = PaygateTradeData.listOfSize(1);
    private PaygateBlockEntity cachedBE = null;

    @Override
    public boolean canShowOnTerminal() {
        return false;
    }

    public PaygateTraderData() {
        super(TYPE);
    }

    public PaygateTraderData(class_1937 level, class_2338 pos) {
        super(TYPE, level, pos);
    }

    @Override
    public int getTradeCount() {
        return this.trades.size();
    }

    @Override
    public IconData getIcon() {
        return IconData.of((class_1935)class_1802.field_8793);
    }

    @Override
    protected boolean allowAdditionalUpgradeType(UpgradeType type) {
        return false;
    }

    @Override
    public boolean canEditTradeCount() {
        return true;
    }

    @Override
    public int getMaxTradeCount() {
        return 8;
    }

    @Override
    public void addTrade(class_1657 requestor) {
        if (this.isClient()) {
            return;
        }
        if (this.getTradeCount() >= 32) {
            return;
        }
        if (this.getTradeCount() >= this.getMaxTradeCount() && !CommandLCAdmin.isAdminPlayer(requestor)) {
            Permissions.PermissionWarning(requestor, "add creative trade slot", "LC_ADMIN_MODE");
            return;
        }
        if (!this.hasPermission(requestor, "editTrades")) {
            Permissions.PermissionWarning(requestor, "add trade slot", "editTrades");
            return;
        }
        this.overrideTradeCount(this.getTradeCount() + 1);
    }

    @Override
    public void removeTrade(class_1657 requestor) {
        if (this.isClient()) {
            return;
        }
        if (this.getTradeCount() <= 1) {
            return;
        }
        if (!this.hasPermission(requestor, "editTrades")) {
            Permissions.PermissionWarning(requestor, "remove trade slot", "editTrades");
            return;
        }
        this.overrideTradeCount(this.getTradeCount() - 1);
    }

    public void overrideTradeCount(int newTradeCount) {
        if (this.getTradeCount() == newTradeCount) {
            return;
        }
        int tradeCount = MathUtil.clamp(newTradeCount, 1, 32);
        List<PaygateTradeData> oldTrades = this.trades;
        this.trades = PaygateTradeData.listOfSize(tradeCount);
        for (int i = 0; i < oldTrades.size() && i < this.trades.size(); ++i) {
            this.trades.set(i, oldTrades.get(i));
        }
        this.markTradesDirty();
    }

    @Override
    public PaygateTradeData getTrade(int tradeSlot) {
        if (tradeSlot < 0 || tradeSlot >= this.trades.size()) {
            LightmansCurrency.LogError("Cannot get trade in index " + tradeSlot + " from a trader with only " + this.trades.size() + " trades.");
            return new PaygateTradeData();
        }
        return this.trades.get(tradeSlot);
    }

    public List<PaygateTradeData> getAllTrades() {
        return new ArrayList<PaygateTradeData>(this.trades);
    }

    @Override
    public List<? extends TradeData> getTradeData() {
        return this.getAllTrades();
    }

    @Override
    public int getTradeStock(int tradeIndex) {
        return 1;
    }

    public void setCachedBE(PaygateBlockEntity be) {
        this.cachedBE = be;
    }

    private PaygateBlockEntity getBlockEntity() {
        if (this.cachedBE != null && !this.cachedBE.method_11015()) {
            return this.cachedBE;
        }
        MinecraftServer server = ServerHook.getServer();
        if (server != null && this.getLevel() != null) {
            class_3218 l = server.method_3847(this.getLevel());
            if (l != null && l.method_22340(this.getPos())) {
                class_2586 be = l.method_8321(this.getPos());
                if (be instanceof PaygateBlockEntity) {
                    return (PaygateBlockEntity)be;
                }
                if (be == null) {
                    LightmansCurrency.LogWarning("Could not get Paygate BE as there is no block entity at its pos (" + this.getPos().method_23854() + "; " + this.getLevel().method_29177() + ")");
                } else {
                    LightmansCurrency.LogWarning("Could not get Paygate BE as its block entity is the wrong type (" + be.getClass().getName() + ")");
                }
            } else if (l == null) {
                LightmansCurrency.LogWarning("Could not get Paygate BE as its dimension isn't loaded.");
            } else {
                LightmansCurrency.LogWarning("Could not get Paygate BE as its pos (" + this.getPos().method_23854() + ";" + this.getLevel().method_29177() + ") isn't loaded.");
            }
        } else if (server == null) {
            LightmansCurrency.LogWarning("Could not get Paygate BE as the Server could not be accessed.");
        } else {
            LightmansCurrency.LogWarning("Could not get Paygate BE as the data has no cached dimension id.");
        }
        return null;
    }

    public boolean isActive() {
        PaygateBlockEntity be = this.getBlockEntity();
        if (be != null) {
            return be.isActive();
        }
        return false;
    }

    private void activate(int duration) {
        PaygateBlockEntity be = this.getBlockEntity();
        if (be != null) {
            be.activate(duration);
        }
    }

    @Override
    public TradeContext.TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        PaygateTradeData trade = this.getTrade(tradeIndex);
        if (trade == null) {
            LightmansCurrency.LogError("Trade at index " + tradeIndex + " is null. Cannot execute trade!");
            return TradeContext.TradeResult.FAIL_INVALID_TRADE;
        }
        if (!trade.isValid()) {
            LightmansCurrency.LogWarning("Trade at index " + tradeIndex + " is not a valid trade. Cannot execute trade.");
            return TradeContext.TradeResult.FAIL_INVALID_TRADE;
        }
        if (this.isActive()) {
            LightmansCurrency.LogWarning("Paygate is already activated. It cannot be activated until the previous timer is completed.");
            return TradeContext.TradeResult.FAIL_OUT_OF_STOCK;
        }
        if (!context.hasPlayerReference()) {
            return TradeContext.TradeResult.FAIL_NULL;
        }
        if (this.runPreTradeEvent(context.getPlayerReference(), trade).isCanceled()) {
            return TradeContext.TradeResult.FAIL_TRADE_RULE_DENIAL;
        }
        CoinValue price = this.runTradeCostEvent(context.getPlayerReference(), trade).getCostResult();
        if (trade.isTicketTrade()) {
            if (!trade.canAfford(context)) {
                LightmansCurrency.LogDebug("Ticket ID " + trade.getTicketID() + " could not be found in the players inventory to pay for trade " + tradeIndex + ". Cannot execute trade.");
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            if (!context.canFitItem(new class_1799((class_1935)ModItems.TICKET_STUB))) {
                LightmansCurrency.LogDebug("Not enough room for the ticket stub. Aborting trade!");
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!context.collectTicket(trade.getTicketID())) {
                LightmansCurrency.LogDebug("Unable to collect the ticket. Aborting Trade!");
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            context.putItem(new class_1799((class_1935)ModItems.TICKET_STUB));
            this.activate(trade.getDuration());
            this.pushNotification(() -> new PaygateNotification(trade, price, context.getPlayerReference(), this.getNotificationCategory()));
            this.runPostTradeEvent(context.getPlayerReference(), trade, price);
            return TradeContext.TradeResult.SUCCESS;
        }
        if (!context.getPayment(price)) {
            LightmansCurrency.LogDebug("Not enough money is present for the trade at index " + tradeIndex + ". Cannot execute trade.");
            return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
        }
        this.activate(trade.getDuration());
        this.pushNotification(() -> new PaygateNotification(trade, price, context.getPlayerReference(), this.getNotificationCategory()));
        if (!this.isCreative()) {
            this.addStoredMoney(price);
        }
        this.runPostTradeEvent(context.getPlayerReference(), trade, price);
        return TradeContext.TradeResult.SUCCESS;
    }

    @Override
    public boolean hasValidTrade() {
        for (PaygateTradeData trade : this.trades) {
            if (!trade.isValid()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        this.saveTrades(compound);
    }

    @Override
    protected final void saveTrades(class_2487 compound) {
        PaygateTradeData.saveAllData(compound, this.trades);
    }

    @Override
    protected void saveAdditionalToJson(JsonObject json) {
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        if (compound.method_10545("Trades")) {
            this.trades = PaygateTradeData.loadAllData(compound);
        }
    }

    @Override
    protected void loadAdditionalFromJson(JsonObject json) {
    }

    @Override
    protected void saveAdditionalPersistentData(class_2487 compound) {
    }

    @Override
    protected void loadAdditionalPersistentData(class_2487 compound) {
    }

    @Override
    protected void getAdditionalContents(List<class_1799> results) {
    }

    @Override
    public void addInteractionSlots(List<InteractionSlotData> interactionSlots) {
    }

    @Override
    public boolean canMakePersistent() {
        return false;
    }

    @Override
    public void initStorageTabs(TraderStorageMenu menu) {
        menu.setTab(2, new PaygateTradeEditTab(menu));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void addSettingsTabs(List<SettingsTab> tabs) {
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void addPermissionOptions(List<PermissionOption> options) {
    }
}

