/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules;

import com.google.common.base.Supplier;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.traders.events.TradeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_5250;
import net.minecraft.class_6379;

public abstract class TradeRule {
    public final class_2960 type;
    private boolean isActive = false;
    static final Map<String, Supplier<TradeRule>> registeredDeserializers = new HashMap<String, Supplier<TradeRule>>();

    public final class_5250 getName() {
        return class_2561.method_43471((String)("traderule." + this.type.method_12836() + "." + this.type.method_12832()));
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public void beforeTrade(TradeEvent.PreTradeEvent event) {
    }

    public void tradeCost(TradeEvent.TradeCostEvent event) {
    }

    public void afterTrade(TradeEvent.PostTradeEvent event) {
    }

    protected TradeRule(class_2960 type) {
        this.type = type;
    }

    public class_2487 save() {
        class_2487 compound = new class_2487();
        compound.method_10582("Type", this.type.toString());
        compound.method_10556("Active", this.isActive);
        this.saveAdditional(compound);
        return compound;
    }

    protected abstract void saveAdditional(class_2487 var1);

    public final void load(class_2487 compound) {
        this.isActive = compound.method_10577("Active");
        this.loadAdditional(compound);
    }

    protected abstract void loadAdditional(class_2487 var1);

    public abstract JsonObject saveToJson(JsonObject var1);

    public abstract void loadFromJson(JsonObject var1);

    public abstract class_2487 savePersistentData();

    public abstract void loadPersistentData(class_2487 var1);

    public abstract IconData getButtonIcon();

    public final void receiveUpdateMessage(class_2487 updateInfo) {
        if (updateInfo.method_10545("SetActive")) {
            this.isActive = updateInfo.method_10577("SetActive");
        }
        this.handleUpdateMessage(updateInfo);
    }

    protected abstract void handleUpdateMessage(class_2487 var1);

    public static void saveRules(class_2487 compound, List<TradeRule> rules, String tag) {
        class_2499 ruleData = new class_2499();
        for (TradeRule rule : rules) {
            ruleData.add((Object)rule.save());
        }
        compound.method_10566(tag, (class_2520)ruleData);
    }

    public static boolean savePersistentData(class_2487 compound, List<TradeRule> rules, String tag) {
        class_2499 ruleData = new class_2499();
        for (TradeRule rule : rules) {
            class_2487 thisRuleData = rule.savePersistentData();
            if (thisRuleData == null) continue;
            thisRuleData.method_10582("Type", rule.type.toString());
            ruleData.add((Object)thisRuleData);
        }
        if (ruleData.size() == 0) {
            return false;
        }
        compound.method_10566(tag, (class_2520)ruleData);
        return true;
    }

    public static JsonArray saveRulesToJson(List<TradeRule> rules) {
        JsonArray ruleData = new JsonArray();
        for (TradeRule rule : rules) {
            JsonObject thisRuleData;
            if (!rule.isActive || (thisRuleData = rule.saveToJson(new JsonObject())) == null) continue;
            thisRuleData.addProperty("Type", rule.type.toString());
            ruleData.add((JsonElement)thisRuleData);
        }
        return ruleData;
    }

    public static List<TradeRule> loadRules(class_2487 compound, String tag) {
        ArrayList<TradeRule> rules = new ArrayList<TradeRule>();
        if (compound.method_10573(tag, 9)) {
            class_2499 ruleData = compound.method_10554(tag, 10);
            for (int i = 0; i < ruleData.size(); ++i) {
                class_2487 thisRuleData = ruleData.method_10602(i);
                TradeRule thisRule = TradeRule.Deserialize(thisRuleData);
                if (thisRule == null) continue;
                rules.add(thisRule);
            }
        }
        return rules;
    }

    public static void loadPersistentData(class_2487 compound, List<TradeRule> tradeRules, String tag) {
        if (compound.method_10573(tag, 9)) {
            class_2499 ruleData = compound.method_10554(tag, 10);
            for (int i = 0; i < ruleData.size(); ++i) {
                class_2487 thisRuleData = ruleData.method_10602(i);
                boolean query = true;
                for (int r = 0; query && r < tradeRules.size(); ++r) {
                    if (!tradeRules.get((int)r).type.toString().contentEquals(thisRuleData.method_10558("Type"))) continue;
                    tradeRules.get(r).loadPersistentData(thisRuleData);
                    query = false;
                }
            }
        }
    }

    public static List<TradeRule> Parse(JsonArray tradeRuleData) {
        ArrayList<TradeRule> rules = new ArrayList<TradeRule>();
        for (int i = 0; i < tradeRuleData.size(); ++i) {
            try {
                JsonObject thisRuleData = tradeRuleData.get(i).getAsJsonObject();
                TradeRule thisRule = TradeRule.Deserialize(thisRuleData);
                rules.add(thisRule);
                continue;
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error loading Trade Rule at index " + i + ".", t);
            }
        }
        return rules;
    }

    public static boolean ValidateTradeRuleList(List<TradeRule> rules, Function<TradeRule, Boolean> allowed) {
        boolean changed = false;
        for (Supplier<TradeRule> ruleSource : registeredDeserializers.values()) {
            TradeRule rule = (TradeRule)ruleSource.get();
            if (rule == null || !allowed.apply(rule).booleanValue() || TradeRule.HasTradeRule(rules, rule.type)) continue;
            rules.add(rule);
            changed = true;
        }
        return changed;
    }

    public static boolean HasTradeRule(List<TradeRule> rules, class_2960 type) {
        return TradeRule.GetTradeRule(rules, type) != null;
    }

    public static TradeRule GetTradeRule(List<TradeRule> rules, class_2960 type) {
        for (TradeRule rule : rules) {
            if (!rule.type.equals((Object)type)) continue;
            return rule;
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public abstract GUIHandler createHandler(TradeRuleScreen var1, Supplier<TradeRule> var2);

    public static void RegisterDeserializer(class_2960 type, Supplier<TradeRule> deserializer) {
        TradeRule.RegisterDeserializer(type, deserializer, false);
    }

    public static void RegisterDeserializer(class_2960 type, Supplier<TradeRule> deserializer, boolean suppressDebugMessage) {
        TradeRule.RegisterDeserializer(type.toString(), deserializer, suppressDebugMessage);
    }

    private static void RegisterDeserializer(String type, Supplier<TradeRule> deserializer, boolean suppressDebugMessage) {
        if (registeredDeserializers.containsKey(type)) {
            LightmansCurrency.LogWarning("A trade rule deserializer of type '" + type + "' has already been registered.");
            return;
        }
        registeredDeserializers.put(type, deserializer);
        if (!suppressDebugMessage) {
            LightmansCurrency.LogInfo("Registered trade rule deserializer of type " + type);
        }
    }

    public static TradeRule CreateRule(class_2960 ruleType) {
        String thisType = ruleType.toString();
        AtomicReference data = new AtomicReference();
        registeredDeserializers.forEach((type, deserializer) -> {
            if (thisType.equals(type)) {
                TradeRule rule = (TradeRule)deserializer.get();
                data.set(rule);
            }
        });
        if (data.get() != null) {
            return (TradeRule)data.get();
        }
        LightmansCurrency.LogError("Could not find a deserializer of type '" + thisType + "'. Unable to load the Trade Rule.");
        return null;
    }

    public static TradeRule Deserialize(class_2487 compound) {
        String thisType;
        String string = thisType = compound.method_10545("Type") ? compound.method_10558("Type") : compound.method_10558("type");
        if (registeredDeserializers.containsKey(thisType)) {
            try {
                TradeRule rule = (TradeRule)registeredDeserializers.get(thisType).get();
                rule.load(compound);
                return rule;
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error deserializing trade rule:", t);
            }
        }
        LightmansCurrency.LogError("Could not find a deserializer of type '" + thisType + "'. Unable to load the Trade Rule.");
        return null;
    }

    public static TradeRule Deserialize(JsonObject json) throws Exception {
        String thisType = json.get("Type").getAsString();
        if (registeredDeserializers.containsKey(thisType)) {
            TradeRule rule = (TradeRule)registeredDeserializers.get(thisType).get();
            rule.loadFromJson(json);
            rule.setActive(true);
            return rule;
        }
        throw new Exception("Could not find a deserializer of type '" + thisType + "'.");
    }

    public static TradeRule getRule(class_2960 type, List<TradeRule> rules) {
        for (TradeRule rule : rules) {
            if (!rule.type.equals((Object)type)) continue;
            return rule;
        }
        return null;
    }

    public static class_2487 CreateRuleMessage() {
        class_2487 tag = new class_2487();
        tag.method_10556("Create", true);
        return tag;
    }

    public static class_2487 RemoveRuleMessage() {
        class_2487 tag = new class_2487();
        tag.method_10556("Remove", true);
        return tag;
    }

    public static boolean isCreateMessage(class_2487 tag) {
        return tag.method_10545("Create") && tag.method_10577("Create");
    }

    public static boolean isRemoveMessage(class_2487 tag) {
        return tag.method_10545("Remove") && tag.method_10577("Remove");
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class GUIHandler {
        protected final TradeRuleScreen screen;
        private final Supplier<TradeRule> rule;

        protected final TradeRule getRuleRaw() {
            return (TradeRule)this.rule.get();
        }

        protected GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            this.screen = screen;
            this.rule = rule;
        }

        public abstract void initTab();

        public abstract void renderTab(class_332 var1, int var2, int var3, float var4);

        public abstract void onTabClose();

        public void onScreenTick() {
        }

        public <T extends class_364 & class_4068> T addCustomRenderable(T widget) {
            return this.screen.addCustomRenderable(widget);
        }

        public <T extends class_364 & class_6379> T addCustomWidget(T widget) {
            return this.screen.addCustomWidget(widget);
        }

        public <T extends class_364> void removeCustomWidget(T widget) {
            this.screen.removeCustomWidget(widget);
        }
    }
}

