/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.common.base.Supplier;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeInputWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.traders.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5250;

public class PlayerTradeLimit
extends TradeRule {
    public static final class_2960 TYPE = new class_2960("lightmanscurrency", "player_trade_limit");
    private int limit = 1;
    private long timeLimit = 0L;
    Map<UUID, List<Long>> memory = new HashMap<UUID, List<Long>>();

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int newLimit) {
        this.limit = newLimit;
    }

    private boolean enforceTimeLimit() {
        return this.timeLimit > 0L;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int newValue) {
        this.timeLimit = newValue;
    }

    public void resetMemory() {
        this.memory.clear();
    }

    public PlayerTradeLimit() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        int tradeCount = this.getTradeCount(event.getPlayerReference().id);
        if (tradeCount >= this.limit) {
            if (this.enforceTimeLimit()) {
                event.addDenial(class_2561.method_43469((String)"traderule.lightmanscurrency.tradelimit.denial.timed", (Object[])new Object[]{tradeCount, new TimeUtil.TimeData(this.getTimeLimit()).getString()}));
            } else {
                event.addDenial(class_2561.method_43469((String)"traderule.lightmanscurrency.tradelimit.denial", (Object[])new Object[]{tradeCount}));
            }
            event.addDenial(class_2561.method_43469((String)"traderule.lightmanscurrency.tradelimit.denial.limit", (Object[])new Object[]{this.limit}));
        } else if (this.enforceTimeLimit()) {
            event.addHelpful(class_2561.method_43469((String)"traderule.lightmanscurrency.tradelimit.info.timed", (Object[])new Object[]{tradeCount, this.limit, new TimeUtil.TimeData(this.getTimeLimit()).getString()}));
        } else {
            event.addHelpful(class_2561.method_43469((String)"traderule.lightmanscurrency.tradelimit.info", (Object[])new Object[]{tradeCount, this.limit}));
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        this.addEvent(event.getPlayerReference().id, TimeUtil.getCurrentTime());
        this.clearExpiredData();
        event.markDirty();
    }

    private void addEvent(UUID player, Long time) {
        List<Long> eventTimes = new ArrayList<Long>();
        if (this.memory.containsKey(player)) {
            eventTimes = this.memory.get(player);
        }
        eventTimes.add(time);
        this.memory.put(player, eventTimes);
    }

    private void clearExpiredData() {
        if (!this.enforceTimeLimit()) {
            return;
        }
        ArrayList emptyEntries = new ArrayList();
        this.memory.forEach((id, eventTimes) -> {
            for (int i = 0; i < eventTimes.size(); ++i) {
                if (TimeUtil.compareTime(this.timeLimit, (Long)eventTimes.get(i))) continue;
                eventTimes.remove(i);
                --i;
            }
            if (eventTimes.size() <= 0) {
                emptyEntries.add(id);
            }
        });
        emptyEntries.forEach(id -> this.memory.remove(id));
    }

    private int getTradeCount(UUID playerID) {
        int count = 0;
        if (this.memory.containsKey(playerID)) {
            List<Long> eventTimes = this.memory.get(playerID);
            if (!this.enforceTimeLimit()) {
                return eventTimes.size();
            }
            for (Long eventTime : eventTimes) {
                if (!TimeUtil.compareTime(this.timeLimit, eventTime)) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        compound.method_10569("Limit", this.limit);
        class_2499 memoryList = new class_2499();
        this.memory.forEach((id, eventTimes) -> {
            class_2487 thisMemory = new class_2487();
            thisMemory.method_25927("ID", id);
            thisMemory.method_10538("Times", eventTimes);
            memoryList.add((Object)thisMemory);
        });
        compound.method_10566("Memory", (class_2520)memoryList);
        compound.method_10544("ForgetTime", this.timeLimit);
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        json.addProperty("Limit", (Number)this.limit);
        if (this.enforceTimeLimit()) {
            json.addProperty("ForgetTime", (Number)this.timeLimit);
        }
        return json;
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        if (compound.method_10573("Limit", 3)) {
            this.limit = compound.method_10550("Limit");
        }
        if (compound.method_10573("Memory", 9)) {
            this.memory.clear();
            class_2499 memoryList = compound.method_10554("Memory", 10);
            for (int i = 0; i < memoryList.size(); ++i) {
                class_2487 thisMemory = memoryList.method_10602(i);
                UUID id = null;
                ArrayList<Long> eventTimes = new ArrayList<Long>();
                if (thisMemory.method_10545("ID")) {
                    id = thisMemory.method_25926("ID");
                }
                if (thisMemory.method_10573("Times", 12)) {
                    for (long time : thisMemory.method_10565("Times")) {
                        eventTimes.add(time);
                    }
                }
                this.memory.put(id, eventTimes);
            }
        }
        if (compound.method_10573("ForgetTime", 4)) {
            this.timeLimit = compound.method_10537("ForgetTime");
        }
    }

    @Override
    public void handleUpdateMessage(class_2487 updateInfo) {
        if (updateInfo.method_10545("Limit")) {
            this.limit = updateInfo.method_10550("Limit");
        } else if (updateInfo.method_10545("TimeLimit")) {
            this.timeLimit = updateInfo.method_10537("TimeLimit");
        } else if (updateInfo.method_10545("ClearMemory")) {
            this.resetMemory();
        }
    }

    @Override
    public class_2487 savePersistentData() {
        class_2487 data = new class_2487();
        class_2499 memoryList = new class_2499();
        this.memory.forEach((id, eventTimes) -> {
            class_2487 thisMemory = new class_2487();
            thisMemory.method_25927("ID", id);
            thisMemory.method_10538("Times", eventTimes);
            memoryList.add((Object)thisMemory);
        });
        data.method_10566("Memory", (class_2520)memoryList);
        return data;
    }

    @Override
    public void loadPersistentData(class_2487 data) {
        if (data.method_10573("Memory", 9)) {
            this.memory.clear();
            class_2499 memoryList = data.method_10554("Memory", 10);
            for (int i = 0; i < memoryList.size(); ++i) {
                class_2487 thisMemory = memoryList.method_10602(i);
                UUID id = null;
                ArrayList<Long> eventTimes = new ArrayList<Long>();
                if (thisMemory.method_10545("ID")) {
                    id = thisMemory.method_25926("ID");
                }
                if (thisMemory.method_10573("Times", 12)) {
                    for (long time : thisMemory.method_10565("Times")) {
                        eventTimes.add(time);
                    }
                }
                this.memory.put(id, eventTimes);
            }
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("Limit")) {
            this.limit = json.get("Limit").getAsInt();
        }
        if (json.has("ForgetTime")) {
            this.timeLimit = json.get("ForgetTime").getAsLong();
        }
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_COUNT_PLAYER;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @Environment(value=EnvType.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        class_342 limitInput;
        class_4185 buttonSetLimit;
        class_4185 buttonClearMemory;
        TimeInputWidget timeInput;

        private PlayerTradeLimit getRule() {
            if (this.getRuleRaw() instanceof PlayerTradeLimit) {
                return (PlayerTradeLimit)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            this.limitInput = this.addCustomRenderable(new class_342(this.screen.getFont(), this.screen.guiLeft() + 10, this.screen.guiTop() + 19, 30, 20, (class_2561)class_2561.method_43473()));
            this.limitInput.method_1880(3);
            this.limitInput.method_1852(Integer.toString(this.getRule().limit));
            this.buttonSetLimit = this.addCustomRenderable(new VanillaButton(this.screen.guiLeft() + 41, this.screen.guiTop() + 19, 40, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.playerlimit.setlimit"), this::PressSetLimitButton));
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 50;
            Objects.requireNonNull(this.screen);
            this.buttonClearMemory = this.addCustomRenderable(new VanillaButton(n, n2, 176 - 20, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.playerlimit.clearmemory"), this::PressClearMemoryButton));
            this.timeInput = this.addCustomRenderable(new TimeInputWidget(this.screen.guiLeft() + 48, this.screen.guiTop() + 87, 10, TimeUtil.TimeUnit.DAY, TimeUtil.TimeUnit.MINUTE, this::addCustomRenderable, this::onTimeSet));
            this.timeInput.setTime(this.getRule().timeLimit);
        }

        @Override
        public void renderTab(class_332 gui, int mouseX, int mouseY, float partialTicks) {
            gui.method_51433(this.screen.getFont(), class_2561.method_43469((String)"gui.button.lightmanscurrency.playerlimit.info", (Object[])new Object[]{this.getRule().limit}).getString(), this.screen.guiLeft() + 10, this.screen.guiTop() + 9, 0xFFFFFF, false);
            class_5250 text = this.getRule().timeLimit > 0L ? class_2561.method_43469((String)"gui.widget.lightmanscurrency.playerlimit.duration", (Object[])new Object[]{new TimeUtil.TimeData(this.getRule().timeLimit).getShortString()}) : class_2561.method_43471((String)"gui.widget.lightmanscurrency.playerlimit.noduration");
            int n = this.screen.guiLeft();
            Objects.requireNonNull(this.screen);
            TextRenderUtil.drawCenteredText(gui, (class_2561)text, n + 176 / 2, this.screen.guiTop() + 75, 0xFFFFFF);
            if (this.buttonClearMemory.method_25405((double)mouseX, (double)mouseY)) {
                gui.method_51438(this.screen.getFont(), (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.playerlimit.clearmemory.tooltip"), mouseX, mouseY);
            }
        }

        @Override
        public void onTabClose() {
            this.removeCustomWidget(this.limitInput);
            this.removeCustomWidget(this.buttonSetLimit);
            this.removeCustomWidget(this.buttonClearMemory);
            this.timeInput.removeChildren(this::removeCustomWidget);
            this.removeCustomWidget(this.timeInput);
        }

        @Override
        public void onScreenTick() {
            TextInputUtil.whitelistInteger(this.limitInput, 1L, 100L);
        }

        void PressSetLimitButton(class_4185 button) {
            int limit;
            this.getRule().limit = limit = MathUtil.clamp(TextInputUtil.getIntegerValue(this.limitInput), 1, 100);
            class_2487 updateInfo = new class_2487();
            updateInfo.method_10569("Limit", limit);
            this.screen.sendUpdateMessage(this.getRuleRaw(), updateInfo);
        }

        void PressClearMemoryButton(class_4185 button) {
            this.getRule().memory.clear();
            class_2487 updateInfo = new class_2487();
            updateInfo.method_10556("ClearMemory", true);
            this.screen.sendUpdateMessage(this.getRuleRaw(), updateInfo);
        }

        public void onTimeSet(TimeUtil.TimeData newTime) {
            long timeLimit;
            this.getRule().timeLimit = timeLimit = MathUtil.clamp(newTime.miliseconds, 0L, Long.MAX_VALUE);
            class_2487 updateInfo = new class_2487();
            updateInfo.method_10544("TimeLimit", timeLimit);
            this.screen.sendUpdateMessage(this.getRuleRaw(), updateInfo);
        }
    }
}

