/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;

public class PlayerWhitelist
extends TradeRule {
    public static final class_2960 TYPE = new class_2960("lightmanscurrency", "whitelist");
    List<PlayerReference> whitelistedPlayers = new ArrayList<PlayerReference>();

    public PlayerWhitelist() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (!this.isWhitelisted(event.getPlayerReference())) {
            event.addDenial(class_2561.method_43471((String)"traderule.lightmanscurrency.whitelist.denial"));
        } else {
            event.addHelpful(class_2561.method_43471((String)"traderule.lightmanscurrency.whitelist.allowed"));
        }
    }

    public boolean isWhitelisted(PlayerReference player) {
        for (PlayerReference whitelistedPlayer : this.whitelistedPlayers) {
            if (!whitelistedPlayer.is(player)) continue;
            return true;
        }
        return false;
    }

    public boolean addToWhitelist(class_1657 player) {
        PlayerReference pr = PlayerReference.of(player);
        if (!this.isWhitelisted(pr)) {
            this.whitelistedPlayers.add(pr);
            return true;
        }
        return false;
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        class_2499 playerNameList = new class_2499();
        for (PlayerReference whitelistedPlayer : this.whitelistedPlayers) {
            playerNameList.add((Object)whitelistedPlayer.save());
        }
        compound.method_10566("WhitelistedPlayers", (class_2520)playerNameList);
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        return json;
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        if (compound.method_10573("WhitelistedPlayers", 9)) {
            this.whitelistedPlayers.clear();
            class_2499 playerList = compound.method_10554("WhitelistedPlayers", 10);
            for (int i = 0; i < playerList.size(); ++i) {
                PlayerReference reference = PlayerReference.load(playerList.method_10602(i));
                if (reference == null) continue;
                this.whitelistedPlayers.add(reference);
            }
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
    }

    @Override
    public void handleUpdateMessage(class_2487 updateInfo) {
        boolean add = updateInfo.method_10577("Add");
        String name = updateInfo.method_10558("Name");
        PlayerReference player = PlayerReference.of(false, name);
        if (player == null) {
            return;
        }
        if (add && !this.isWhitelisted(player)) {
            this.whitelistedPlayers.add(player);
        } else if (!add && this.isWhitelisted(player)) {
            PlayerReference.removeFromList(this.whitelistedPlayers, player);
        }
    }

    @Override
    public class_2487 savePersistentData() {
        class_2487 compound = new class_2487();
        this.saveAdditional(compound);
        return compound;
    }

    @Override
    public void loadPersistentData(class_2487 data) {
        this.loadAdditional(data);
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_WHITELIST;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @Environment(value=EnvType.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        class_342 nameInput;
        class_4185 buttonAddPlayer;
        class_4185 buttonRemovePlayer;
        ScrollTextDisplay playerDisplay;

        protected final PlayerWhitelist getWhitelistRule() {
            if (this.getRuleRaw() instanceof PlayerWhitelist) {
                return (PlayerWhitelist)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            class_327 class_3272 = this.screen.getFont();
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 9;
            Objects.requireNonNull(this.screen);
            this.nameInput = this.addCustomRenderable(new class_342(class_3272, n, n2, 176 - 20, 20, (class_2561)class_2561.method_43473()));
            this.buttonAddPlayer = this.screen.addCustomRenderable(new VanillaButton(this.screen.guiLeft() + 10, this.screen.guiTop() + 30, 78, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.whitelist.add"), this::PressWhitelistButton));
            int n3 = this.screen.guiLeft();
            Objects.requireNonNull(this.screen);
            this.buttonRemovePlayer = this.screen.addCustomRenderable(new VanillaButton(n3 + 176 - 88, this.screen.guiTop() + 30, 78, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.whitelist.remove"), this::PressForgetButton));
            int n4 = this.screen.guiLeft() + 7;
            int n5 = this.screen.guiTop() + 55;
            Objects.requireNonNull(this.screen);
            this.playerDisplay = this.screen.addCustomRenderable(new ScrollTextDisplay(n4, n5, 176 - 14, 114, this.screen.getFont(), (Supplier<List<? extends class_2561>>)((Supplier)this::getWhitelistedPlayers)));
            this.playerDisplay.setColumnCount(2);
        }

        private List<class_2561> getWhitelistedPlayers() {
            ArrayList playerList = Lists.newArrayList();
            if (this.getWhitelistRule() == null) {
                return playerList;
            }
            for (PlayerReference player : this.getWhitelistRule().whitelistedPlayers) {
                playerList.add(player.getNameComponent(true));
            }
            return playerList;
        }

        @Override
        public void renderTab(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        }

        @Override
        public void onTabClose() {
            this.removeCustomWidget(this.nameInput);
            this.removeCustomWidget(this.buttonAddPlayer);
            this.removeCustomWidget(this.buttonRemovePlayer);
            this.removeCustomWidget(this.playerDisplay);
        }

        void PressWhitelistButton(class_4185 button) {
            String name = this.nameInput.method_1882();
            if (!name.isBlank()) {
                this.nameInput.method_1852("");
                class_2487 updateInfo = new class_2487();
                updateInfo.method_10556("Add", true);
                updateInfo.method_10582("Name", name);
                this.screen.sendUpdateMessage(this.getRuleRaw(), updateInfo);
            }
        }

        void PressForgetButton(class_4185 button) {
            String name = this.nameInput.method_1882();
            if (!name.isBlank()) {
                this.nameInput.method_1852("");
                class_2487 updateInfo = new class_2487();
                updateInfo.method_10556("Add", false);
                updateInfo.method_10582("Name", name);
                this.screen.sendUpdateMessage(this.getRuleRaw(), updateInfo);
            }
        }
    }
}

