/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.common.base.Supplier;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeInputWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.traders.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5250;

public class TimedSale
extends TradeRule {
    public static final class_2960 TYPE = new class_2960("lightmanscurrency", "timed_sale");
    long startTime = 0L;
    long duration = 0L;
    int discount = 10;

    boolean timerActive() {
        return this.startTime != 0L;
    }

    public int getDiscountPercent() {
        return this.discount;
    }

    public void setDiscountPercent(int percent) {
        this.discount = MathUtil.clamp(percent, 0, 100);
    }

    private double getDiscountMult() {
        return 1.0 - (double)this.discount / 100.0;
    }

    private double getIncreaseMult() {
        return 1.0 + (double)this.discount / 100.0;
    }

    public TimedSale() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.timerActive() && TimeUtil.compareTime(this.duration, this.startTime)) {
            switch (event.getTrade().getTradeDirection()) {
                case SALE: {
                    event.addHelpful(class_2561.method_43469((String)"traderule.lightmanscurrency.timed_sale.info.sale", (Object[])new Object[]{this.discount, this.getTimeRemaining().getString()}));
                    break;
                }
                case PURCHASE: {
                    event.addHelpful(class_2561.method_43469((String)"traderule.lightmanscurrency.timed_sale.info.purchase", (Object[])new Object[]{this.discount, this.getTimeRemaining().getString()}));
                    break;
                }
            }
        }
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        if (this.timerActive() && TimeUtil.compareTime(this.duration, this.startTime)) {
            switch (event.getTrade().getTradeDirection()) {
                case SALE: {
                    event.applyCostMultiplier(this.getDiscountMult());
                    break;
                }
                case PURCHASE: {
                    event.applyCostMultiplier(this.getIncreaseMult());
                    break;
                }
            }
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        if (this.confirmStillActive()) {
            event.markDirty();
        }
    }

    private boolean confirmStillActive() {
        if (!this.timerActive()) {
            return false;
        }
        if (!TimeUtil.compareTime(this.duration, this.startTime)) {
            this.startTime = 0L;
            return true;
        }
        return false;
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        compound.method_10544("StartTime", this.startTime);
        compound.method_10544("Duration", this.duration);
        compound.method_10569("Discount", this.discount);
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        json.addProperty("Duration", (Number)this.duration);
        json.addProperty("Discount", (Number)this.discount);
        return json;
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        if (compound.method_10573("StartTime", 4)) {
            this.startTime = compound.method_10537("StartTime");
        }
        if (compound.method_10573("Duration", 4)) {
            this.duration = compound.method_10537("Duration");
        }
        if (compound.method_10573("Discount", 3)) {
            this.discount = compound.method_10550("Discount");
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("duration")) {
            this.duration = json.get("duration").getAsLong();
        }
        if (json.has("discount")) {
            this.discount = MathUtil.clamp(this.discount, 0, 100);
        }
    }

    @Override
    public void handleUpdateMessage(class_2487 updateInfo) {
        if (updateInfo.method_10545("Discount")) {
            this.discount = updateInfo.method_10550("Discount");
        } else if (updateInfo.method_10545("Duration")) {
            this.duration = updateInfo.method_10537("Duration");
        } else if (updateInfo.method_10545("StartSale")) {
            if (this.timerActive() == updateInfo.method_10577("StartSale")) {
                return;
            }
            this.startTime = this.timerActive() ? 0L : TimeUtil.getCurrentTime();
        }
    }

    @Override
    public class_2487 savePersistentData() {
        class_2487 compound = new class_2487();
        compound.method_10544("StartTime", this.startTime);
        return compound;
    }

    @Override
    public void loadPersistentData(class_2487 data) {
        if (data.method_10573("StartTime", 4)) {
            this.startTime = data.method_10537("StartTime");
        }
    }

    public TimeUtil.TimeData getTimeRemaining() {
        if (!this.timerActive()) {
            return new TimeUtil.TimeData(0L);
        }
        return new TimeUtil.TimeData(this.startTime + this.duration - TimeUtil.getCurrentTime());
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_TIMED_SALE;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @Environment(value=EnvType.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        class_342 discountInput;
        class_4185 buttonSetDiscount;
        class_4185 buttonStartSale;
        TimeInputWidget durationInput;

        protected final TimedSale getRule() {
            if (this.getRuleRaw() instanceof TimedSale) {
                return (TimedSale)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            this.discountInput = this.addCustomRenderable(new class_342(this.screen.getFont(), this.screen.guiLeft() + 10, this.screen.guiTop() + 9, 20, 20, (class_2561)class_2561.method_43473()));
            this.discountInput.method_1880(2);
            this.discountInput.method_1852(Integer.toString(this.getRule().discount));
            this.buttonSetDiscount = this.addCustomRenderable(new VanillaButton(this.screen.guiLeft() + 110, this.screen.guiTop() + 10, 50, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.discount.set"), this::PressSetDiscountButton));
            this.buttonStartSale = this.addCustomRenderable(new VanillaButton(this.screen.guiLeft() + 10, this.screen.guiTop() + 45, 156, 20, this.getButtonText(), this::PressStartButton));
            this.durationInput = this.addCustomRenderable(new TimeInputWidget(this.screen.guiLeft() + 48, this.screen.guiTop() + 75, 10, TimeUtil.TimeUnit.DAY, TimeUtil.TimeUnit.MINUTE, this::addCustomRenderable, this::onTimeSet));
            this.durationInput.setTime(this.getRule().duration);
        }

        @Override
        public void renderTab(class_332 gui, int mouseX, int mouseY, float partialTicks) {
            if (this.getRule() == null) {
                return;
            }
            gui.method_51439(this.screen.getFont(), (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.discount.tooltip"), this.discountInput.method_46426() + this.discountInput.method_25368() + 4, this.discountInput.method_46427() + 3, 0xFFFFFF, false);
            class_5250 infoText = class_2561.method_43469((String)"gui.button.lightmanscurrency.timed_sale.info.inactive", (Object[])new Object[]{new TimeUtil.TimeData(this.getRule().duration).getShortString()});
            if (this.getRule().timerActive()) {
                infoText = class_2561.method_43469((String)"gui.button.lightmanscurrency.timed_sale.info.active", (Object[])new Object[]{this.getRule().getTimeRemaining().getShortString(3)});
            }
            gui.method_51433(this.screen.getFont(), infoText.getString(), this.screen.guiLeft() + 10, this.screen.guiTop() + 35, 0xFFFFFF, false);
            if (this.buttonStartSale.method_25405((double)mouseX, (double)mouseY)) {
                gui.method_51438(this.screen.getFont(), this.getButtonTooltip(), mouseX, mouseY);
            }
        }

        @Override
        public void onScreenTick() {
            this.buttonStartSale.method_25355(this.getButtonText());
            this.buttonStartSale.field_22763 = this.getRule().timerActive() || this.getRule().duration > 0L && this.getRule().isActive();
            TextInputUtil.whitelistInteger(this.discountInput, 0L, 99L);
        }

        private class_2561 getButtonText() {
            return class_2561.method_43471((String)("gui.button.lightmanscurrency.timed_sale." + (this.getRule().timerActive() ? "stop" : "start")));
        }

        private class_2561 getButtonTooltip() {
            return class_2561.method_43471((String)("gui.button.lightmanscurrency.timed_sale." + (this.getRule().timerActive() ? "stop" : "start") + ".tooltip"));
        }

        @Override
        public void onTabClose() {
            this.removeCustomWidget(this.discountInput);
            this.removeCustomWidget(this.buttonSetDiscount);
            this.removeCustomWidget(this.buttonStartSale);
            this.durationInput.removeChildren(this::removeCustomWidget);
            this.removeCustomWidget(this.durationInput);
        }

        void PressSetDiscountButton(class_4185 button) {
            int discount;
            this.getRule().discount = discount = TextInputUtil.getIntegerValue(this.discountInput, 1);
            class_2487 updateInfo = new class_2487();
            updateInfo.method_10569("Discount", discount);
            this.screen.sendUpdateMessage(this.getRuleRaw(), updateInfo);
        }

        void PressStartButton(class_4185 button) {
            boolean setActive = !this.getRule().timerActive();
            this.getRule().startTime = this.getRule().timerActive() ? 0L : TimeUtil.getCurrentTime();
            class_2487 updateInfo = new class_2487();
            updateInfo.method_10556("StartSale", setActive);
            this.screen.sendUpdateMessage(this.getRuleRaw(), updateInfo);
        }

        public void onTimeSet(TimeUtil.TimeData newTime) {
            this.getRule().duration = newTime.miliseconds;
            class_2487 updateInfo = new class_2487();
            updateInfo.method_10544("Duration", newTime.miliseconds);
            this.screen.sendUpdateMessage(this.getRuleRaw(), updateInfo);
        }
    }
}

