/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.common.base.Supplier;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.traders.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;

public class TradeLimit
extends TradeRule {
    public static final class_2960 TYPE = new class_2960("lightmanscurrency", "trade_limit");
    private int limit = 1;
    int count = 0;

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int newLimit) {
        this.limit = newLimit;
    }

    public void resetCount() {
        this.count = 0;
    }

    public TradeLimit() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.count >= this.limit) {
            event.addDenial(class_2561.method_43469((String)"traderule.lightmanscurrency.tradelimit2.denial", (Object[])new Object[]{this.count}));
            event.addDenial(class_2561.method_43469((String)"traderule.lightmanscurrency.tradelimit.denial.limit", (Object[])new Object[]{this.limit}));
        } else {
            event.addHelpful(class_2561.method_43469((String)"traderule.lightmanscurrency.tradelimit2.info", (Object[])new Object[]{this.count, this.limit}));
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        ++this.count;
        event.markDirty();
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        compound.method_10569("Limit", this.limit);
        compound.method_10569("Count", this.count);
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        json.addProperty("Limit", (Number)this.limit);
        return json;
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        if (compound.method_10573("Limit", 3)) {
            this.limit = compound.method_10550("Limit");
        }
        if (compound.method_10573("Count", 3)) {
            this.count = compound.method_10550("Count");
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("Limit")) {
            this.limit = json.get("Limit").getAsInt();
        }
    }

    @Override
    public void handleUpdateMessage(class_2487 updateInfo) {
        if (updateInfo.method_10545("Limit")) {
            this.limit = updateInfo.method_10550("Limit");
        } else if (updateInfo.method_10545("ClearMemory")) {
            this.count = 0;
        }
    }

    @Override
    public class_2487 savePersistentData() {
        class_2487 data = new class_2487();
        data.method_10569("Count", this.count);
        return data;
    }

    @Override
    public void loadPersistentData(class_2487 data) {
        if (data.method_10573("Count", 3)) {
            this.count = data.method_10550("Count");
        }
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_COUNT;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @Environment(value=EnvType.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        class_342 limitInput;
        class_4185 buttonSetLimit;
        class_4185 buttonClearMemory;

        private TradeLimit getRule() {
            if (this.getRuleRaw() instanceof TradeLimit) {
                return (TradeLimit)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            this.limitInput = this.addCustomRenderable(new class_342(this.screen.getFont(), this.screen.guiLeft() + 10, this.screen.guiTop() + 19, 30, 20, (class_2561)class_2561.method_43473()));
            this.limitInput.method_1880(3);
            this.limitInput.method_1852(Integer.toString(this.getRule().limit));
            this.buttonSetLimit = this.addCustomRenderable(new VanillaButton(this.screen.guiLeft() + 41, this.screen.guiTop() + 19, 40, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.playerlimit.setlimit"), this::PressSetLimitButton));
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 50;
            Objects.requireNonNull(this.screen);
            this.buttonClearMemory = this.addCustomRenderable(new VanillaButton(n, n2, 176 - 20, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.playerlimit.clearmemory"), this::PressClearMemoryButton));
        }

        @Override
        public void renderTab(class_332 gui, int mouseX, int mouseY, float partialTicks) {
            gui.method_51433(this.screen.getFont(), class_2561.method_43469((String)"gui.button.lightmanscurrency.playerlimit.info", (Object[])new Object[]{this.getRule().limit}).getString(), this.screen.guiLeft() + 10, this.screen.guiTop() + 9, 0xFFFFFF, false);
            if (this.buttonClearMemory.method_25405((double)mouseX, (double)mouseY)) {
                gui.method_51438(this.screen.getFont(), (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.playerlimit.clearmemory.tooltip"), mouseX, mouseY);
            }
        }

        @Override
        public void onTabClose() {
            this.removeCustomWidget(this.limitInput);
            this.removeCustomWidget(this.buttonSetLimit);
            this.removeCustomWidget(this.buttonClearMemory);
        }

        @Override
        public void onScreenTick() {
            TextInputUtil.whitelistInteger(this.limitInput, 1L, 100L);
        }

        void PressSetLimitButton(class_4185 button) {
            int limit;
            this.getRule().limit = limit = MathUtil.clamp(TextInputUtil.getIntegerValue(this.limitInput), 1, 100);
            class_2487 updateInfo = new class_2487();
            updateInfo.method_10569("Limit", limit);
            this.screen.sendUpdateMessage(this.getRuleRaw(), updateInfo);
        }

        void PressClearMemoryButton(class_4185 button) {
            this.getRule().resetCount();
            class_2487 updateInfo = new class_2487();
            updateInfo.method_10556("ClearMemory", true);
            this.screen.sendUpdateMessage(this.getRuleRaw(), updateInfo);
        }
    }
}

