/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.slot_machine;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_151;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3518;

public final class SlotMachineEntry {
    public static final int ITEM_LIMIT = 4;
    public final List<class_1799> items;
    private int weight;

    public void TryAddItem(class_1799 item) {
        if (this.items.size() >= 4 || item.method_7960()) {
            return;
        }
        this.items.add(item);
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int newWeight) {
        this.weight = Math.max(1, newWeight);
    }

    private SlotMachineEntry(List<class_1799> items, int weight) {
        this.items = items;
        this.setWeight(weight);
    }

    public boolean isValid() {
        return this.items.size() > 0 && this.weight > 0;
    }

    public boolean isMoney() {
        if (this.items.size() == 0) {
            return false;
        }
        for (class_1799 item : this.items) {
            if (MoneyUtil.isCoin(item, false)) continue;
            return false;
        }
        return true;
    }

    public CoinValue getMoneyValue() {
        if (!this.isMoney()) {
            return CoinValue.EMPTY;
        }
        return MoneyUtil.getCoinValue(this.items);
    }

    public void validateItems() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).method_7960()) continue;
            this.items.remove(i--);
        }
    }

    public List<class_1799> getDisplayItems() {
        if (this.isMoney()) {
            return MoneyUtil.getCoinsOfValue(this.getMoneyValue().getRawValue());
        }
        return InventoryUtil.copyList(this.items);
    }

    public boolean CanGiveToCustomer(TradeContext context) {
        if (this.isMoney()) {
            return context.hasPaymentMethod();
        }
        return context.canFitItems(this.items);
    }

    public boolean GiveToCustomer(SlotMachineTraderData trader, TradeContext context) {
        if (this.hasStock(trader)) {
            if (this.isMoney()) {
                CoinValue reward = this.getMoneyValue();
                if (!context.givePayment(reward)) {
                    return false;
                }
                if (!trader.isCreative()) {
                    trader.removeStoredMoney(reward);
                }
            } else {
                for (int i = 0; i < this.items.size(); ++i) {
                    if (context.putItem(this.items.get(i).method_7972())) continue;
                    for (int x = 0; x < i; ++x) {
                        context.collectItem(this.items.get(x).method_7972());
                    }
                    return false;
                }
                if (!trader.isCreative()) {
                    for (class_1799 i : this.items) {
                        trader.getStorage().removeItem(i);
                    }
                    trader.markStorageDirty();
                }
            }
            return true;
        }
        return false;
    }

    public boolean hasStock(SlotMachineTraderData trader) {
        if (trader.isCreative()) {
            return true;
        }
        if (this.isMoney()) {
            return trader.getStoredMoney().getRawValue() >= this.getMoneyValue().getRawValue();
        }
        for (class_1799 item : InventoryUtil.combineQueryItems(this.items)) {
            if (trader.getStorage().hasItem(item)) continue;
            return false;
        }
        return true;
    }

    public boolean isItemRelevant(class_1799 item) {
        if (this.isMoney()) {
            return false;
        }
        return this.items.stream().anyMatch(i -> InventoryUtil.ItemMatches(i, item));
    }

    public class_2487 save() {
        class_2487 compound = new class_2487();
        class_2499 itemList = new class_2499();
        for (class_1799 item : this.items) {
            itemList.add((Object)item.method_7953(new class_2487()));
        }
        compound.method_10566("Items", (class_2520)itemList);
        compound.method_10569("Weight", this.weight);
        return compound;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JsonArray itemList = new JsonArray();
        for (class_1799 item : this.items) {
            itemList.add((JsonElement)FileUtil.convertItemStack(item));
        }
        json.add("Items", (JsonElement)itemList);
        json.addProperty("Weight", (Number)this.weight);
        return json;
    }

    public static SlotMachineEntry create() {
        return new SlotMachineEntry(new ArrayList<class_1799>(), 1);
    }

    public static SlotMachineEntry load(class_2487 compound) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        if (compound.method_10545("Items")) {
            class_2499 itemList = compound.method_10554("Items", 10);
            for (int i = 0; i < itemList.size(); ++i) {
                class_1799 stack = class_1799.method_7915((class_2487)itemList.method_10602(i));
                if (stack.method_7960()) continue;
                items.add(stack);
            }
        }
        if (compound.method_10545("Weight")) {
            return new SlotMachineEntry(items, compound.method_10550("Weight"));
        }
        return new SlotMachineEntry(items, 1);
    }

    public static SlotMachineEntry parse(JsonObject json) throws JsonSyntaxException, class_151 {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        JsonArray itemList = class_3518.method_15261((JsonObject)json, (String)"Items");
        for (int i = 0; i < itemList.size(); ++i) {
            try {
                class_1799 stack = FileUtil.parseItemStack(itemList.get(i).getAsJsonObject());
                if (stack.method_7960()) {
                    throw new JsonSyntaxException("Cannot add an empty item to a Slot Machine Entry!");
                }
                items.add(stack);
                continue;
            }
            catch (JsonSyntaxException | class_151 t) {
                LightmansCurrency.LogError("Error parsing Slot Machine Entry item #" + (i + 1), t);
            }
        }
        if (items.size() == 0) {
            throw new JsonSyntaxException("Slot Machie Entry has no valid items!");
        }
        int weight = class_3518.method_15282((JsonObject)json, (String)"Weight", (int)1);
        return new SlotMachineEntry(items, weight);
    }
}

