/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.slot_machine.trade_data;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.AlertData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class SlotMachineTrade
extends TradeData {
    public final SlotMachineTraderData trader;

    public SlotMachineTrade(SlotMachineTraderData trader) {
        super(false);
        this.trader = trader;
    }

    @Override
    public CoinValue getCost() {
        return this.trader.getPrice();
    }

    @Override
    public boolean isValid() {
        return this.trader.hasValidTrade();
    }

    @Override
    public TradeData.TradeDirection getTradeDirection() {
        return TradeData.TradeDirection.SALE;
    }

    @Override
    public TradeData.TradeComparisonResult compare(TradeData otherTrade) {
        return new TradeData.TradeComparisonResult();
    }

    @Override
    public boolean AcceptableDifferences(TradeData.TradeComparisonResult result) {
        return false;
    }

    @Override
    public List<class_2561> GetDifferenceWarnings(TradeData.TradeComparisonResult differences) {
        return new ArrayList<class_2561>();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int tradeButtonWidth(TradeContext context) {
        return 128;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Pair<Integer, Integer> arrowPosition(TradeContext context) {
        return Pair.of((Object)36, (Object)1);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public DisplayData inputDisplayArea(TradeContext context) {
        return new DisplayData(1, 1, 34, 16);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<DisplayEntry> getInputDisplays(TradeContext context) {
        return Lists.newArrayList((Object[])new DisplayEntry[]{DisplayEntry.of(this.getCost(context))});
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public DisplayData outputDisplayArea(TradeContext context) {
        return new DisplayData(59, 1, 68, 16);
    }

    @Environment(value=EnvType.CLIENT)
    private SlotMachineEntry getTimedEntry() {
        List<SlotMachineEntry> entries = this.trader.getValidEntries();
        if (entries.size() == 0) {
            return null;
        }
        return entries.get((int)System.currentTimeMillis() / 1000 % entries.size());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<DisplayEntry> getOutputDisplays(TradeContext context) {
        SlotMachineEntry entry = this.getTimedEntry();
        if (entry == null) {
            return new ArrayList<DisplayEntry>();
        }
        ArrayList<DisplayEntry> entries = new ArrayList<DisplayEntry>();
        String odds = this.trader.getOdds(entry.getWeight());
        for (class_1799 item : entry.items) {
            entries.add(DisplayEntry.of(item, item.method_7947(), this.getTooltip(item, entry.getWeight(), odds)));
        }
        return entries;
    }

    @Environment(value=EnvType.CLIENT)
    private List<class_2561> getTooltip(class_1799 stack, int weight, String odds) {
        if (stack.method_7960()) {
            return null;
        }
        List tooltips = class_437.method_25408((class_310)class_310.method_1551(), (class_1799)stack);
        tooltips.add(0, EasyText.translatable("tooltip.lightmanscurrency.slot_machine.weight", weight));
        tooltips.add(0, EasyText.translatable("tooltip.lightmanscurrency.slot_machine.odds", odds));
        return tooltips;
    }

    @Override
    protected void getAdditionalAlertData(TradeContext context, List<AlertData> alerts) {
        TraderData traderData;
        if (context.hasTrader() && (traderData = context.getTrader()) instanceof SlotMachineTraderData) {
            SlotMachineTraderData t = (SlotMachineTraderData)traderData;
            if (!t.isCreative() && !t.hasStock()) {
                alerts.add(AlertData.warn(EasyText.translatable("tooltip.lightmanscurrency.outofstock", new Object[0])));
            }
            if (!context.hasFunds(this.getCost(context))) {
                alerts.add(AlertData.warn(EasyText.translatable("tooltip.lightmanscurrency.cannotafford", new Object[0])));
            }
        }
    }

    @Override
    public void onInputDisplayInteraction(BasicTradeEditTab tab, @Nullable TraderStorageMenu.IClientMessage clientHandler, int index, int button, class_1799 heldItem) {
    }

    @Override
    public void onOutputDisplayInteraction(BasicTradeEditTab tab, @Nullable TraderStorageMenu.IClientMessage clientHandler, int index, int button, class_1799 heldItem) {
    }

    @Override
    public void onInteraction(BasicTradeEditTab tab, @Nullable TraderStorageMenu.IClientMessage clientHandler, int mouseX, int mouseY, int button, class_1799 heldItem) {
    }

    @Override
    public boolean allowTradeRule(TradeRule rule) {
        return false;
    }
}

