/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.tradedata;

import java.util.function.UnaryOperator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public class AlertData {
    private final class_5250 message;
    public final int priority;
    public final int color;
    private final UnaryOperator<class_2583> formatting;

    private AlertData(class_5250 message, int priority, int color, UnaryOperator<class_2583> format) {
        this.message = message;
        this.priority = priority;
        this.color = color;
        this.formatting = format;
    }

    @Environment(value=EnvType.CLIENT)
    public void setShaderColor(class_332 gui, float mult) {
        float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.color & 0xFF) / 255.0f;
        gui.method_51422(red * mult, green * mult, blue * mult, 1.0f);
    }

    public class_5250 getFormattedMessage() {
        return this.message.method_27694(this.formatting);
    }

    public static final int compare(AlertData a, AlertData b) {
        return Integer.compare(a.priority, b.priority) * -1;
    }

    public static final AlertData helpful(class_5250 message) {
        return AlertData.of(message, AlertType.HELPFUL);
    }

    public static final AlertData warn(class_5250 message) {
        return AlertData.of(message, AlertType.WARN);
    }

    public static final AlertData error(class_5250 message) {
        return AlertData.of(message, AlertType.ERROR);
    }

    private static final AlertData of(class_5250 message, AlertType type) {
        return AlertData.of(message, type.priority, type.color, type.format);
    }

    public static final AlertData of(class_5250 message, int priority, int color, UnaryOperator<class_2583> style) {
        return new AlertData(message, priority, color, style);
    }

    public static enum AlertType {
        HELPFUL(65280, class_124.field_1060, 1),
        WARN(0xFF7F00, class_124.field_1065, 3),
        ERROR(0xFF0000, class_124.field_1061, 5);

        private final int priority;
        private final int color;
        private final UnaryOperator<class_2583> format;

        private AlertType(int color, class_124 format, int priority) {
            this.color = color;
            this.format = s -> s.method_27706(format);
            this.priority = priority;
        }
    }
}

