/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.tradedata;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.AlertData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import org.jetbrains.annotations.Nullable;

public abstract class TradeData {
    public static final String DEFAULT_KEY = "Trades";
    protected CoinValue cost = new CoinValue(new CoinValue.CoinValuePair[0]);
    List<TradeRule> rules = new ArrayList<TradeRule>();
    private final boolean validateRules;

    public abstract TradeDirection getTradeDirection();

    public final boolean validCost() {
        return this.cost.isFree() || this.cost.getRawValue() > 0L;
    }

    public boolean isValid() {
        return this.validCost();
    }

    public CoinValue getCost() {
        return this.cost;
    }

    public CoinValue getCost(TradeContext context) {
        if (context.hasTrader() && context.hasPlayerReference()) {
            return context.getTrader().runTradeCostEvent(context.getPlayerReference(), this).getCostResult();
        }
        return this.cost;
    }

    public void setCost(CoinValue value) {
        this.cost = value;
    }

    protected TradeData(boolean validateRules) {
        this.validateRules = validateRules;
        if (this.validateRules) {
            TradeRule.ValidateTradeRuleList(this.rules, this::allowTradeRule);
        }
    }

    public class_2487 getAsNBT() {
        class_2487 tradeNBT = new class_2487();
        this.cost.save(tradeNBT, "Price");
        TradeRule.saveRules(tradeNBT, this.rules, "RuleData");
        return tradeNBT;
    }

    protected void loadFromNBT(class_2487 nbt) {
        this.cost.load(nbt, "Price");
        if (nbt.method_10545("IsFree")) {
            this.cost.setFree(nbt.method_10577("IsFree"));
        }
        this.rules.clear();
        if (nbt.method_10545("TradeRules")) {
            this.rules = TradeRule.loadRules(nbt, "TradeRules");
            for (TradeRule r : this.rules) {
                r.setActive(true);
            }
        } else {
            this.rules = TradeRule.loadRules(nbt, "RuleData");
        }
        if (this.validateRules) {
            TradeRule.ValidateTradeRuleList(this.rules, this::allowTradeRule);
        }
    }

    public boolean allowTradeRule(TradeRule rule) {
        return true;
    }

    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.beforeTrade(event);
        }
    }

    public void tradeCost(TradeEvent.TradeCostEvent event) {
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.tradeCost(event);
        }
    }

    public void afterTrade(TradeEvent.PostTradeEvent event) {
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.afterTrade(event);
        }
    }

    public List<TradeRule> getRules() {
        return new ArrayList<TradeRule>(this.rules);
    }

    public void setRules(List<TradeRule> rules) {
        this.rules = rules;
    }

    public void addTradeRuleAlertData(List<AlertData> alerts, TradeContext context) {
        if (context.hasTrader() && context.hasPlayerReference()) {
            TradeEvent.PreTradeEvent pte = context.getTrader().runPreTradeEvent(context.getPlayerReference(), this);
            alerts.addAll(pte.getAlertInfo());
        }
    }

    public abstract TradeComparisonResult compare(TradeData var1);

    public abstract boolean AcceptableDifferences(TradeComparisonResult var1);

    public abstract List<class_2561> GetDifferenceWarnings(TradeComparisonResult var1);

    public abstract int tradeButtonWidth(TradeContext var1);

    public boolean hasArrow(TradeContext context) {
        return true;
    }

    public abstract Pair<Integer, Integer> arrowPosition(TradeContext var1);

    public Pair<Integer, Integer> alertPosition(TradeContext context) {
        return this.arrowPosition(context);
    }

    public abstract DisplayData inputDisplayArea(TradeContext var1);

    public abstract DisplayData outputDisplayArea(TradeContext var1);

    public abstract List<DisplayEntry> getInputDisplays(TradeContext var1);

    public abstract List<DisplayEntry> getOutputDisplays(TradeContext var1);

    public boolean hasAlert(TradeContext context) {
        List<AlertData> alerts = this.getAlertData(context);
        return alerts != null && alerts.size() > 0;
    }

    public final List<AlertData> getAlertData(TradeContext context) {
        if (context.isStorageMode) {
            return null;
        }
        ArrayList<AlertData> alerts = new ArrayList<AlertData>();
        this.addTradeRuleAlertData(alerts, context);
        this.getAdditionalAlertData(context, alerts);
        return alerts;
    }

    protected abstract void getAdditionalAlertData(TradeContext var1, List<AlertData> var2);

    @Environment(value=EnvType.CLIENT)
    public void renderAdditional(class_339 button, class_332 gui, int mouseX, int mouseY, TradeContext context) {
    }

    public List<class_2561> getAdditionalTooltips(TradeContext context, int mouseX, int mouseY) {
        return null;
    }

    public abstract void onInputDisplayInteraction(BasicTradeEditTab var1, @Nullable TraderStorageMenu.IClientMessage var2, int var3, int var4, class_1799 var5);

    public abstract void onOutputDisplayInteraction(BasicTradeEditTab var1, @Nullable TraderStorageMenu.IClientMessage var2, int var3, int var4, class_1799 var5);

    public abstract void onInteraction(BasicTradeEditTab var1, @Nullable TraderStorageMenu.IClientMessage var2, int var3, int var4, int var5, class_1799 var6);

    public static class TradeComparisonResult {
        private boolean compatible = false;
        private List<ProductComparisonResult> tradeProductResults = new ArrayList<ProductComparisonResult>();
        private long priceChange = 0L;
        private boolean tradeTypeMatches = true;

        public boolean isCompatible() {
            return this.compatible;
        }

        public boolean ProductMatches() {
            for (ProductComparisonResult result : this.tradeProductResults) {
                if (result.Identical()) continue;
                return false;
            }
            return true;
        }

        public ProductComparisonResult getProductResult(int index) {
            if (index < 0 || index >= this.tradeProductResults.size()) {
                return null;
            }
            return this.tradeProductResults.get(index);
        }

        public int getProductResultCount() {
            return this.tradeProductResults.size();
        }

        public boolean PriceMatches() {
            return this.priceChange == 0L;
        }

        public long priceDifference() {
            return this.priceChange;
        }

        public boolean isPriceCheaper() {
            return this.priceChange > 0L;
        }

        public boolean isPriceExpensive() {
            return this.priceChange < 0L;
        }

        public boolean TypeMatches() {
            return this.tradeTypeMatches;
        }

        public boolean Identical() {
            return this.compatible && this.ProductMatches() && this.PriceMatches() && this.TypeMatches();
        }

        public void addProductResult(ProductComparisonResult result) {
            this.tradeProductResults.add(result);
        }

        public void addProductResults(Collection<? extends ProductComparisonResult> results) {
            this.tradeProductResults.addAll(results);
        }

        public void addProductResult(boolean sameProduct, boolean sameNBT, int quantityDifference) {
            this.tradeProductResults.add(new ProductComparisonResult(sameProduct, sameNBT, quantityDifference));
        }

        public void setPriceResult(long priceChange) {
            this.priceChange = priceChange;
        }

        public void setTypeResult(boolean typeMatches) {
            this.tradeTypeMatches = typeMatches;
        }

        public void setCompatible() {
            this.compatible = true;
        }

        public static class ProductComparisonResult {
            private final boolean sameProduct;
            private final boolean sameNBT;
            private final int quantityDifference;

            public boolean Identical() {
                return this.SameProductType() && this.SameProductNBT() && this.SameProductQuantity();
            }

            public boolean SameProductType() {
                return this.sameProduct;
            }

            public boolean SameProductNBT() {
                return this.sameNBT;
            }

            public boolean SameProductQuantity() {
                return this.quantityDifference == 0;
            }

            public int ProductQuantityDifference() {
                return this.quantityDifference;
            }

            private ProductComparisonResult(boolean sameProduct, boolean sameNBT, int quantityDifference) {
                this.sameProduct = sameProduct;
                this.sameNBT = sameNBT;
                this.quantityDifference = quantityDifference;
            }

            public static ProductComparisonResult CompareItem(class_1799 original, class_1799 query) {
                boolean isItemEqual;
                boolean bl = isItemEqual = original.method_7909() == query.method_7909();
                boolean isTagEqual = original.method_7969() != null ? original.method_7969().equals((Object)query.method_7969()) : query.method_7969() == null;
                int quantityDifference = original.method_7947() - query.method_7947();
                return new ProductComparisonResult(isItemEqual, isTagEqual, quantityDifference);
            }

            public static List<ProductComparisonResult> CompareTwoItems(class_1799 original1, class_1799 original2, class_1799 query1, class_1799 query2) {
                boolean flipMatch;
                ArrayList<ProductComparisonResult> results = new ArrayList<ProductComparisonResult>();
                boolean bl = flipMatch = original1.method_7909() == query2.method_7909() && original2.method_7909() == query1.method_7909() && original1.method_7909() != original2.method_7909() && query1.method_7909() != query2.method_7909();
                if (flipMatch) {
                    results.add(ProductComparisonResult.CompareItem(original1, query2));
                    results.add(ProductComparisonResult.CompareItem(original2, query1));
                } else {
                    results.add(ProductComparisonResult.CompareItem(original1, query1));
                    results.add(ProductComparisonResult.CompareItem(original2, query2));
                }
                return results;
            }

            public static ProductComparisonResult CompareEnergy(int original, int query) {
                return new ProductComparisonResult(true, true, original - query);
            }
        }
    }

    public static enum TradeDirection {
        SALE(0, 1),
        PURCHASE(1, 0),
        NONE(-1, 0);

        public final int index;
        private final int nextIndex;

        public final TradeDirection next() {
            return TradeDirection.fromIndex(this.nextIndex);
        }

        private TradeDirection(int index, int nextIndex) {
            this.index = index;
            this.nextIndex = nextIndex;
        }

        public static TradeDirection fromIndex(int index) {
            for (TradeDirection d : TradeDirection.values()) {
                if (d.index != index) continue;
                return d;
            }
            return SALE;
        }
    }
}

