/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network;

import com.google.common.collect.ImmutableMap;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public final class LazyPacketData {
    public static final byte TYPE_NULL = 0;
    public static final byte TYPE_BOOLEAN = 1;
    public static final byte TYPE_INT = 2;
    public static final byte TYPE_LONG = 3;
    public static final byte TYPE_FLOAT = 4;
    public static final byte TYPE_DOUBLE = 5;
    public static final byte TYPE_STRING = 6;
    public static final byte TYPE_UUID = 10;
    public static final byte TYPE_TEXT = 64;
    public static final byte TYPE_NBT = 65;
    public static final byte TYPE_BLOCKPOS = 66;
    private final ImmutableMap<String, Data> dataMap;

    public Set<String> getAllKeys() {
        return this.dataMap.keySet();
    }

    private LazyPacketData(Map<String, Data> data) {
        this.dataMap = ImmutableMap.copyOf(data);
    }

    private Data getData(String key) {
        return (Data)this.dataMap.getOrDefault((Object)key, (Object)Data.NULL);
    }

    public boolean contains(String key) {
        return this.dataMap.containsKey((Object)key);
    }

    public boolean contains(String key, byte type) {
        return this.contains(key) && this.getData((String)key).type == type;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Data d = this.getData(key);
        if (d.type == 1) {
            return (Boolean)d.value;
        }
        return defaultValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        Data d = this.getData(key);
        if (d.type == 2) {
            return (Integer)d.value;
        }
        return defaultValue;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        Data d = this.getData(key);
        if (d.type == 3) {
            return (Long)d.value;
        }
        return defaultValue;
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        Data d = this.getData(key);
        if (d.type == 4) {
            return ((Float)d.value).floatValue();
        }
        return defaultValue;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        Data d = this.getData(key);
        if (d.type == 5) {
            return (Double)d.value;
        }
        return defaultValue;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        Data d = this.getData(key);
        if (d.type == 6) {
            return (String)d.value;
        }
        return defaultValue;
    }

    public class_2960 getResource(String key) {
        return this.getResource(key, null);
    }

    public class_2960 getResource(String key, class_2960 defaultValue) {
        Data d = this.getData(key);
        if (d.type == 6) {
            return new class_2960((String)d.value);
        }
        return defaultValue;
    }

    public UUID getUUID(String key) {
        return this.getUUID(key, null);
    }

    public UUID getUUID(String key, UUID defaultValue) {
        Data d = this.getData(key);
        if (d.type == 10) {
            return (UUID)d.value;
        }
        return defaultValue;
    }

    public class_2561 getText(String key) {
        return this.getText(key, (class_2561)EasyText.empty());
    }

    public class_2561 getText(String key, class_2561 defaultValue) {
        Data d = this.getData(key);
        if (d.type == 64) {
            return (class_2561)d.value;
        }
        return defaultValue;
    }

    public class_2487 getCompound(String key) {
        return this.getCompound(key, new class_2487());
    }

    public class_2487 getCompound(String key, class_2487 defaultValue) {
        Data d = this.getData(key);
        if (d.type == 65) {
            return (class_2487)d.value;
        }
        return defaultValue;
    }

    public class_2338 getBlockPos(String key) {
        return this.getBlockPos(key, new class_2338(0, 0, 0));
    }

    public class_2338 getBlockPos(String key, class_2338 defaultValue) {
        Data d = this.getData(key);
        if (d.type == 66) {
            return (class_2338)d.value;
        }
        return defaultValue;
    }

    public CoinValue getCoinValue(String key) {
        return this.getCoinValue(key, new CoinValue(new CoinValue.CoinValuePair[0]));
    }

    public CoinValue getCoinValue(String key, CoinValue defaultValue) {
        Data d = this.getData(key);
        if (d.type == 65) {
            CoinValue result = new CoinValue(new CoinValue.CoinValuePair[0]);
            result.load((class_2487)d.value, "CoinValue");
            return result;
        }
        return defaultValue;
    }

    public void encode(class_2540 buffer) {
        buffer.writeInt(this.dataMap.entrySet().size());
        this.dataMap.forEach((key, data) -> {
            buffer.method_10814(key);
            buffer.writeByte((int)data.type);
            data.encode(buffer);
        });
    }

    public static LazyPacketData decode(class_2540 buffer) {
        int count = buffer.readInt();
        HashMap<String, Data> dataMap = new HashMap<String, Data>();
        for (int i = 0; i < count; ++i) {
            String key = buffer.method_19772();
            Data data = Data.decode(buffer);
            dataMap.put(key, data);
        }
        return new LazyPacketData(dataMap);
    }

    public static Builder builder() {
        return new Builder();
    }

    private record Data(byte type, Object value) {
        static final Data NULL = new Data(0, null);

        static Data ofNull() {
            return NULL;
        }

        static Data ofBoolean(boolean value) {
            return new Data(1, value);
        }

        static Data ofInt(int value) {
            return new Data(2, value);
        }

        static Data ofLong(long value) {
            return new Data(3, value);
        }

        static Data ofFloat(float value) {
            return new Data(4, Float.valueOf(value));
        }

        static Data ofDouble(double value) {
            return new Data(5, value);
        }

        static Data ofString(String value) {
            return value == null ? NULL : new Data(6, value);
        }

        static Data ofResource(class_2960 value) {
            return value == null ? NULL : new Data(6, value.toString());
        }

        static Data ofUUID(UUID value) {
            return value == null ? NULL : new Data(10, value);
        }

        static Data ofText(class_2561 value) {
            return value == null ? NULL : new Data(64, value);
        }

        static Data ofNBT(class_2487 value) {
            return value == null ? NULL : new Data(65, value);
        }

        static Data ofBlockPos(class_2338 value) {
            return value == null ? NULL : new Data(66, value);
        }

        static Data ofCoinValue(CoinValue value) {
            return value == null ? NULL : Data.ofNBT(value.save(new class_2487(), "CoinValue"));
        }

        void encode(class_2540 buffer) {
            if (this.type == 1) {
                buffer.writeBoolean(((Boolean)this.value).booleanValue());
            }
            if (this.type == 2) {
                buffer.writeInt(((Integer)this.value).intValue());
            }
            if (this.type == 3) {
                buffer.writeLong(((Long)this.value).longValue());
            }
            if (this.type == 4) {
                buffer.writeFloat(((Float)this.value).floatValue());
            }
            if (this.type == 5) {
                buffer.writeDouble(((Double)this.value).doubleValue());
            }
            if (this.type == 6) {
                String s = (String)this.value;
                buffer.writeInt(s.length());
                buffer.method_10814(s);
            }
            if (this.type == 10) {
                buffer.method_10797((UUID)this.value);
            }
            if (this.type == 64) {
                buffer.method_10814(class_2561.class_2562.method_10867((class_2561)((class_2561)this.value)));
            }
            if (this.type == 65) {
                buffer.method_10794((class_2487)this.value);
            }
            if (this.type == 66) {
                class_2338 val = (class_2338)this.value;
                buffer.writeInt(val.method_10263());
                buffer.writeInt(val.method_10264());
                buffer.writeInt(val.method_10260());
            }
        }

        static Data decode(class_2540 buffer) {
            byte type = buffer.readByte();
            if (type == 0) {
                return Data.ofNull();
            }
            if (type == 1) {
                return Data.ofBoolean(buffer.readBoolean());
            }
            if (type == 2) {
                return Data.ofInt(buffer.readInt());
            }
            if (type == 3) {
                return Data.ofLong(buffer.readLong());
            }
            if (type == 4) {
                return Data.ofFloat(buffer.readFloat());
            }
            if (type == 5) {
                return Data.ofDouble(buffer.readDouble());
            }
            if (type == 6) {
                int length = buffer.readInt();
                return Data.ofString(buffer.method_10800(length));
            }
            if (type == 10) {
                return Data.ofUUID(buffer.method_10790());
            }
            if (type == 64) {
                return Data.ofText((class_2561)class_2561.class_2562.method_10877((String)buffer.method_19772()));
            }
            if (type == 65) {
                return Data.ofNBT(buffer.method_30617());
            }
            if (type == 66) {
                int x = buffer.readInt();
                int y = buffer.readInt();
                int z = buffer.readInt();
                return Data.ofBlockPos(new class_2338(x, y, z));
            }
            throw new RuntimeException("Could not decode entry of type " + type + "as it is not a valid data entry type!");
        }
    }

    public static final class Builder {
        Map<String, Data> data = new HashMap<String, Data>();

        private Builder() {
        }

        public Builder setBoolean(String key, boolean value) {
            this.data.put(key, Data.ofBoolean(value));
            return this;
        }

        public Builder setInt(String key, int value) {
            this.data.put(key, Data.ofInt(value));
            return this;
        }

        public Builder setLong(String key, long value) {
            this.data.put(key, Data.ofLong(value));
            return this;
        }

        public Builder setFloat(String key, float value) {
            this.data.put(key, Data.ofFloat(value));
            return this;
        }

        public Builder setDouble(String key, double value) {
            this.data.put(key, Data.ofDouble(value));
            return this;
        }

        public Builder setString(String key, String value) {
            this.data.put(key, Data.ofString(value));
            return this;
        }

        public Builder setResource(String key, class_2960 value) {
            this.data.put(key, Data.ofResource(value));
            return this;
        }

        public Builder setUUID(String key, UUID value) {
            this.data.put(key, Data.ofUUID(value));
            return this;
        }

        public Builder setText(String key, class_2561 value) {
            this.data.put(key, Data.ofText(value));
            return this;
        }

        public Builder setCompound(String key, class_2487 value) {
            this.data.put(key, Data.ofNBT(value));
            return this;
        }

        public Builder setBlockPos(String key, class_2338 value) {
            this.data.put(key, Data.ofBlockPos(value));
            return this;
        }

        public Builder setCoinValue(String key, CoinValue value) {
            this.data.put(key, Data.ofCoinValue(value));
            return this;
        }

        public Builder clone(LazyPacketData data) {
            this.data.putAll((Map<String, Data>)data.dataMap);
            return this;
        }

        public LazyPacketData build() {
            return new LazyPacketData(this.data);
        }
    }
}

