/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.client;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.atm.ATMData;
import io.github.lightman314.lightmanscurrency.common.money.MoneyData;
import io.github.lightman314.lightmanscurrency.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.network.client.messages.admin.SMessageSyncAdminList;
import io.github.lightman314.lightmanscurrency.network.client.messages.auction.SMessageAttemptBid;
import io.github.lightman314.lightmanscurrency.network.client.messages.bank.SMessageATMPlayerAccountResponse;
import io.github.lightman314.lightmanscurrency.network.client.messages.bank.SMessageBankTransferResponse;
import io.github.lightman314.lightmanscurrency.network.client.messages.config.SPacketReloadConfig;
import io.github.lightman314.lightmanscurrency.network.client.messages.config.SPacketSyncConfig;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageClearClientTraders;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageRemoveClientTeam;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageRemoveClientTrader;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageSetupClientBank;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageSetupClientTeam;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageSetupClientWallet;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageSyncSelectedBankAccount;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageUpdateClientBank;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageUpdateClientNotifications;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageUpdateClientTeam;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageUpdateClientTrader;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageUpdateClientWallet;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageUpdateEjectionData;
import io.github.lightman314.lightmanscurrency.network.client.messages.ejectiondata.SMessageChangeSelectedData;
import io.github.lightman314.lightmanscurrency.network.client.messages.enchantments.SMessageMoneyMendingClink;
import io.github.lightman314.lightmanscurrency.network.client.messages.notifications.SMessageClientNotification;
import io.github.lightman314.lightmanscurrency.network.client.messages.slot_machine.SMessageSlotMachine;
import io.github.lightman314.lightmanscurrency.network.client.messages.team.SMessageCreateTeamResponse;
import io.github.lightman314.lightmanscurrency.network.client.messages.time.SMessageSyncTime;
import io.github.lightman314.lightmanscurrency.network.client.messages.trader.SMessageStorageInteraction;
import io.github.lightman314.lightmanscurrency.network.client.messages.trader.SMessageSyncUserCount;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;

@Environment(value=EnvType.CLIENT)
public class LCClientPacketHandler
implements ClientPlayNetworking.PlayChannelHandler {
    private final Map<class_2960, IClientPacketHandler> PACKET_HANDLERS = new HashMap<class_2960, IClientPacketHandler>();

    public LCClientPacketHandler() {
        this.registerPacketType(SMessageSyncAdminList.PACKET_ID, SMessageSyncAdminList::handle);
        this.registerPacketType(SMessageATMPlayerAccountResponse.PACKET_ID, SMessageATMPlayerAccountResponse::handle);
        this.registerPacketType(SMessageBankTransferResponse.PACKET_ID, SMessageBankTransferResponse::handle);
        this.registerPacketType(SMessageSyncTime.PACKET_ID, SMessageSyncTime::handle);
        this.registerPacketType(SMessageMoneyMendingClink.PACKET_ID, SMessageMoneyMendingClink::handle);
        this.registerPacketType(SMessageSyncUserCount.PACKET_ID, SMessageSyncUserCount::handle);
        this.registerPacketType(SMessageStorageInteraction.PACKET_ID, SMessageStorageInteraction::handle);
        this.registerPacketType(SMessageUpdateClientNotifications.PACKET_ID, SMessageUpdateClientNotifications::handle);
        this.registerPacketType(SMessageClearClientTraders.PACKET_ID, SMessageClearClientTraders::handle);
        this.registerPacketType(SMessageRemoveClientTrader.PACKET_ID, SMessageRemoveClientTrader::handle);
        this.registerPacketType(SMessageUpdateClientTrader.PACKET_ID, SMessageUpdateClientTrader::handle);
        this.registerPacketType(SMessageUpdateEjectionData.PACKET_ID, SMessageUpdateEjectionData::handle);
        this.registerPacketType(SMessageUpdateClientBank.PACKET_ID, SMessageUpdateClientBank::handle);
        this.registerPacketType(SMessageSetupClientBank.PACKET_ID, SMessageSetupClientBank::handle);
        this.registerPacketType(SMessageSyncSelectedBankAccount.PACKET_ID, SMessageSyncSelectedBankAccount::handle);
        this.registerPacketType(SMessageUpdateClientTeam.PACKET_ID, SMessageUpdateClientTeam::handle);
        this.registerPacketType(SMessageRemoveClientTeam.PACKET_ID, SMessageRemoveClientTeam::handle);
        this.registerPacketType(SMessageSetupClientTeam.PACKET_ID, SMessageSetupClientTeam::handle);
        this.registerPacketType(SMessageUpdateClientWallet.PACKET_ID, SMessageUpdateClientWallet::handle);
        this.registerPacketType(SMessageSetupClientWallet.PACKET_ID, SMessageSetupClientWallet::handle);
        this.registerPacketType(MoneyData.PACKET_ID, MoneyData::handle);
        this.registerPacketType(ATMData.PACKET_ID, ATMData::handle);
        this.registerPacketType(SMessageClientNotification.PACKET_ID, SMessageClientNotification::handle);
        this.registerPacketType(SMessageCreateTeamResponse.PACKET_ID, SMessageCreateTeamResponse::handle);
        this.registerPacketType(SMessageChangeSelectedData.PACKET_ID, SMessageChangeSelectedData::handle);
        this.registerPacketType(SMessageSlotMachine.PACKET_ID, SMessageSlotMachine::handle);
        this.registerPacketType(SMessageAttemptBid.PACKET_ID, SMessageAttemptBid::handle);
        this.registerPacketType(SPacketReloadConfig.PACKET_ID, SPacketReloadConfig::handle);
        this.registerPacketType(SPacketSyncConfig.PACKET_ID, SPacketSyncConfig::handle);
    }

    public void receive(class_310 client, class_634 handler, class_2540 buffer, PacketSender responseSender) {
        class_2960 type = new class_2960(buffer.method_19772());
        LazyPacketData data = LazyPacketData.decode(buffer);
        client.execute(() -> {
            try {
                LightmansCurrency.LogDebug("Handling client packet of type '" + type + "'!");
                if (!this.PACKET_HANDLERS.containsKey(type)) {
                    throw new RuntimeException("No packet handler was registered for Server -> Client packet type '" + type + "'!");
                }
                this.PACKET_HANDLERS.get(type).handle(client, handler, data, responseSender);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error handling client packet!", t);
            }
        });
    }

    public void registerPacketType(class_2960 type, IClientPacketHandler handler) {
        if (this.PACKET_HANDLERS.containsKey(type)) {
            LightmansCurrency.LogWarning("LC Client Packet Handler already contains a registration for packet handler of type '" + type.toString() + "'.\nStacktrace: " + new Throwable());
            return;
        }
        this.PACKET_HANDLERS.put(type, handler);
    }

    public static interface IClientPacketHandler {
        public void handle(class_310 var1, class_634 var2, LazyPacketData var3, PacketSender var4);
    }
}

