/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.client;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.network.PacketChannels;
import io.github.lightman314.lightmanscurrency.server.ServerHook;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public abstract class ServerToClientPacket {
    private final class_2960 type;

    protected ServerToClientPacket(class_2960 type) {
        this.type = type;
    }

    protected final class_2540 encode() {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_10814(this.type.toString());
        LazyPacketData.Builder builder = LazyPacketData.builder();
        try {
            this.encode(builder);
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error encoding ServerToClient packet '" + this.type + "'", t);
        }
        builder.build().encode(buffer);
        return buffer;
    }

    protected abstract void encode(LazyPacketData.Builder var1);

    public final void sendToAll() {
        MinecraftServer server = ServerHook.getServer();
        if (server != null) {
            this.sendTo(server.method_3760().method_14571());
        }
    }

    public final void sendTo(Iterable<class_3222> players) {
        for (class_3222 player : players) {
            this.sendTo(player);
        }
    }

    public final void sendTo(class_1657 player) {
        if (player instanceof class_3222) {
            this.sendTo((class_3222)player);
        }
    }

    public final void sendTo(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)PacketChannels.SERVER_TO_CLIENT, (class_2540)this.encode());
    }

    public final void sendTo(PacketSender packetSender) {
        packetSender.sendPacket(PacketChannels.SERVER_TO_CLIENT, this.encode());
    }

    public static class Simple
    extends ServerToClientPacket {
        protected Simple(class_2960 type) {
            super(type);
        }

        @Override
        protected final void encode(LazyPacketData.Builder dataBuilder) {
        }
    }
}

