/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.server;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.network.server.messages.auction.CMessageSubmitBid;
import io.github.lightman314.lightmanscurrency.network.server.messages.bank.CMessageATMExchange;
import io.github.lightman314.lightmanscurrency.network.server.messages.bank.CMessageATMSetPlayerAccount;
import io.github.lightman314.lightmanscurrency.network.server.messages.bank.CMessageBankInteraction;
import io.github.lightman314.lightmanscurrency.network.server.messages.bank.CMessageBankTransferPlayer;
import io.github.lightman314.lightmanscurrency.network.server.messages.bank.CMessageBankTransferTeam;
import io.github.lightman314.lightmanscurrency.network.server.messages.bank.CMessageSelectBankAccount;
import io.github.lightman314.lightmanscurrency.network.server.messages.bank.CMessageSetBankNotificationLevel;
import io.github.lightman314.lightmanscurrency.network.server.messages.blockentity.CPacketRequestNBT;
import io.github.lightman314.lightmanscurrency.network.server.messages.emergencyejection.CMessageChangeSelectedData;
import io.github.lightman314.lightmanscurrency.network.server.messages.emergencyejection.CMessageOpenRecoveryMenu;
import io.github.lightman314.lightmanscurrency.network.server.messages.notifications.CMessageFlagNotificationsSeen;
import io.github.lightman314.lightmanscurrency.network.server.messages.persistentdata.CMessageAddPersistentAuction;
import io.github.lightman314.lightmanscurrency.network.server.messages.persistentdata.CMessageAddPersistentTrader;
import io.github.lightman314.lightmanscurrency.network.server.messages.slot_machine.CMessageSlotMachine;
import io.github.lightman314.lightmanscurrency.network.server.messages.team.CMessageCreateTeam;
import io.github.lightman314.lightmanscurrency.network.server.messages.team.CMessageCreateTeamBankAccount;
import io.github.lightman314.lightmanscurrency.network.server.messages.team.CMessageDisbandTeam;
import io.github.lightman314.lightmanscurrency.network.server.messages.team.CMessageEditTeam;
import io.github.lightman314.lightmanscurrency.network.server.messages.team.CMessageRenameTeam;
import io.github.lightman314.lightmanscurrency.network.server.messages.team.CMessageSetTeamBankLimit;
import io.github.lightman314.lightmanscurrency.network.server.messages.ticket_machine.CMessageCraftTicket;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageAddOrRemoveTrade;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageCollectCoins;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageExecuteTrade;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageOpenStorage;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageOpenTrades;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageStorageInteraction;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageStoreCoins;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageTraderMessage;
import io.github.lightman314.lightmanscurrency.network.server.messages.traderinterface.CMessageHandlerMessage;
import io.github.lightman314.lightmanscurrency.network.server.messages.traderinterface.CMessageInterfaceInteraction;
import io.github.lightman314.lightmanscurrency.network.server.messages.wallet.CMessageOpenWalletBankMenu;
import io.github.lightman314.lightmanscurrency.network.server.messages.wallet.CMessageOpenWalletMenu;
import io.github.lightman314.lightmanscurrency.network.server.messages.wallet.CMessageWalletExchangeCoins;
import io.github.lightman314.lightmanscurrency.network.server.messages.wallet.CMessageWalletQuickCollect;
import io.github.lightman314.lightmanscurrency.network.server.messages.wallet.CMessageWalletToggleAutoExchange;
import io.github.lightman314.lightmanscurrency.network.server.messages.wallet.CPacketChestQuickCollect;
import io.github.lightman314.lightmanscurrency.network.server.messages.walletslot.CMessageSetWalletVisible;
import io.github.lightman314.lightmanscurrency.network.server.messages.walletslot.CMessageWalletInteraction;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class LCServerPacketHandler
implements ServerPlayNetworking.PlayChannelHandler {
    private final Map<class_2960, IServerPacketHandler> PACKET_HANDLERS = new HashMap<class_2960, IServerPacketHandler>();

    public LCServerPacketHandler() {
        this.registerPacketType(CMessageSubmitBid.PACKET_ID, CMessageSubmitBid::handle);
        this.registerPacketType(CPacketRequestNBT.PACKET_ID, CPacketRequestNBT::handle);
        this.registerPacketType(CMessageSelectBankAccount.PACKET_ID, CMessageSelectBankAccount::handle);
        this.registerPacketType(CMessageBankInteraction.PACKET_ID, CMessageBankInteraction::handle);
        this.registerPacketType(CMessageATMExchange.PACKET_ID, CMessageATMExchange::handle);
        this.registerPacketType(CMessageSetBankNotificationLevel.PACKET_ID, CMessageSetBankNotificationLevel::handle);
        this.registerPacketType(CMessageATMSetPlayerAccount.PACKET_ID, CMessageATMSetPlayerAccount::handle);
        this.registerPacketType(CMessageBankTransferPlayer.PACKET_ID, CMessageBankTransferPlayer::handle);
        this.registerPacketType(CMessageBankTransferTeam.PACKET_ID, CMessageBankTransferTeam::handle);
        this.registerPacketType(CMessageOpenRecoveryMenu.PACKET_ID, CMessageOpenRecoveryMenu::handle);
        this.registerPacketType(CMessageChangeSelectedData.PACKET_ID, CMessageChangeSelectedData::handle);
        this.registerPacketType(CMessageAddPersistentTrader.PACKET_ID, CMessageAddPersistentTrader::handle);
        this.registerPacketType(CMessageAddPersistentAuction.PACKET_ID, CMessageAddPersistentAuction::handle);
        this.registerPacketType(CMessageTraderMessage.PACKET_ID, CMessageTraderMessage::handle);
        this.registerPacketType(CMessageStorageInteraction.PACKET_ID, CMessageStorageInteraction::handle);
        this.registerPacketType(CMessageOpenTrades.PACKET_ID, CMessageOpenTrades::handle);
        this.registerPacketType(CMessageOpenStorage.PACKET_ID, CMessageOpenStorage::handle);
        this.registerPacketType(CMessageAddOrRemoveTrade.PACKET_ID, CMessageAddOrRemoveTrade::handle);
        this.registerPacketType(CMessageExecuteTrade.PACKET_ID, CMessageExecuteTrade::handle);
        this.registerPacketType(CMessageCollectCoins.PACKET_ID, CMessageCollectCoins::handle);
        this.registerPacketType(CMessageStoreCoins.PACKET_ID, CMessageStoreCoins::handle);
        this.registerPacketType(CMessageHandlerMessage.PACKET_ID, CMessageHandlerMessage::handle);
        this.registerPacketType(CMessageInterfaceInteraction.PACKET_ID, CMessageInterfaceInteraction::handle);
        this.registerPacketType(CMessageCreateTeamBankAccount.PACKET_ID, CMessageCreateTeamBankAccount::handle);
        this.registerPacketType(CMessageSetTeamBankLimit.PACKET_ID, CMessageSetTeamBankLimit::handle);
        this.registerPacketType(CMessageEditTeam.PACKET_ID, CMessageEditTeam::handle);
        this.registerPacketType(CMessageRenameTeam.PACKET_ID, CMessageRenameTeam::handle);
        this.registerPacketType(CMessageDisbandTeam.PACKET_ID, CMessageDisbandTeam::handle);
        this.registerPacketType(CMessageCreateTeam.PACKET_ID, CMessageCreateTeam::handle);
        this.registerPacketType(CMessageCraftTicket.PACKET_ID, CMessageCraftTicket::handle);
        this.registerPacketType(CMessageFlagNotificationsSeen.PACKET_ID, CMessageFlagNotificationsSeen::handle);
        this.registerPacketType(CMessageOpenWalletMenu.PACKET_ID, CMessageOpenWalletMenu::handle);
        this.registerPacketType(CMessageOpenWalletBankMenu.PACKET_ID, CMessageOpenWalletBankMenu::handle);
        this.registerPacketType(CMessageWalletExchangeCoins.PACKET_ID, CMessageWalletExchangeCoins::handle);
        this.registerPacketType(CMessageWalletToggleAutoExchange.PACKET_ID, CMessageWalletToggleAutoExchange::handle);
        this.registerPacketType(CMessageWalletQuickCollect.PACKET_ID, CMessageWalletQuickCollect::handle);
        this.registerPacketType(CPacketChestQuickCollect.PACKET_ID, CPacketChestQuickCollect::handle);
        this.registerPacketType(CMessageSetWalletVisible.PACKET_ID, CMessageSetWalletVisible::handle);
        this.registerPacketType(CMessageWalletInteraction.PACKET_ID, CMessageWalletInteraction::handle);
        this.registerPacketType(CMessageSlotMachine.PACKET_ID, CMessageSlotMachine::handle);
    }

    public void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buffer, PacketSender responseSender) {
        class_2960 type = new class_2960(buffer.method_19772());
        LazyPacketData data = LazyPacketData.decode(buffer);
        server.execute(() -> {
            try {
                LightmansCurrency.LogDebug("Handling server packet of type '" + type + "'!");
                if (!this.PACKET_HANDLERS.containsKey(type)) {
                    throw new RuntimeException("No packet handler was registered for Client -> Server packet type '" + type + "'!\nStacktrace: " + new Throwable());
                }
                this.PACKET_HANDLERS.get(type).handle(server, player, handler, data, responseSender);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error handling server packet!", t);
            }
        });
    }

    private void registerPacketType(class_2960 type, IServerPacketHandler handler) {
        if (this.PACKET_HANDLERS.containsKey(type)) {
            LightmansCurrency.LogWarning("LC Server Packet Handler already contains a registration for packet handler of type '" + type.toString() + "'.");
            return;
        }
        this.PACKET_HANDLERS.put(type, handler);
    }

    public static interface IServerPacketHandler {
        public void handle(MinecraftServer var1, class_3222 var2, class_3244 var3, LazyPacketData var4, PacketSender var5);
    }
}

