/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.server.messages.auction;

import io.github.lightman314.lightmanscurrency.common.menu.TraderMenu;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.network.server.ClientToServerPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class CMessageSubmitBid
extends ClientToServerPacket {
    public static final class_2960 PACKET_ID = new class_2960("lightmanscurrency", "auction_submit_bid");
    private final long auctionHouseID;
    private final int tradeIndex;
    private final CoinValue bidAmount;

    public CMessageSubmitBid(long auctionHouseID, int tradeIndex, CoinValue bidAmount) {
        super(PACKET_ID);
        this.auctionHouseID = auctionHouseID;
        this.tradeIndex = tradeIndex;
        this.bidAmount = bidAmount;
    }

    @Override
    protected void encode(LazyPacketData.Builder dataBuilder) {
        dataBuilder.setLong("trader", this.auctionHouseID).setInt("trade", this.tradeIndex).setCoinValue("bid", this.bidAmount);
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, LazyPacketData data, PacketSender responseSender) {
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof TraderMenu) {
            TraderMenu menu = (TraderMenu)class_17032;
            TraderData trader = TraderSaveData.GetTrader(false, data.getLong("trader"));
            if (trader instanceof AuctionHouseTrader) {
                AuctionHouseTrader ah = (AuctionHouseTrader)trader;
                ah.makeBid((class_1657)player, menu, data.getInt("trade"), data.getCoinValue("bid"));
            }
        }
    }
}

