/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;

public class FabricStorageUtil {
    public static class_1799 getStack(ItemVariant item, long amount) {
        return item.toStack((int)amount);
    }

    public static boolean hasItem(Storage<ItemVariant> storage, class_1799 stack) {
        return FabricStorageUtil.getItemCount(storage, stack) >= stack.method_7947();
    }

    public static int getItemCount(Storage<ItemVariant> storage, class_1799 stack) {
        int foundCount = 0;
        for (StorageView slot : storage) {
            if (!((ItemVariant)slot.getResource()).matches(stack)) continue;
            foundCount = (int)((long)foundCount + slot.getAmount());
        }
        return foundCount;
    }

    public static int getItemCount(Storage<ItemVariant> storage, Function<ItemVariant, Boolean> filter) {
        int foundCount = 0;
        for (StorageView slot : storage) {
            if (!filter.apply((ItemVariant)slot.getResource()).booleanValue()) continue;
            foundCount = (int)((long)foundCount + slot.getAmount());
        }
        return foundCount;
    }

    public static List<class_1799> getMatchingItems(Storage<ItemVariant> storage, Function<ItemVariant, Boolean> filter) {
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        for (StorageView slot : storage) {
            if (!filter.apply((ItemVariant)slot.getResource()).booleanValue()) continue;
            results.add(((ItemVariant)slot.getResource()).toStack());
        }
        return results;
    }

    public static FluidStack getStack(StorageView<FluidVariant> fluidView) {
        return new FluidStack(((FluidVariant)fluidView.getResource()).getFluid(), fluidView.getAmount(), ((FluidVariant)fluidView.getResource()).copyNbt());
    }

    public static boolean hasFluid(Storage<FluidVariant> storage, FluidStack stack) {
        return FabricStorageUtil.getFluidQuantity(storage, stack) >= stack.getAmount();
    }

    public static long getFluidQuantity(Storage<FluidVariant> storage, FluidStack stack) {
        long foundQuantity = 0L;
        Iterator iterator = storage.iterator();
        while (iterator.hasNext()) {
            FluidStack fluidEntry = FabricStorageUtil.getStack((StorageView<FluidVariant>)((StorageView)iterator.next()));
            if (!stack.matches(fluidEntry)) continue;
            foundQuantity += fluidEntry.getAmount();
        }
        return foundQuantity;
    }

    public static <T> Iterator<T> createIterator(List<T> list) {
        return new LazyIterator<T>(list);
    }

    public static <T> long insert(Storage<T> storage, T resource, long maxAmount) {
        return (Long)FabricStorageUtil.tryInsert(storage, resource, maxAmount, val -> true).getFirst();
    }

    public static <T> boolean tryInsertExact(Storage<T> storage, T resource, long exactAmount) {
        return (Boolean)FabricStorageUtil.tryInsert(storage, resource, exactAmount, val -> val == exactAmount).getSecond();
    }

    public static <T> Pair<Long, Boolean> tryInsert(Storage<T> storage, T resource, long maxAmount, Function<Long, Boolean> commitCheck) {
        Transaction transaction = FabricStorageUtil.newTransaction();
        if (transaction != null) {
            long result = storage.insert(resource, maxAmount, (TransactionContext)transaction);
            boolean commit = commitCheck.apply(result);
            if (commit) {
                transaction.commit();
            } else {
                transaction.abort();
            }
            return Pair.of((Object)result, (Object)commit);
        }
        return Pair.of((Object)0L, (Object)false);
    }

    public static <T> long simulateInsert(Storage<T> storage, T resource, long maxAmount) {
        Transaction transaction = FabricStorageUtil.newTransaction();
        if (transaction != null) {
            long result = storage.insert(resource, maxAmount, (TransactionContext)transaction);
            transaction.abort();
            return result;
        }
        return 0L;
    }

    public static <T> long extract(Storage<T> storage, T resource, long maxAmount) {
        return (Long)FabricStorageUtil.tryExtract(storage, resource, maxAmount, val -> true).getFirst();
    }

    public static <T> boolean tryExtractExact(Storage<T> storage, T resource, long exactAmount) {
        return (Boolean)FabricStorageUtil.tryExtract(storage, resource, exactAmount, val -> val == exactAmount).getSecond();
    }

    public static <T> Pair<Long, Boolean> tryExtract(Storage<T> storage, T resource, long maxAmount, Function<Long, Boolean> commitCheck) {
        Transaction transaction = FabricStorageUtil.newTransaction();
        if (transaction != null) {
            long result = storage.extract(resource, maxAmount, (TransactionContext)transaction);
            boolean commit = commitCheck.apply(result);
            if (commit) {
                transaction.commit();
            } else {
                transaction.abort();
            }
            return Pair.of((Object)result, (Object)commit);
        }
        return Pair.of((Object)0L, (Object)false);
    }

    public static <T> long simulateExtract(Storage<T> storage, T resource, long maxAmount) {
        Transaction transaction = FabricStorageUtil.newTransaction();
        if (transaction != null) {
            long result = storage.extract(resource, maxAmount, (TransactionContext)transaction);
            transaction.abort();
            return result;
        }
        return 0L;
    }

    private static Transaction newTransaction() {
        try {
            return Transaction.openOuter();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static class LazyIterator<T>
    implements Iterator<T> {
        private int currentIndex = 0;
        private final List<T> baseList;

        LazyIterator(List<T> list) {
            this.baseList = list;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.baseList.size();
        }

        @Override
        public T next() {
            return this.baseList.get(this.currentIndex++);
        }
    }
}

