/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1297;
import net.minecraft.class_1541;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2530;
import net.minecraft.class_2586;
import net.minecraft.class_2669;
import net.minecraft.class_2680;
import vazkii.botania.xplat.XplatAbstractions;

public class EthicalTntHelper {
    private static final ThreadLocal<EthicalTntHelper> tracker = ThreadLocal.withInitial(EthicalTntHelper::new);
    private final AtomicInteger trackTntEntities = new AtomicInteger();
    private final WeakHashMap<class_1937, IntOpenHashSet> trackedTntEntities = new WeakHashMap();

    public static void startTrackingTntEntities() {
        tracker.get().startTracking();
    }

    public static void addTrackedTntEntity(class_1541 entity) {
        tracker.get().addTrackedEntity(entity);
    }

    public static void endTrackingTntEntitiesAndCheck() {
        tracker.get().endTracking();
    }

    private void startTracking() {
        this.trackTntEntities.incrementAndGet();
    }

    private void addTrackedEntity(class_1541 entity) {
        if (this.trackTntEntities.get() > 0) {
            this.trackedTntEntities.computeIfAbsent(entity.method_37908(), lvl -> new IntOpenHashSet()).add(entity.method_5628());
        }
    }

    private void endTracking() {
        if (this.trackTntEntities.decrementAndGet() == 0) {
            for (Map.Entry<class_1937, IntOpenHashSet> entry : this.trackedTntEntities.entrySet()) {
                class_1937 level = entry.getKey();
                IntOpenHashSet trackedEntities = entry.getValue();
                if (trackedEntities == null) continue;
                for (Integer tntId : trackedEntities) {
                    class_1297 entity = level.method_8469(tntId.intValue());
                    if (!(entity instanceof class_1541)) continue;
                    class_1541 tnt = (class_1541)entity;
                    EthicalTntHelper.checkUnethical(tnt);
                }
                trackedEntities.clear();
            }
        }
    }

    private static void checkUnethical(class_1541 entity) {
        class_2338 center = entity.method_24515();
        if (!entity.method_37908().method_8477(center)) {
            return;
        }
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        for (class_2350 dir : class_2350.values()) {
            class_2669 movingBlockEntity;
            class_2586 blockEntity;
            class_2680 blockState;
            blockPos.method_25505((class_2382)center, dir);
            if (!entity.method_37908().method_8477((class_2338)blockPos) || !(blockState = entity.method_37908().method_8320((class_2338)blockPos)).method_27852(class_2246.field_10008) || !((blockEntity = entity.method_37908().method_8321((class_2338)blockPos)) instanceof class_2669) || (movingBlockEntity = (class_2669)blockEntity).method_11506() != dir || !(movingBlockEntity.method_11495().method_26204() instanceof class_2530)) continue;
            XplatAbstractions.INSTANCE.ethicalComponent(entity).markUnethical();
            break;
        }
    }
}

