/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_2338;

public class ForcePushHelper
implements AutoCloseable {
    private static final ThreadLocal<Deque<class_2338>> forcePushOriginStack = ThreadLocal.withInitial(ArrayDeque::new);
    private static final ThreadLocal<Deque<Boolean>> movementTypeContextStack = ThreadLocal.withInitial(ArrayDeque::new);

    public static boolean isForcePush() {
        return !forcePushOriginStack.get().isEmpty();
    }

    public static class_2338 getForcePushOrigin() {
        if (!ForcePushHelper.isForcePush()) {
            throw new IllegalStateException("Not currently performing a Force Relay or Force Lens push");
        }
        return forcePushOriginStack.get().peek();
    }

    public static void pushMovementTypeContext(boolean extending) {
        movementTypeContextStack.get().push(extending);
    }

    public static void popMovementTypeContext() {
        movementTypeContextStack.get().pop();
    }

    public static boolean isExtendingMovementContext() {
        return movementTypeContextStack.get().peek() == Boolean.TRUE;
    }

    public ForcePushHelper(class_2338 pushLocation) {
        forcePushOriginStack.get().push(pushLocation.method_10062());
    }

    @Override
    public void close() {
        forcePushOriginStack.get().pop();
    }
}

