/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.class_101;
import net.minecraft.class_104;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_173;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_201;
import net.minecraft.class_2035;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_212;
import net.minecraft.class_223;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2362;
import net.minecraft.class_2405;
import net.minecraft.class_2482;
import net.minecraft.class_2521;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_3837;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_52;
import net.minecraft.class_5270;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5646;
import net.minecraft.class_5651;
import net.minecraft.class_5658;
import net.minecraft.class_65;
import net.minecraft.class_7403;
import net.minecraft.class_77;
import net.minecraft.class_7784;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_83;
import net.minecraft.class_85;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaDoubleFlowerBlock;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.BotaniaGrassBlock;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class BlockLootProvider
implements class_2405 {
    private static final class_5341.class_210 SILK_TOUCH = class_223.method_945((class_2073.class_2074)class_2073.class_2074.method_8973().method_8978(new class_2035(class_1893.field_9099, class_2096.class_2100.method_9053((int)1))));
    private static final Function<class_2248, class_52.class_53> SKIP = b -> {
        throw new RuntimeException("shouldn't be executed");
    };
    private final class_7784.class_7489 pathProvider;
    private final Map<class_2248, Function<class_2248, class_52.class_53>> functionTable = new HashMap<class_2248, Function<class_2248, class_52.class_53>>();

    public BlockLootProvider(class_7784 packOutput) {
        this.pathProvider = packOutput.method_45973(class_7784.class_7490.field_39367, "loot_tables/blocks");
        for (class_2248 b2 : class_7923.field_41175) {
            class_2960 id = class_7923.field_41175.method_10221((Object)b2);
            if (!"botania".equals(id.method_12836())) continue;
            if (b2 instanceof class_2482) {
                this.functionTable.put(b2, BlockLootProvider::genSlab);
                continue;
            }
            if (b2 instanceof BotaniaDoubleFlowerBlock) {
                this.functionTable.put(b2, BlockLootProvider::genDoubleFlower);
                continue;
            }
            if (b2 instanceof BotaniaGrassBlock) {
                this.functionTable.put(b2, BlockLootProvider::genAltGrass);
                continue;
            }
            if (b2 instanceof class_2362) {
                class_2362 flowerPot = (class_2362)b2;
                this.functionTable.put(b2, block -> BlockLootProvider.createPotAndPlantItemTable((class_1935)flowerPot.method_16231()));
                continue;
            }
            if (!id.method_12832().matches("metamorphic_\\w+_stone")) continue;
            this.functionTable.put(b2, BlockLootProvider::genMetamorphicStone);
        }
        this.functionTable.put(BotaniaBlocks.bifrost, BlockLootProvider::empty);
        this.functionTable.put(BotaniaBlocks.cocoon, BlockLootProvider::empty);
        this.functionTable.put(BotaniaBlocks.fakeAir, BlockLootProvider::empty);
        this.functionTable.put(BotaniaBlocks.manaFlame, BlockLootProvider::empty);
        this.functionTable.put(BotaniaBlocks.cacophonium, b -> BlockLootProvider.genRegular(class_2246.field_10179));
        this.functionTable.put(BotaniaBlocks.enchantedSoil, b -> BlockLootProvider.genRegular(class_2246.field_10566));
        this.functionTable.put(BotaniaBlocks.enchanter, b -> BlockLootProvider.genRegular(class_2246.field_10441));
        this.functionTable.put(BotaniaBlocks.cellBlock, BlockLootProvider::genCellBlock);
        this.functionTable.put(BotaniaBlocks.root, BlockLootProvider::genRoot);
        this.functionTable.put(BotaniaBlocks.solidVines, BlockLootProvider::genSolidVine);
        this.functionTable.put(BotaniaBlocks.tinyPotato, BlockLootProvider::genTinyPotato);
        this.functionTable.put(BotaniaFlowerBlocks.gourmaryllis, b -> BlockLootProvider.genCopyNbt(b, "lastFoods", "lastFoodCount", "streakLength"));
        this.functionTable.put(BotaniaFlowerBlocks.gourmaryllisFloating, b -> BlockLootProvider.genCopyNbt(b, "lastFoods", "lastFoodCount", "streakLength"));
        this.functionTable.put(BotaniaFlowerBlocks.hydroangeas, b -> BlockLootProvider.genCopyNbt(b, "cooldown", "passiveDecayTicks"));
        this.functionTable.put(BotaniaFlowerBlocks.hydroangeasFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown", "passiveDecayTicks"));
        this.functionTable.put(BotaniaFlowerBlocks.munchdew, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(BotaniaFlowerBlocks.munchdewFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(BotaniaFlowerBlocks.rafflowsia, b -> BlockLootProvider.genCopyNbt(b, "lastFlowers", "lastFlowerTimes"));
        this.functionTable.put(BotaniaFlowerBlocks.rafflowsiaFloating, b -> BlockLootProvider.genCopyNbt(b, "lastFlowers", "lastFlowerTimes"));
        this.functionTable.put(BotaniaFlowerBlocks.spectrolus, b -> BlockLootProvider.genCopyNbt(b, "nextColor"));
        this.functionTable.put(BotaniaFlowerBlocks.spectrolusFloating, b -> BlockLootProvider.genCopyNbt(b, "nextColor"));
        this.functionTable.put(BotaniaFlowerBlocks.thermalily, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(BotaniaFlowerBlocks.thermalilyFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        HashMap<class_2960, class_52.class_53> tables = new HashMap<class_2960, class_52.class_53>();
        for (class_2248 b : class_7923.field_41175) {
            Function<class_2248, class_52.class_53> func;
            class_2960 id = class_7923.field_41175.method_10221((Object)b);
            if (!"botania".equals(id.method_12836()) || (func = this.functionTable.getOrDefault(b, BlockLootProvider::genRegular)) == SKIP) continue;
            tables.put(id, func.apply(b));
        }
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>();
        for (Map.Entry e : tables.entrySet()) {
            Path path = this.pathProvider.method_44107((class_2960)e.getKey());
            output.add(class_2405.method_10320((class_7403)cache, (JsonElement)class_5270.method_27862().create().toJsonTree((Object)((class_52.class_53)e.getValue()).method_334(class_173.field_1172).method_338()), (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    protected static class_52.class_53 empty(class_2248 b) {
        return class_52.method_324();
    }

    @Nullable
    protected static class_52.class_53 skip(class_2248 b) {
        return null;
    }

    protected static class_52.class_53 genCopyNbt(class_2248 b, String ... tags) {
        class_85.class_86 entry = class_77.method_411((class_1935)b);
        class_3837.class_3838 func = class_3837.method_16848((class_5651)class_5646.field_27914);
        for (String tag : tags) {
            func = func.method_16856(tag, "BlockEntityTag." + tag);
        }
        class_55.class_56 pool = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry).method_356(class_201.method_871()).method_353((class_117.class_118)func);
        return class_52.method_324().method_336(pool);
    }

    protected static class_52.class_53 genCellBlock(class_2248 b) {
        class_2073.class_2074 silkPred = class_2073.class_2074.method_8973().method_8978(new class_2035(class_1893.field_9099, class_2096.class_2100.method_9053((int)1)));
        class_79.class_80 silk = class_77.method_411((class_1935)b).method_421(class_223.method_945((class_2073.class_2074)silkPred));
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351(silk));
    }

    protected static class_52.class_53 genTinyPotato(class_2248 b) {
        class_85.class_86 entry = class_77.method_411((class_1935)b).method_438((class_117.class_118)class_101.method_473((class_101.class_102)class_101.class_102.field_1023));
        class_55.class_56 pool = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry).method_356(class_201.method_871());
        return class_52.method_324().method_336(pool);
    }

    protected static class_52.class_53 genMetamorphicStone(class_2248 b) {
        String cobbleName = class_7923.field_41175.method_10221((Object)b).method_12832().replaceAll("_stone", "_cobblestone");
        class_2248 cobble = (class_2248)class_7923.field_41175.method_17966(ResourceLocationHelper.prefix(cobbleName)).get();
        return BlockLootProvider.genSilkDrop((class_1935)b, (class_1935)cobble);
    }

    protected static class_52.class_53 genSilkDrop(class_1935 silkDrop, class_1935 normalDrop) {
        class_79.class_80 cobbleDrop = class_77.method_411((class_1935)normalDrop).method_421(class_201.method_871());
        class_79.class_80 stoneDrop = class_77.method_411((class_1935)silkDrop).method_421(SILK_TOUCH);
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)stoneDrop.method_417(cobbleDrop)));
    }

    protected static class_52.class_53 genSolidVine(class_2248 b) {
        class_85.class_86 entry = class_83.method_428((class_2960)new class_2960("blocks/vine"));
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry));
    }

    protected static class_52.class_53 genRoot(class_2248 b) {
        class_85.class_86 entry = class_77.method_411((class_1935)BotaniaItems.livingroot).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)4.0f))).method_438((class_117.class_118)class_104.method_478());
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry));
    }

    protected static class_52.class_53 genSlab(class_2248 b) {
        class_85.class_86 entry = class_77.method_411((class_1935)b).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)2.0f)).method_524((class_5341.class_210)class_212.method_900((class_2248)b).method_22584(class_4559.class_4560.method_22523().method_22525((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682)))).method_438((class_117.class_118)class_104.method_478());
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry));
    }

    protected static class_52.class_53 genDoubleFlower(class_2248 b) {
        class_85.class_86 entry = (class_85.class_86)((class_85.class_86)class_77.method_411((class_1935)b).method_421(class_201.method_871())).method_421((class_5341.class_210)class_212.method_900((class_2248)b).method_22584(class_4559.class_4560.method_22523().method_22525((class_2769)class_2521.field_10929, (Comparable)class_2756.field_12607)));
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry));
    }

    protected static class_52.class_53 genAltGrass(class_2248 b) {
        class_79.class_80 silk = class_77.method_411((class_1935)b).method_421(SILK_TOUCH);
        class_79.class_80 dirt = class_77.method_411((class_1935)class_2246.field_10566).method_421(class_201.method_871());
        class_65.class_66 entry = class_65.method_386((class_79.class_80[])new class_79.class_80[]{silk, dirt});
        class_55.class_56 pool = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry);
        return class_52.method_324().method_336(pool);
    }

    protected static class_52.class_53 genRegular(class_2248 b) {
        class_85.class_86 entry = class_77.method_411((class_1935)b);
        class_55.class_56 pool = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry).method_356(class_201.method_871());
        return class_52.method_324().method_336(pool);
    }

    protected static class_52.class_53 createPotAndPlantItemTable(class_1935 plant) {
        class_55.class_56 potPool = class_55.method_347().method_351((class_79.class_80)class_77.method_411((class_1935)class_2246.field_10495)).method_352((class_5658)class_44.method_32448((float)1.0f)).method_356(class_201.method_871());
        class_55.class_56 plantPool = class_55.method_347().method_351((class_79.class_80)class_77.method_411((class_1935)plant)).method_352((class_5658)class_44.method_32448((float)1.0f)).method_356(class_201.method_871());
        return class_52.method_324().method_336(potPool).method_336(plantPool);
    }

    @NotNull
    public String method_10321() {
        return "Botania block loot tables";
    }
}

