/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.ingredients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.StackHelper;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ItemStackListFactory {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<class_1799> create(StackHelper stackHelper) {
        ArrayList<class_1799> itemList = new ArrayList<class_1799>();
        HashSet<String> itemNameSet = new HashSet<String>();
        class_310 minecraft = class_310.method_1551();
        class_7699 features = Optional.of(minecraft).map(m -> m.field_1724).map(p -> p.field_3944).map(class_634::method_45735).orElse(class_7699.method_45397());
        boolean hasPermissions = (Boolean)minecraft.field_1690.method_47395().method_41753() != false || Optional.of(minecraft).map(m -> m.field_1724).map(class_1657::method_7338).orElse(false) != false;
        class_638 level = minecraft.field_1687;
        if (level == null) {
            throw new NullPointerException("minecraft.level must be set before JEI fetches ingredients");
        }
        class_5455 registryAccess = level.method_30349();
        class_1761.class_8128 displayParameters = new class_1761.class_8128(features, hasPermissions, (class_7225.class_7874)registryAccess);
        for (class_1761 itemGroup : class_7706.method_47341()) {
            Collection creativeTabItemStacks;
            if (itemGroup.method_47312() != class_1761.class_7916.field_41052) continue;
            try {
                itemGroup.method_47306(displayParameters);
            }
            catch (LinkageError | RuntimeException e) {
                LOGGER.error("Item Group crashed while building contents.Items from this group will be missing from the JEI ingredient list. {}", (Object)itemGroup, (Object)e);
                continue;
            }
            try {
                creativeTabItemStacks = itemGroup.method_45414();
            }
            catch (LinkageError | RuntimeException e) {
                LOGGER.error("Item Group crashed while getting display items.Some items from this group will be missing from the JEI ingredient list. {}", (Object)itemGroup, (Object)e);
                continue;
            }
            for (class_1799 itemStack : creativeTabItemStacks) {
                if (itemStack.method_7960()) {
                    LOGGER.error("Found an empty itemStack from creative tab: {}", (Object)itemGroup);
                    continue;
                }
                ItemStackListFactory.addItemStack(stackHelper, itemStack, itemList, itemNameSet);
            }
        }
        return itemList;
    }

    private static void addItemStack(StackHelper stackHelper, class_1799 stack, List<class_1799> itemList, Set<String> itemNameSet) {
        String itemKey;
        if (stack.method_7909() == class_1802.field_8575) {
            return;
        }
        try {
            itemKey = stackHelper.getUniqueIdentifierForStack(stack, UidContext.Ingredient);
        }
        catch (LinkageError | RuntimeException e) {
            String stackInfo = ErrorUtil.getItemStackInfo(stack);
            LOGGER.error("Couldn't get unique name for itemStack {}", (Object)stackInfo, (Object)e);
            return;
        }
        if (!itemNameSet.contains(itemKey)) {
            itemNameSet.add(itemKey);
            itemList.add(stack);
        }
    }
}

