/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.darkhax.bookshelf.api.registry.RegistryObject;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.data.recipes.potinteraction.PotInteraction;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.darkhax.botanypots.events.BotanyPotEventDispatcher;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_7923;

public class BotanyPotHelper {
    public static final CachedSupplier<class_3956<Soil>> SOIL_TYPE = RegistryObject.deferred((class_2378)class_7923.field_41188, (String)"botanypots", (String)"soil").cast();
    public static final CachedSupplier<class_1865<?>> SOIL_SERIALIZER = RegistryObject.deferred((class_2378)class_7923.field_41189, (String)"botanypots", (String)"soil").cast();
    public static final CachedSupplier<class_3956<Crop>> CROP_TYPE = RegistryObject.deferred((class_2378)class_7923.field_41188, (String)"botanypots", (String)"crop").cast();
    public static final CachedSupplier<class_1865<?>> CROP_SERIALIZER = RegistryObject.deferred((class_2378)class_7923.field_41189, (String)"botanypots", (String)"crop").cast();
    public static final CachedSupplier<class_3956<PotInteraction>> POT_INTERACTION_TYPE = RegistryObject.deferred((class_2378)class_7923.field_41188, (String)"botanypots", (String)"pot_interaction").cast();
    public static final CachedSupplier<class_1865<?>> SIMPLE_POT_INTERACTION_SERIALIZER = RegistryObject.deferred((class_2378)class_7923.field_41189, (String)"botanypots", (String)"pot_interaction").cast();
    public static final CachedSupplier<class_3956<Fertilizer>> FERTILIZER_TYPE = RegistryObject.deferred((class_2378)class_7923.field_41188, (String)"botanypots", (String)"fertilizer").cast();
    public static final CachedSupplier<class_1865<?>> BASIC_FERTILIZER_SERIALIZER = RegistryObject.deferred((class_2378)class_7923.field_41189, (String)"botanypots", (String)"fertilizer").cast();
    public static final BotanyPotEventDispatcher EVENT_DISPATCHER = (BotanyPotEventDispatcher)Services.load(BotanyPotEventDispatcher.class);

    public static int getRequiredGrowthTicks(class_1937 level, class_2338 pos, BlockEntityBotanyPot pot, @Nullable Crop crop, @Nullable Soil soil) {
        if (crop == null || soil == null) {
            return -1;
        }
        float requiredGrowthTicks = crop.getGrowthTicks(level, pos, pot, soil);
        float growthModifier = soil.getGrowthModifier(level, pos, pot, crop);
        if (growthModifier >= 0.0f) {
            return class_3532.method_15375((float)(requiredGrowthTicks / growthModifier));
        }
        return -1;
    }

    public static boolean canCropGrow(class_1937 level, class_2338 pos, BlockEntityBotanyPot pot, Soil soil, Crop crop) {
        if (soil == null || crop == null) {
            return false;
        }
        return soil.canGrowCrop(level, pos, pot, crop) && crop.canGrowInSoil(level, pos, pot, soil);
    }

    @Nullable
    public static Soil findSoil(class_1937 level, class_2338 pos, BlockEntityBotanyPot pot, class_1799 soilStack) {
        Soil result = null;
        if (level != null && !soilStack.method_7960()) {
            for (Soil soil : BotanyPotHelper.getAllRecipes(level.method_8433(), (class_3956)SOIL_TYPE.get())) {
                if (!soil.matchesLookup(level, pos, pot, soilStack)) continue;
                result = soil;
                break;
            }
        }
        return EVENT_DISPATCHER.postSoilLookup(level, pos, pot, soilStack, result);
    }

    @Nullable
    public static Crop findCrop(class_1937 level, class_2338 pos, BlockEntityBotanyPot pot, class_1799 stack) {
        Crop result = null;
        if (level != null && !stack.method_7960()) {
            for (Crop crop : BotanyPotHelper.getAllRecipes(level.method_8433(), (class_3956)CROP_TYPE.get())) {
                if (!crop.matchesLookup(level, pos, pot, stack)) continue;
                result = crop;
                break;
            }
        }
        return EVENT_DISPATCHER.postCropLookup(level, pos, pot, stack, result);
    }

    public static <C extends class_1263, T extends class_1860<C>> List<T> getAllRecipes(class_1863 manager, class_3956<T> type) {
        return manager.method_30027(type);
    }

    @Nullable
    public static PotInteraction findPotInteraction(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 heldStack, BlockEntityBotanyPot pot) {
        PotInteraction result = null;
        if (!heldStack.method_7960()) {
            for (PotInteraction interaction : BotanyPotHelper.getAllRecipes(world.method_8433(), (class_3956)POT_INTERACTION_TYPE.get())) {
                if (!interaction.canApply(state, world, pos, player, hand, heldStack, pot)) continue;
                result = interaction;
                break;
            }
        }
        return EVENT_DISPATCHER.postInteractionLookup(state, world, pos, player, hand, heldStack, pot, result);
    }

    @Nullable
    public static Fertilizer findFertilizer(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 heldStack, BlockEntityBotanyPot pot) {
        Fertilizer result = null;
        if (!heldStack.method_7960()) {
            for (Fertilizer fertilizer : BotanyPotHelper.getAllRecipes(world.method_8433(), (class_3956)FERTILIZER_TYPE.get())) {
                if (!fertilizer.canApply(state, world, pos, player, hand, heldStack, pot)) continue;
                result = fertilizer;
                break;
            }
        }
        return EVENT_DISPATCHER.postFertilizerLookup(state, world, pos, player, hand, heldStack, pot, result);
    }

    public static List<class_1799> generateDrop(Random rng, class_1937 level, class_2338 pos, BlockEntityBotanyPot pot, Crop crop) {
        return EVENT_DISPATCHER.postCropDrops(rng, level, pos, pot, crop, crop.generateDrops(rng, level, pos, pot));
    }
}

