/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.recipes.crop;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Set;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.botanypots.Constants;
import net.darkhax.botanypots.data.displaystate.DisplayState;
import net.darkhax.botanypots.data.recipes.crop.BasicCrop;
import net.darkhax.botanypots.data.recipes.crop.SerializerHarvestEntry;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public final class BasicCropSerializer
implements class_1865<BasicCrop> {
    public static BasicCropSerializer SERIALIZER = new BasicCropSerializer();

    public BasicCrop fromJson(class_2960 id, JsonObject json) {
        if (id.method_12836().equalsIgnoreCase("farmersdelight")) {
            Constants.LOG.warn("Crop {} has been disabled by the BotanyPot devs to improve compatibility.", (Object)id);
            return null;
        }
        class_1856 seed = (class_1856)Serializers.INGREDIENT.fromJSON(json, "seed");
        Set validSoils = Serializers.STRING.fromJSONSet(json, "categories");
        int growthTicks = (Integer)Serializers.INT.fromJSON(json, "growthTicks");
        List results = SerializerHarvestEntry.SERIALIZER.fromJSONList(json, "drops");
        int lightLevel = (Integer)Serializers.INT.fromJSON(json, "lightLevel", (Object)0);
        List states = DisplayState.SERIALIZER.fromJSONList(json, "display");
        if (growthTicks <= 0) {
            throw new IllegalArgumentException("Crop " + id + " has an invalid growth tick rate. It must use a positive integer.");
        }
        return new BasicCrop(id, seed, validSoils, growthTicks, results, states, lightLevel);
    }

    public BasicCrop fromNetwork(class_2960 id, class_2540 buffer) {
        class_1856 seed = (class_1856)Serializers.INGREDIENT.fromByteBuf(buffer);
        Set validSoils = Serializers.STRING.readByteBufSet(buffer);
        int growthTicks = (Integer)Serializers.INT.fromByteBuf(buffer);
        List results = SerializerHarvestEntry.SERIALIZER.fromByteBufList(buffer);
        List displayStates = DisplayState.SERIALIZER.fromByteBufList(buffer);
        int lightLevel = (Integer)Serializers.INT.fromByteBuf(buffer);
        return new BasicCrop(id, seed, validSoils, growthTicks, results, displayStates, lightLevel);
    }

    public void toNetwork(class_2540 buffer, BasicCrop toWrite) {
        Serializers.INGREDIENT.toByteBuf(buffer, (Object)toWrite.seed);
        Serializers.STRING.writeByteBufSet(buffer, toWrite.soilCategories);
        Serializers.INT.toByteBuf(buffer, (Object)toWrite.growthTicks);
        SerializerHarvestEntry.SERIALIZER.toByteBufList(buffer, toWrite.results);
        DisplayState.SERIALIZER.toByteBufList(buffer, toWrite.displayStates);
        Serializers.INT.toByteBuf(buffer, (Object)toWrite.lightLevel);
    }
}

