/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.recipes.soil;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.botanypots.Constants;
import net.darkhax.botanypots.data.displaystate.DisplayState;
import net.darkhax.botanypots.data.recipes.soil.BasicSoil;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public final class BasicSoilSerializer
implements class_1865<BasicSoil> {
    public static BasicSoilSerializer SERIALIZER = new BasicSoilSerializer();

    public BasicSoil fromJson(class_2960 id, JsonObject json) {
        if (id.method_12836().equalsIgnoreCase("farmersdelight")) {
            Constants.LOG.warn("Soil {} has been disabled by the BotanyPot devs to improve compatibility.", (Object)id);
            return null;
        }
        class_1856 input = (class_1856)Serializers.INGREDIENT.fromJSON(json, "input");
        DisplayState renderState = (DisplayState)DisplayState.SERIALIZER.fromJSON(json, "display");
        float growthModifier = ((Float)Serializers.FLOAT.fromJSON(json, "growthModifier", (Object)Float.valueOf(1.0f))).floatValue();
        Set categories = Serializers.STRING.fromJSONSet(json, "categories");
        int lightLevel = (Integer)Serializers.INT.fromJSON(json, "lightLevel", (Object)0);
        if (growthModifier <= -1.0f) {
            throw new JsonParseException("Soil " + id + " has an invalid growth modifier. It must be greater than -1. Growth modifier was " + growthModifier);
        }
        if (lightLevel > 15 || lightLevel < 0) {
            throw new JsonParseException("Soil " + id + " has an invalid light level. Light levels must be between 0 and 15. Light level was " + lightLevel);
        }
        return new BasicSoil(id, input, renderState, growthModifier, categories, lightLevel);
    }

    public BasicSoil fromNetwork(class_2960 id, class_2540 buffer) {
        class_1856 ingredient = (class_1856)Serializers.INGREDIENT.fromByteBuf(buffer);
        DisplayState renderState = (DisplayState)DisplayState.SERIALIZER.fromByteBuf(buffer);
        float growthModifier = ((Float)Serializers.FLOAT.fromByteBuf(buffer)).floatValue();
        HashSet<String> categories = new HashSet<String>(Serializers.STRING.fromByteBufList(buffer));
        int lightLevel = (Integer)Serializers.INT.fromByteBuf(buffer);
        return new BasicSoil(id, ingredient, renderState, growthModifier, categories, lightLevel);
    }

    public void toNetwork(class_2540 buffer, BasicSoil soilInfo) {
        Serializers.INGREDIENT.toByteBuf(buffer, (Object)soilInfo.ingredient);
        DisplayState.SERIALIZER.toByteBuf(buffer, (Object)soilInfo.displayState);
        Serializers.FLOAT.toByteBuf(buffer, (Object)Float.valueOf(soilInfo.growthModifier));
        Serializers.STRING.toByteBufList(buffer, new ArrayList<String>(soilInfo.categories));
        Serializers.INT.toByteBuf(buffer, (Object)soilInfo.lightLevel);
    }
}

