/*
 * Decompiled with CFR 0.152.
 */
package net.laith.avaritia.common.recipe;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.laith.avaritia.common.recipe.ExtremeRecipe;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7923;

public class ExtremeCraftingShapedRecipe
implements ExtremeRecipe {
    final int width;
    final int height;
    final class_2371<class_1856> input;
    final class_1799 output;
    private final class_2960 id;
    final String group;

    public ExtremeCraftingShapedRecipe(class_2960 id, String group, int width, int height, class_2371<class_1856> input, class_1799 output) {
        this.id = id;
        this.group = group;
        this.width = width;
        this.height = height;
        this.input = input;
        this.output = output;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    public String method_8112() {
        return this.group;
    }

    public class_2371<class_1856> method_8117() {
        return this.input;
    }

    public boolean method_8113(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public class_1799 method_8110(class_5455 registryManager) {
        return this.output;
    }

    public boolean matches(class_1715 craftingInventory, class_1937 world) {
        for (int i = 0; i <= craftingInventory.method_17398() - this.width; ++i) {
            for (int j = 0; j <= craftingInventory.method_17397() - this.height; ++j) {
                if (this.matchesPattern(craftingInventory, i, j, true)) {
                    return true;
                }
                if (!this.matchesPattern(craftingInventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public class_1799 craft(class_1715 inventory, class_5455 registryManager) {
        return this.method_8110(registryManager).method_7972();
    }

    private boolean matchesPattern(class_1715 inv, int offsetX, int offsetY, boolean flipped) {
        for (int i = 0; i < inv.method_17398(); ++i) {
            for (int j = 0; j < inv.method_17397(); ++j) {
                int k = i - offsetX;
                int l = j - offsetY;
                class_1856 ingredient = class_1856.field_9017;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    class_1856 class_18562 = ingredient = flipped ? (class_1856)this.input.get(this.width - k - 1 + l * this.width) : (class_1856)this.input.get(k + l * this.width);
                }
                if (ingredient.method_8093(inv.method_5438(i + j * inv.method_17398()))) continue;
                return false;
            }
        }
        return true;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    static class_2371<class_1856> createPatternMatrix(String[] pattern, Map<String, class_1856> symbols, int width, int height) {
        class_2371 defaultedList = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
        HashSet set = Sets.newHashSet(symbols.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String string = pattern[i].substring(j, j + 1);
                class_1856 ingredient = symbols.get(string);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                set.remove(string);
                defaultedList.set(j + width * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return defaultedList;
    }

    public boolean method_31584() {
        class_2371<class_1856> defaultedList = this.method_8117();
        return defaultedList.isEmpty() || defaultedList.stream().filter(ingredient -> !ingredient.method_8103()).anyMatch(ingredient -> ingredient.method_8105().length == 0);
    }

    private static int findFirstSymbol(String line) {
        int i;
        for (i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int findLastSymbol(String pattern) {
        int i;
        for (i = pattern.length() - 1; i >= 0 && pattern.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static String[] getPattern(JsonArray json) {
        String[] strings = new String[json.size()];
        if (strings.length > 9) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 9 is maximum");
        }
        if (strings.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = class_3518.method_15287((JsonElement)json.get(i), (String)("pattern[" + i + "]"));
            if (string.length() > 9) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 9 is maximum");
            }
            if (i > 0 && strings[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            strings[i] = string;
        }
        return strings;
    }

    static Map<String, class_1856> readSymbols(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), class_1856.method_8102((JsonElement)((JsonElement)entry.getValue()), (boolean)false));
        }
        map.put(" ", class_1856.field_9017);
        return map;
    }

    public static class_1799 outputFromJson(JsonObject json) {
        class_1792 item = ExtremeCraftingShapedRecipe.getItem(json);
        if (json.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = class_3518.method_15282((JsonObject)json, (String)"count", (int)1);
        if (i < 1) {
            throw new JsonSyntaxException("Invalid output count: " + i);
        }
        return new class_1799((class_1935)item, i);
    }

    public static class_1792 getItem(JsonObject json) {
        String string = class_3518.method_15265((JsonObject)json, (String)"item");
        class_1792 item = (class_1792)class_7923.field_41178.method_17966(new class_2960(string)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + string + "'"));
        if (item == class_1802.field_8162) {
            throw new JsonSyntaxException("Invalid item: " + string);
        }
        return item;
    }

    public static class Serializer
    implements class_1865<ExtremeCraftingShapedRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final class_2960 ID = new class_2960("shaped");

        public ExtremeCraftingShapedRecipe read(class_2960 identifier, JsonObject jsonObject) {
            String string = class_3518.method_15253((JsonObject)jsonObject, (String)"group", (String)"");
            Map<String, class_1856> map = ExtremeCraftingShapedRecipe.readSymbols(class_3518.method_15296((JsonObject)jsonObject, (String)"key"));
            String[] strings = ExtremeCraftingShapedRecipe.getPattern(class_3518.method_15261((JsonObject)jsonObject, (String)"pattern"));
            int i = strings[0].length();
            int j = strings.length;
            class_2371<class_1856> defaultedList = ExtremeCraftingShapedRecipe.createPatternMatrix(strings, map, i, j);
            class_1799 itemStack = ExtremeCraftingShapedRecipe.outputFromJson(class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
            return new ExtremeCraftingShapedRecipe(identifier, string, i, j, defaultedList, itemStack);
        }

        public ExtremeCraftingShapedRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
            int i = packetByteBuf.method_10816();
            int j = packetByteBuf.method_10816();
            String string = packetByteBuf.method_19772();
            class_2371 defaultedList = class_2371.method_10213((int)(i * j), (Object)class_1856.field_9017);
            for (int k = 0; k < defaultedList.size(); ++k) {
                defaultedList.set(k, (Object)class_1856.method_8086((class_2540)packetByteBuf));
            }
            class_1799 itemStack = packetByteBuf.method_10819();
            return new ExtremeCraftingShapedRecipe(identifier, string, i, j, (class_2371<class_1856>)defaultedList, itemStack);
        }

        public void write(class_2540 packetByteBuf, ExtremeCraftingShapedRecipe shapedRecipe) {
            packetByteBuf.method_10804(shapedRecipe.width);
            packetByteBuf.method_10804(shapedRecipe.height);
            packetByteBuf.method_10814(shapedRecipe.group);
            for (class_1856 ingredient : shapedRecipe.input) {
                ingredient.method_8088(packetByteBuf);
            }
            packetByteBuf.method_10793(shapedRecipe.output);
        }
    }
}

