/*
 * Decompiled with CFR 0.152.
 */
package net.laith.avaritia.init;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.laith.avaritia.client.render.EyeRenderer;
import net.laith.avaritia.client.render.WingRenderer;
import net.laith.avaritia.common.handler.InfinityHandler;
import net.laith.avaritia.init.ModDamageTypes;
import net.laith.avaritia.init.ModItems;
import net.laith.avaritia.init.ModTags;
import net.laith.avaritia.util.TextUtil;
import net.laith.avaritia.util.events.JumpEvent;
import net.laith.avaritia.util.helpers.BooleanHelper;
import net.laith.avaritia.util.helpers.ToolHelper;
import net.minecraft.class_1007;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_6862;
import net.minecraft.class_742;

public class ModEvents {

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        public static void register() {
            ClientTickEvents.START_WORLD_TICK.register(world -> {
                for (class_742 player : world.method_18456()) {
                    InfinityHandler.clientAbilities((class_1657)player);
                }
            });
            LivingEntityFeatureRendererRegistrationCallback.EVENT.register((entityType, entityRenderer, registrationHelper, context) -> {
                if (entityRenderer instanceof class_1007) {
                    class_1007 playerEntityRenderer = (class_1007)entityRenderer;
                    registrationHelper.register(new WingRenderer(playerEntityRenderer));
                    registrationHelper.register(new EyeRenderer(playerEntityRenderer));
                }
            });
            JumpEvent.ON_NORMAL.register(entity -> {
                class_1657 player;
                if (entity.method_37908().field_9236 && entity instanceof class_1657 && BooleanHelper.isWearingBoots(player = (class_1657)entity)) {
                    player.method_5762(0.0, 0.5, 0.0);
                }
            });
            JumpEvent.ON_SPRINT.register(entity -> {
                class_1657 player;
                if (entity.method_37908().field_9236 && entity instanceof class_1657 && BooleanHelper.isWearingBoots(player = (class_1657)entity)) {
                    player.method_5762(0.0, 0.08, 0.0);
                }
            });
            ItemTooltipCallback.EVENT.register((stack, context, list) -> {
                if (stack.method_7909() == ModItems.INFINITY_SWORD) {
                    int s = 0;
                    if (stack.method_7942()) {
                        List a = stack.method_7921().stream().toList();
                        s = a.size();
                    }
                    list.set(3 + s, class_2561.method_30163((String)(TextUtil.makeFabulous("+Infinite") + class_124.field_1077 + " Attack Damage")));
                    return;
                }
                TextUtil.armorTooltip(stack, ModItems.INFINITY_HELMET, TextUtil.makeFairiec("+DRACONIC"), "Eyes", list);
                TextUtil.armorTooltip(stack, ModItems.INFINITY_CHESTPLATE, TextUtil.makeAngelic("+ANGEL"), "Wings", list);
                TextUtil.armorTooltip(stack, ModItems.INFINITY_LEGGINGS, TextUtil.makeDemonic("+DEMONIC"), "Protection", list);
                TextUtil.armorTooltip(stack, ModItems.INFINITY_BOOTS, TextUtil.makeSANIC("+SANIC"), "Speed", list);
            });
        }
    }

    public static class Server {
        public static void register() {
            ServerTickEvents.START_WORLD_TICK.register(world -> {
                for (class_3222 player : world.method_18456()) {
                    InfinityHandler.serverAbilities((class_1657)player);
                }
            });
            ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
                if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    return !BooleanHelper.isWearingTheFullArmor(player);
                }
                return true;
            });
            AttackEntityCallback.EVENT.register((attacker, world, hand, entity, hitResult) -> {
                class_1657 victim;
                if (attacker.method_6118(class_1304.field_6173).method_31574(ModItems.INFINITY_SWORD) && !entity.method_37908().field_9236 && entity instanceof class_1657 && (victim = (class_1657)entity).method_7337() && !victim.method_29504() && victim.method_6032() > 0.0f && !BooleanHelper.isWearingTheFullArmor(victim)) {
                    victim.method_6066().method_5547(attacker.method_48923().method_48797(ModDamageTypes.INFINITY, (class_1297)attacker, (class_1297)victim), victim.method_6032());
                    victim.method_6033(0.0f);
                    victim.method_6078(attacker.method_48923().method_48797(ModDamageTypes.INFINITY, (class_1297)attacker, (class_1297)victim));
                    return class_1269.field_5812;
                }
                return class_1269.field_5811;
            });
            PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
                class_1799 stack = player.method_6118(class_1304.field_6173);
                if (stack.method_31574(ModItems.INFINITY_PICKAXE)) {
                    if (stack.method_7948().method_10577("hammer") && state.method_26164(ModTags.Blocks.INFINITY_PICKAXE)) {
                        ToolHelper.mineCube(player, world, ModTags.Blocks.INFINITY_PICKAXE);
                    }
                } else if (stack.method_7948().method_10577("destroyer") && state.method_26164(class_3481.field_33716)) {
                    ToolHelper.mineCube(player, world, (class_6862<class_2248>)class_3481.field_33716);
                }
                return true;
            });
        }
    }
}

