/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.pipes;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.ITransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.PipeAttachmentBlockEntity;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class FluidPipeBlockEntity
extends SmartBlockEntity
implements ITransformableBlockEntity,
PipeAttachmentBlockEntity {
    public FluidPipeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add(new StandardPipeFluidTransportBehaviour(this));
        behaviours.add(new BracketedBlockEntityBehaviour(this, this::canHaveBracket));
        this.registerAwardables(behaviours, FluidPropagator.getSharedTriggers());
    }

    @Override
    public void transform(StructureTransform transform) {
        BracketedBlockEntityBehaviour bracketBehaviour = this.getBehaviour(BracketedBlockEntityBehaviour.TYPE);
        if (bracketBehaviour != null) {
            bracketBehaviour.transformBracket(transform);
        }
    }

    private boolean canHaveBracket(class_2680 state) {
        return !(state.method_26204() instanceof EncasedPipeBlock);
    }

    @Nullable
    public Object getRenderAttachmentData() {
        return PipeAttachmentBlockEntity.getAttachments(this);
    }

    class StandardPipeFluidTransportBehaviour
    extends FluidTransportBehaviour {
        public StandardPipeFluidTransportBehaviour(SmartBlockEntity be) {
            super(be);
        }

        @Override
        public boolean canHaveFlowToward(class_2680 state, class_2350 direction) {
            return (FluidPipeBlock.isPipe(state) || state.method_26204() instanceof EncasedPipeBlock) && (Boolean)state.method_11654((class_2769)FluidPipeBlock.field_11329.get(direction)) != false;
        }

        @Override
        public FluidTransportBehaviour.AttachmentTypes getRenderedRimAttachment(class_1920 world, class_2338 pos, class_2680 state, class_2350 direction) {
            FluidTransportBehaviour pipeBehaviour;
            FluidTransportBehaviour.AttachmentTypes attachment = super.getRenderedRimAttachment(world, pos, state, direction);
            class_2338 offsetPos = pos.method_10093(direction);
            class_2680 otherState = world.method_8320(offsetPos);
            if (state.method_26204() instanceof EncasedPipeBlock && attachment != FluidTransportBehaviour.AttachmentTypes.DRAIN) {
                return FluidTransportBehaviour.AttachmentTypes.NONE;
            }
            if (attachment == FluidTransportBehaviour.AttachmentTypes.RIM && !FluidPipeBlock.isPipe(otherState) && !AllBlocks.MECHANICAL_PUMP.has(otherState) && !AllBlocks.ENCASED_FLUID_PIPE.has(otherState) && (pipeBehaviour = BlockEntityBehaviour.get((class_1922)world, offsetPos, FluidTransportBehaviour.TYPE)) != null && pipeBehaviour.canHaveFlowToward(otherState, direction.method_10153())) {
                return FluidTransportBehaviour.AttachmentTypes.CONNECTION;
            }
            if (attachment == FluidTransportBehaviour.AttachmentTypes.RIM && !FluidPipeBlock.shouldDrawRim(world, pos, state, direction)) {
                return FluidTransportBehaviour.AttachmentTypes.CONNECTION;
            }
            if (attachment == FluidTransportBehaviour.AttachmentTypes.NONE && ((Boolean)state.method_11654((class_2769)FluidPipeBlock.field_11329.get(direction))).booleanValue()) {
                return FluidTransportBehaviour.AttachmentTypes.CONNECTION;
            }
            return attachment;
        }
    }
}

