/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.signal;

import com.simibubi.create.content.contraptions.ITransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.signal.SignalBlock;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class SignalBlockEntity
extends SmartBlockEntity
implements ITransformableBlockEntity {
    public TrackTargetingBehaviour<SignalBoundary> edgePoint;
    private SignalState state = SignalState.INVALID;
    private OverlayState overlay = OverlayState.SKIP;
    private int switchToRedAfterTrainEntered;
    private boolean lastReportedPower = false;

    public SignalBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        NBTHelper.writeEnum(tag, "State", this.state);
        NBTHelper.writeEnum(tag, "Overlay", this.overlay);
        tag.method_10556("Power", this.lastReportedPower);
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.state = NBTHelper.readEnum(tag, "State", SignalState.class);
        this.overlay = NBTHelper.readEnum(tag, "Overlay", OverlayState.class);
        this.lastReportedPower = tag.method_10577("Power");
        this.invalidateRenderBoundingBox();
    }

    @Nullable
    public SignalBoundary getSignal() {
        return this.edgePoint.getEdgePoint();
    }

    public boolean isPowered() {
        return this.state == SignalState.RED;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.edgePoint = new TrackTargetingBehaviour<SignalBoundary>(this, EdgePointType.SIGNAL);
        behaviours.add(this.edgePoint);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_11863.field_9236) {
            return;
        }
        SignalBoundary boundary = this.getSignal();
        if (boundary == null) {
            this.enterState(SignalState.INVALID);
            this.setOverlay(OverlayState.RENDER);
            return;
        }
        class_2680 blockState = this.method_11010();
        blockState.method_28500((class_2769)SignalBlock.POWERED).ifPresent(powered -> {
            if (this.lastReportedPower == powered) {
                return;
            }
            this.lastReportedPower = powered;
            boundary.updateBlockEntityPower(this);
            this.notifyUpdate();
        });
        blockState.method_28500(SignalBlock.TYPE).ifPresent(stateType -> {
            SignalBlock.SignalType targetType = boundary.getTypeFor(this.field_11867);
            if (stateType != targetType) {
                this.field_11863.method_8652(this.field_11867, (class_2680)blockState.method_11657(SignalBlock.TYPE, (Comparable)((Object)targetType)), 3);
                this.refreshBlockState();
            }
        });
        this.enterState(boundary.getStateFor(this.field_11867));
        this.setOverlay(boundary.getOverlayFor(this.field_11867));
    }

    public boolean getReportedPower() {
        return this.lastReportedPower;
    }

    public SignalState getState() {
        return this.state;
    }

    public OverlayState getOverlay() {
        return this.overlay;
    }

    public void setOverlay(OverlayState state) {
        if (this.overlay == state) {
            return;
        }
        this.overlay = state;
        this.notifyUpdate();
    }

    public void enterState(SignalState state) {
        if (this.switchToRedAfterTrainEntered > 0) {
            --this.switchToRedAfterTrainEntered;
        }
        if (this.state == state) {
            return;
        }
        if (state == SignalState.RED && this.switchToRedAfterTrainEntered > 0) {
            return;
        }
        this.state = state;
        this.switchToRedAfterTrainEntered = state == SignalState.GREEN || state == SignalState.YELLOW ? 15 : 0;
        this.notifyUpdate();
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867, this.edgePoint.getGlobalPosition()).method_1014(2.0);
    }

    @Override
    public void transform(StructureTransform transform) {
        this.edgePoint.transform(transform);
    }

    public static enum SignalState {
        RED,
        YELLOW,
        GREEN,
        INVALID;


        public boolean isRedLight(float renderTime) {
            return this == RED || this == INVALID && renderTime % 40.0f < 3.0f;
        }

        public boolean isYellowLight(float renderTime) {
            return this == YELLOW;
        }

        public boolean isGreenLight(float renderTime) {
            return this == GREEN;
        }
    }

    public static enum OverlayState {
        RENDER,
        SKIP,
        DUAL;

    }
}

