/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.fluid;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.foundation.render.RenderTypes;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;

@Environment(value=EnvType.CLIENT)
public class FluidRenderer {
    public static class_4588 getFluidBuilder(class_4597 buffer) {
        return buffer.getBuffer(RenderTypes.getFluid());
    }

    public static void renderFluidStream(FluidStack fluidStack, class_2350 direction, float radius, float progress, boolean inbound, class_4597 buffer, class_4587 ms, int light) {
        FluidRenderer.renderFluidStream(fluidStack, direction, radius, progress, inbound, FluidRenderer.getFluidBuilder(buffer), ms, light);
    }

    public static void renderFluidStream(FluidStack fluidStack, class_2350 direction, float radius, float progress, boolean inbound, class_4588 builder, class_4587 ms, int light) {
        FluidVariant fluidVariant = fluidStack.getType();
        class_1058[] sprites = FluidVariantRendering.getSprites((FluidVariant)fluidVariant);
        if (sprites == null) {
            return;
        }
        class_1058 flowTexture = sprites[1];
        class_1058 stillTexture = sprites[0];
        int color = FluidVariantRendering.getColor((FluidVariant)fluidVariant);
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, FluidVariantAttributes.getLuminance((FluidVariant)fluidVariant));
        light = light & 0xF00000 | luminosity << 4;
        if (inbound) {
            direction = direction.method_10153();
        }
        TransformStack msr = TransformStack.cast((class_4587)ms);
        ms.method_22903();
        ((TransformStack)((TransformStack)((TransformStack)msr.centre()).rotateY((double)AngleHelper.horizontalAngle(direction))).rotateX(direction == class_2350.field_11036 ? 180.0 : (direction == class_2350.field_11033 ? 0.0 : 270.0))).unCentre();
        ms.method_22904(0.5, 0.0, 0.5);
        float h = radius;
        float hMin = -radius;
        float hMax = radius;
        float y = inbound ? 1.0f : 0.5f;
        float yMin = y - class_3532.method_15363((float)(progress * 0.5f), (float)0.0f, (float)1.0f);
        float yMax = y;
        for (int i = 0; i < 4; ++i) {
            ms.method_22903();
            FluidRenderer.renderFlowingTiledFace(class_2350.field_11035, hMin, yMin, hMax, yMax, h, builder, ms, light, color, flowTexture);
            ms.method_22909();
            msr.rotateY(90.0);
        }
        if (progress != 1.0f) {
            FluidRenderer.renderStillTiledFace(class_2350.field_11033, hMin, hMin, hMax, hMax, yMin, builder, ms, light, color, stillTexture);
        }
        ms.method_22909();
    }

    public static void renderFluidBox(FluidStack fluidStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, class_4597 buffer, class_4587 ms, int light, boolean renderBottom) {
        FluidRenderer.renderFluidBox(fluidStack, xMin, yMin, zMin, xMax, yMax, zMax, FluidRenderer.getFluidBuilder(buffer), ms, light, renderBottom);
    }

    public static void renderFluidBox(FluidStack fluidStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, class_4588 builder, class_4587 ms, int light, boolean renderBottom) {
        class_1058 fluidTexture;
        FluidVariant fluidVariant = fluidStack.getType();
        class_1058[] sprites = FluidVariantRendering.getSprites((FluidVariant)fluidVariant);
        class_1058 class_10582 = fluidTexture = sprites != null ? sprites[0] : null;
        if (fluidTexture == null) {
            return;
        }
        int color = FluidVariantRendering.getColor((FluidVariant)fluidVariant);
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, FluidVariantAttributes.getLuminance((FluidVariant)fluidVariant));
        light = light & 0xF00000 | luminosity << 4;
        class_243 center = new class_243((double)(xMin + (xMax - xMin) / 2.0f), (double)(yMin + (yMax - yMin) / 2.0f), (double)(zMin + (zMax - zMin) / 2.0f));
        ms.method_22903();
        if (FluidVariantAttributes.isLighterThanAir((FluidVariant)fluidVariant)) {
            ((TransformStack)((TransformStack)TransformStack.cast((class_4587)ms).translate(center)).rotateX(180.0)).translateBack(center);
        }
        for (class_2350 side : Iterate.directions) {
            boolean positive;
            if (side == class_2350.field_11033 && !renderBottom) continue;
            boolean bl = positive = side.method_10171() == class_2350.class_2352.field_11056;
            if (side.method_10166().method_10179()) {
                if (side.method_10166() == class_2350.class_2351.field_11048) {
                    FluidRenderer.renderStillTiledFace(side, zMin, yMin, zMax, yMax, positive ? xMax : xMin, builder, ms, light, color, fluidTexture);
                    continue;
                }
                FluidRenderer.renderStillTiledFace(side, xMin, yMin, xMax, yMax, positive ? zMax : zMin, builder, ms, light, color, fluidTexture);
                continue;
            }
            FluidRenderer.renderStillTiledFace(side, xMin, zMin, xMax, zMax, positive ? yMax : yMin, builder, ms, light, color, fluidTexture);
        }
        ms.method_22909();
    }

    public static void renderStillTiledFace(class_2350 dir, float left, float down, float right, float up, float depth, class_4588 builder, class_4587 ms, int light, int color, class_1058 texture) {
        FluidRenderer.renderTiledFace(dir, left, down, right, up, depth, builder, ms, light, color, texture, 1.0f);
    }

    public static void renderFlowingTiledFace(class_2350 dir, float left, float down, float right, float up, float depth, class_4588 builder, class_4587 ms, int light, int color, class_1058 texture) {
        FluidRenderer.renderTiledFace(dir, left, down, right, up, depth, builder, ms, light, color, texture, 0.5f);
    }

    public static void renderTiledFace(class_2350 dir, float left, float down, float right, float up, float depth, class_4588 builder, class_4587 ms, int light, int color, class_1058 texture, float textureScale) {
        boolean positive = dir.method_10171() == class_2350.class_2352.field_11056;
        boolean horizontal = dir.method_10166().method_10179();
        boolean x = dir.method_10166() == class_2350.class_2351.field_11048;
        float shrink = texture.method_23842() * 0.25f * textureScale;
        float centerU = texture.method_4594() + (texture.method_4577() - texture.method_4594()) * 0.5f * textureScale;
        float centerV = texture.method_4593() + (texture.method_4575() - texture.method_4593()) * 0.5f * textureScale;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float x1 = left;
        while (x1 < right) {
            float u2;
            float u1;
            float f = class_3532.method_15375((float)x1);
            x2 = Math.min(f + 1.0f, right);
            if (dir == class_2350.field_11043 || dir == class_2350.field_11034) {
                f = class_3532.method_15386((float)x2);
                u1 = texture.method_4580((double)((f - x2) * 16.0f * textureScale));
                u2 = texture.method_4580((double)((f - x1) * 16.0f * textureScale));
            } else {
                u1 = texture.method_4580((double)((x1 - f) * 16.0f * textureScale));
                u2 = texture.method_4580((double)((x2 - f) * 16.0f * textureScale));
            }
            u1 = class_3532.method_16439((float)shrink, (float)u1, (float)centerU);
            u2 = class_3532.method_16439((float)shrink, (float)u2, (float)centerU);
            float y1 = down;
            while (y1 < up) {
                float v2;
                float v1;
                f = class_3532.method_15375((float)y1);
                y2 = Math.min(f + 1.0f, up);
                if (dir == class_2350.field_11036) {
                    v1 = texture.method_4570((double)((y1 - f) * 16.0f * textureScale));
                    v2 = texture.method_4570((double)((y2 - f) * 16.0f * textureScale));
                } else {
                    f = class_3532.method_15386((float)y2);
                    v1 = texture.method_4570((double)((f - y2) * 16.0f * textureScale));
                    v2 = texture.method_4570((double)((f - y1) * 16.0f * textureScale));
                }
                v1 = class_3532.method_16439((float)shrink, (float)v1, (float)centerV);
                v2 = class_3532.method_16439((float)shrink, (float)v2, (float)centerV);
                if (horizontal) {
                    if (x) {
                        FluidRenderer.putVertex(builder, ms, depth, y2, positive ? x2 : x1, color, u1, v1, dir, light);
                        FluidRenderer.putVertex(builder, ms, depth, y1, positive ? x2 : x1, color, u1, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, depth, y1, positive ? x1 : x2, color, u2, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, depth, y2, positive ? x1 : x2, color, u2, v1, dir, light);
                    } else {
                        FluidRenderer.putVertex(builder, ms, positive ? x1 : x2, y2, depth, color, u1, v1, dir, light);
                        FluidRenderer.putVertex(builder, ms, positive ? x1 : x2, y1, depth, color, u1, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, positive ? x2 : x1, y1, depth, color, u2, v2, dir, light);
                        FluidRenderer.putVertex(builder, ms, positive ? x2 : x1, y2, depth, color, u2, v1, dir, light);
                    }
                } else {
                    FluidRenderer.putVertex(builder, ms, x1, depth, positive ? y1 : y2, color, u1, v1, dir, light);
                    FluidRenderer.putVertex(builder, ms, x1, depth, positive ? y2 : y1, color, u1, v2, dir, light);
                    FluidRenderer.putVertex(builder, ms, x2, depth, positive ? y2 : y1, color, u2, v2, dir, light);
                    FluidRenderer.putVertex(builder, ms, x2, depth, positive ? y1 : y2, color, u2, v1, dir, light);
                }
                y1 = y2;
            }
            x1 = x2;
        }
    }

    private static void putVertex(class_4588 builder, class_4587 ms, float x, float y, float z, int color, float u, float v, class_2350 face, int light) {
        class_2382 normal = face.method_10163();
        class_4587.class_4665 peek = ms.method_23760();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.method_22918(peek.method_23761(), x, y, z).method_1336(r, g, b, a).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(light).method_23763(peek.method_23762(), (float)normal.method_10263(), (float)normal.method_10264(), (float)normal.method_10260()).method_1344();
    }
}

