/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity;

import com.mrcrayfish.goblintraders.Config;
import com.mrcrayfish.goblintraders.core.ModSounds;
import com.mrcrayfish.goblintraders.entity.TraderCreatureEntity;
import com.mrcrayfish.goblintraders.entity.ai.goal.AttackRevengeTargetGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.EatFavouriteFoodGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.FindFavouriteFoodGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.FirePanicGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.FollowPotentialCustomerGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.LookAtCustomerGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.TradeWithPlayerGoal;
import com.mrcrayfish.goblintraders.trades.GoblinOffers;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1358;
import net.minecraft.class_1361;
import net.minecraft.class_1370;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1588;
import net.minecraft.class_1655;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1856;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3853;
import net.minecraft.class_4135;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public abstract class AbstractGoblinEntity
extends TraderCreatureEntity
implements class_1655 {
    public static final class_2940<Boolean> STUNNED = class_2945.method_12791(AbstractGoblinEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Float> STUN_ROTATION = class_2945.method_12791(AbstractGoblinEntity.class, (class_2941)class_2943.field_13320);
    @Nullable
    private class_1657 customer;
    private Set<UUID> tradedCustomers = new HashSet<UUID>();
    @Nullable
    private class_1916 offers;
    private int stunDelay;
    private int despawnDelay = 24000;
    private int fallCounter;
    private int restockDelay;

    protected AbstractGoblinEntity(class_1299<? extends TraderCreatureEntity> type, class_1937 level) {
        super(type, level);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new FirePanicGoal(this, 0.5));
        this.field_6201.method_6277(2, (class_1352)new TradeWithPlayerGoal(this));
        this.field_6201.method_6277(3, (class_1352)new LookAtCustomerGoal(this));
        this.field_6201.method_6277(4, (class_1352)new AttackRevengeTargetGoal(this));
        this.field_6201.method_6277(5, (class_1352)new FollowPotentialCustomerGoal(this));
        this.field_6201.method_6277(6, (class_1352)new FindFavouriteFoodGoal(this));
        this.field_6201.method_6277(7, (class_1352)new class_1391((class_1314)this, 0.4, class_1856.method_8101((class_1799[])new class_1799[]{this.getFavouriteFood()}), false));
        this.field_6201.method_6277(8, (class_1352)new EatFavouriteFoodGoal(this));
        this.field_6201.method_6277(8, (class_1352)new class_1394((class_1314)this, 0.4));
        this.field_6201.method_6277(9, (class_1352)new class_1370((class_1314)this, 0.4));
        this.field_6201.method_6277(10, (class_1352)new class_1358((class_1308)this, class_1657.class, 4.0f, 1.0f));
        this.field_6201.method_6277(11, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
    }

    protected void method_20417() {
        super.method_20417();
        if (this.isStunned()) {
            this.field_6201.method_6276(class_1352.class_4134.field_18405, true);
            this.field_6201.method_6276(class_1352.class_4134.field_18407, true);
            this.field_6201.method_6276(class_1352.class_4134.field_18406, true);
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(STUNNED, (Object)false);
        this.field_6011.method_12784(STUN_ROTATION, (Object)Float.valueOf(0.0f));
    }

    public abstract class_2960 getTexture();

    public int getFallCounter() {
        return this.fallCounter;
    }

    public class_1799 method_18866(class_1937 level, class_1799 stack) {
        if (stack.method_7909() == this.getFavouriteFood().method_7909() && stack.method_7909().method_19264() != null) {
            this.method_6033(this.method_6032() + (float)stack.method_7909().method_19264().method_19230());
        }
        return super.method_18866(level, stack);
    }

    public void method_5670() {
        super.method_5670();
        this.method_6119();
        if (this.stunDelay > 0) {
            --this.stunDelay;
            if (this.stunDelay == 0) {
                this.field_6011.method_12778(STUNNED, (Object)false);
                this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), (class_3414)ModSounds.ENTITY_GOBLIN_TRADER_ANNOYED_GRUNT.get(), class_3419.field_15254, 1.0f, 0.9f + this.method_6051().method_43057() * 0.2f);
            }
        }
        if (!(this.method_37908().method_8608() || ((Boolean)Config.ENTITIES.preventDespawnIfNamed.get()).booleanValue() && this.method_5947())) {
            this.handleDespawn();
        } else if (((Boolean)this.field_6011.method_12789(STUNNED)).booleanValue()) {
            if (this.fallCounter < 10) {
                ++this.fallCounter;
            }
        } else {
            this.fallCounter = 0;
        }
        if (!this.method_37908().method_8608() && this.getMaxRestockDelay() != -1 && ++this.restockDelay >= this.getMaxRestockDelay()) {
            this.method_8264().forEach(class_1914::method_19275);
            this.restockDelay = 0;
        }
    }

    public void method_8259(@Nullable class_1657 player) {
        this.customer = player;
    }

    @Nullable
    public class_1657 method_8257() {
        return this.customer;
    }

    public boolean hasCustomer() {
        return this.customer != null;
    }

    public class_1916 method_8264() {
        if (this.offers == null) {
            this.offers = new GoblinOffers();
            this.populateTradeData();
        }
        return this.offers;
    }

    protected abstract void populateTradeData();

    protected void addTrades(class_1916 offers, @Nullable List<class_3853.class_1652> trades, int max, boolean shuffle) {
        if (trades == null) {
            return;
        }
        List randomIndexes = IntStream.range(0, trades.size()).boxed().collect(Collectors.toList());
        if (shuffle) {
            Collections.shuffle(randomIndexes);
        }
        randomIndexes = randomIndexes.subList(0, Math.min(trades.size(), max));
        for (Integer index : randomIndexes) {
            class_3853.class_1652 trade = trades.get(index);
            class_1914 offer = trade.method_7246((class_1297)this, this.method_6051());
            if (offer == null) continue;
            offers.add((Object)offer);
        }
    }

    public void method_8261(@Nullable class_1916 offers) {
    }

    public void method_8262(class_1914 offer) {
        class_1937 class_19372;
        offer.method_8244();
        if (this.customer != null) {
            this.tradedCustomers.add(this.customer.method_5667());
        }
        if ((class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_1303.method_31493((class_3218)serverLevel, (class_243)this.method_30950(1.0f), (int)offer.method_19279());
        }
    }

    public void method_8258(class_1799 stack) {
    }

    public boolean method_38069() {
        return this.method_37908().method_8608();
    }

    public int method_19269() {
        return 0;
    }

    public void method_19271(int xpIn) {
    }

    public boolean method_19270() {
        return false;
    }

    public class_3414 method_18010() {
        return class_3417.field_14815;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 heldItem = player.method_5998(hand);
        if (heldItem.method_7909() == class_1802.field_8448) {
            heldItem.method_7920(player, (class_1309)this, hand);
            return class_1269.field_5812;
        }
        if (!(!this.method_5805() || this.hasCustomer() || this.method_6109() || !this.method_5753() && this.method_5809() || this.isStunned())) {
            if (this.method_8264().isEmpty()) {
                return class_1269.method_29236((boolean)this.method_38069());
            }
            if (!(this.method_38069() || this.method_6065() != null && this.method_6065() == player)) {
                this.method_8259(player);
                this.method_17449(player, this.method_5476(), 1);
            }
            return class_1269.method_29236((boolean)this.method_38069());
        }
        return super.method_5992(player, hand);
    }

    protected void method_6098(class_1799 stack, int count) {
        if (!stack.method_7960() && this.method_6115()) {
            if (stack.method_7976() == class_1839.field_8946) {
                this.method_5783(this.method_18807(stack), 0.5f, this.method_37908().method_8409().method_43057() * 0.1f + 0.9f);
            }
            if (stack.method_7976() == class_1839.field_8950) {
                this.spawnFoodParticles(stack, count);
                this.method_5783(this.method_18869(stack), 0.5f + 0.5f * (float)this.method_6051().method_43048(2), (this.method_6051().method_43057() - this.method_6051().method_43057()) * 0.2f + 1.0f);
            }
        }
    }

    protected void spawnFoodParticles(class_1799 stack, int count) {
        for (int i = 0; i < count; ++i) {
            class_243 frontPosition = class_243.method_1030((float)0.0f, (float)this.field_6283).method_1021(0.25);
            frontPosition = frontPosition.method_1031(0.0, 0.35, 0.0);
            frontPosition = frontPosition.method_1019(this.method_19538());
            class_243 motion = new class_243(this.method_6051().method_43058() * 0.2 - 0.1, 0.1, this.method_6051().method_43058() * 0.2 - 0.1);
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                serverLevel.method_14199((class_2394)new class_2392(class_2398.field_11218, stack), frontPosition.field_1352, frontPosition.field_1351, frontPosition.field_1350, 1, motion.field_1352, motion.field_1351 + 0.05, motion.field_1350, 0.0);
                continue;
            }
            this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, stack), frontPosition.field_1352, frontPosition.field_1351, frontPosition.field_1350, motion.field_1352, motion.field_1351 + 0.05, motion.field_1350);
        }
    }

    public boolean isPreviousCustomer(class_1657 player) {
        return this.tradedCustomers.contains(player.method_5667());
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean attacked = super.method_5643(source, amount);
        if (attacked && source.method_5529() instanceof class_1657) {
            this.method_5942().method_6340();
            this.field_6011.method_12778(STUNNED, (Object)true);
            this.field_6011.method_12778(STUN_ROTATION, (Object)Float.valueOf(this.getStunRotation(source.method_5529())));
            this.field_6201.method_19048().forEach(class_4135::method_6270);
            this.stunDelay = 20;
        }
        return attacked;
    }

    private float getStunRotation(@Nullable class_1297 entity) {
        return entity != null ? entity.method_36454() : 0.0f;
    }

    public int getStunDelay() {
        return this.stunDelay;
    }

    public void setDespawnDelay(int despawnDelay) {
        this.despawnDelay = despawnDelay;
    }

    public int getDespawnDelay() {
        return this.despawnDelay;
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10573("Offers", 10)) {
            this.offers = new GoblinOffers(compound.method_10562("Offers"));
        }
        if (compound.method_10573("DespawnDelay", 3)) {
            this.despawnDelay = compound.method_10550("DespawnDelay");
        }
        if (compound.method_10573("RestockDelay", 3)) {
            this.restockDelay = compound.method_10550("RestockDelay");
        }
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        class_1916 offers = this.method_8264();
        if (!offers.isEmpty()) {
            compound.method_10566("Offers", (class_2520)offers.method_8268());
        }
        compound.method_10569("DespawnDelay", this.despawnDelay);
        compound.method_10569("RestockDelay", this.restockDelay);
    }

    private void handleDespawn() {
        if (!this.hasCustomer() && --this.despawnDelay <= 0) {
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)ModSounds.ENTITY_GOBLIN_TRADER_IDLE_GRUNT.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)ModSounds.ENTITY_GOBLIN_TRADER_IDLE_GRUNT.get();
    }

    public abstract class_1799 getFavouriteFood();

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.7);
    }

    public boolean isStunned() {
        return (Boolean)this.field_6011.method_12789(STUNNED);
    }

    public float getStunRotation() {
        return ((Float)this.field_6011.method_12789(STUN_ROTATION)).floatValue();
    }

    protected abstract int getMaxRestockDelay();

    public abstract boolean canAttackBack();

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 mob) {
        return null;
    }
}

