/*
 * Decompiled with CFR 0.152.
 */
package net.zestyblaze.lootr.block.entities;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import net.zestyblaze.lootr.api.LootrAPI;
import net.zestyblaze.lootr.api.blockentity.ILootBlockEntity;
import net.zestyblaze.lootr.config.ConfigManager;
import net.zestyblaze.lootr.event.HandleChunk;
import net.zestyblaze.lootr.util.ServerAccessImpl;

public class TileTicker {
    private static final Object listLock = new Object();
    private static final Object worldLock = new Object();
    private static final Set<Entry> tileEntries = new ObjectLinkedOpenHashSet();
    private static final Set<Entry> pendingEntries = new ObjectLinkedOpenHashSet();
    private static boolean tickingList = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntry(class_1937 level, class_2338 position) {
        if (ConfigManager.get().conversion.disable) {
            return;
        }
        if (ServerAccessImpl.getServer() == null) {
            return;
        }
        class_5321 dimension = level.method_27983();
        if (ConfigManager.isDimensionBlacklisted((class_5321<class_1937>)dimension)) {
            return;
        }
        class_1923 chunkPos = new class_1923(position);
        class_2784 border = level.method_8621();
        ObjectLinkedOpenHashSet chunks = new ObjectLinkedOpenHashSet();
        chunks.add(chunkPos);
        int oX = chunkPos.field_9181;
        int oZ = chunkPos.field_9180;
        chunks.add(chunkPos);
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                class_1923 newPos = new class_1923(oX + x, oZ + z);
                if (ConfigManager.get().conversion.world_border && !border.method_11951(newPos)) continue;
                chunks.add(newPos);
            }
        }
        Entry newEntry = new Entry((class_5321<class_1937>)dimension, position, (Set<class_1923>)chunks, ServerAccessImpl.getServer().method_3780());
        Object object = listLock;
        synchronized (object) {
            if (tickingList) {
                pendingEntries.add(newEntry);
            } else {
                tileEntries.add(newEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serverTick() {
        ObjectLinkedOpenHashSet copy;
        if (ConfigManager.get().conversion.disable) {
            return;
        }
        HashSet<Entry> toRemove = new HashSet<Entry>();
        Object object = listLock;
        synchronized (object) {
            tickingList = true;
            copy = new ObjectLinkedOpenHashSet(tileEntries);
            tickingList = false;
        }
        object = worldLock;
        synchronized (object) {
            MinecraftServer server = ServerAccessImpl.getServer();
            for (Entry entry : copy) {
                class_2621 be;
                class_2586 blockEntity;
                class_3218 level;
                block26: {
                    block25: {
                        level = server.method_3847(entry.getDimension());
                        if (level == null || entry.age(server) > (long)ConfigManager.get().conversion.max_entry_age || ConfigManager.get().conversion.world_border && !level.method_8621().method_11952(entry.getPosition())) {
                            toRemove.add(entry);
                            continue;
                        }
                        if (!level.method_14178().method_12123(entry.getPosition().method_10263() >> 4, entry.getPosition().method_10260() >> 4)) continue;
                        boolean skip = false;
                        for (class_1923 chunkPos : entry.getChunkPositions()) {
                            if (level.method_14178().method_12123(chunkPos.field_9181, chunkPos.field_9180)) continue;
                            skip = true;
                            break;
                        }
                        Map<class_5321<class_1937>, Set<class_1923>> map = HandleChunk.LOADED_CHUNKS;
                        synchronized (map) {
                            Set<class_1923> loadedChunks = HandleChunk.LOADED_CHUNKS.get(entry.dimension);
                            if (loadedChunks != null) {
                                for (class_1923 chunkPos : entry.getChunkPositions()) {
                                    if (loadedChunks.contains(chunkPos)) continue;
                                    skip = true;
                                    break;
                                }
                            }
                        }
                        if (skip) continue;
                        blockEntity = level.method_8321(entry.getPosition());
                        if (!(blockEntity instanceof class_2621)) break block25;
                        be = (class_2621)blockEntity;
                        if (!(blockEntity instanceof ILootBlockEntity)) break block26;
                    }
                    toRemove.add(entry);
                    continue;
                }
                if (be.field_12037 == null || ConfigManager.isBlacklisted(be.field_12037)) {
                    toRemove.add(entry);
                    continue;
                }
                class_2680 stateAt = level.method_8320(entry.getPosition());
                class_2680 replacement = ConfigManager.replacement(stateAt);
                if (replacement == null) {
                    toRemove.add(entry);
                    continue;
                }
                class_2960 table = be.field_12037;
                long seed = be.field_12036;
                be.field_12037 = null;
                level.method_22352(entry.getPosition(), false);
                level.method_8652(entry.getPosition(), replacement, 2);
                blockEntity = level.method_8321(entry.getPosition());
                if (blockEntity instanceof ILootBlockEntity) {
                    ((class_2621)blockEntity).method_11285(table, seed);
                } else {
                    LootrAPI.LOG.error("replacement " + replacement + " is not an ILootTile " + entry.getDimension() + " at " + entry.getPosition());
                }
                toRemove.add(entry);
            }
        }
        object = listLock;
        synchronized (object) {
            tickingList = true;
            tileEntries.removeAll(toRemove);
            tileEntries.addAll(pendingEntries);
            tickingList = false;
            pendingEntries.clear();
        }
    }

    public static class Entry {
        private final class_5321<class_1937> dimension;
        private final class_2338 position;
        private final Set<class_1923> chunks;
        private final long addedAt;

        public Entry(class_5321<class_1937> dimension, class_2338 position, Set<class_1923> chunks, long addedAt) {
            this.dimension = dimension;
            this.position = position;
            this.chunks = chunks;
            this.addedAt = addedAt;
        }

        public class_5321<class_1937> getDimension() {
            return this.dimension;
        }

        public class_2338 getPosition() {
            return this.position;
        }

        public Set<class_1923> getChunkPositions() {
            return this.chunks;
        }

        public long age(MinecraftServer server) {
            return (long)server.method_3780() - this.addedAt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.dimension.equals(entry.dimension)) {
                return false;
            }
            return this.position.equals((Object)entry.position);
        }

        public int hashCode() {
            int result = this.dimension.hashCode();
            result = 31 * result + this.position.hashCode();
            return result;
        }
    }
}

