/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.api.client.metadata;

import com.google.common.primitives.Ints;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.moremcmeta.moremcmeta.api.client.metadata.MetadataView;
import io.github.moremcmeta.moremcmeta.api.client.metadata.NegativeKeyIndexException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;

public final class JsonMetadataView
implements MetadataView {
    private final Root ROOT;
    private final List<String> KEYS;
    private final int SIZE;

    public JsonMetadataView(JsonObject root, Comparator<? super String> keyComparator) {
        this.ROOT = new Root(Objects.requireNonNull(root, "Root cannot be null"));
        Objects.requireNonNull(keyComparator, "Key comparator cannot be null");
        this.KEYS = root.keySet().stream().filter(key -> !root.get(key).isJsonNull()).sorted(keyComparator).toList();
        this.SIZE = this.KEYS.size();
    }

    public JsonMetadataView(JsonArray root) {
        this.ROOT = new Root(Objects.requireNonNull(root, "Array cannot be null"));
        for (int index = root.size() - 1; index >= 0; --index) {
            if (!root.get(index).isJsonNull()) continue;
            root.remove(index);
        }
        this.SIZE = root.size();
        this.KEYS = IntStream.range(0, this.SIZE).mapToObj(String::valueOf).toList();
    }

    @Override
    public int size() {
        return this.SIZE;
    }

    @Override
    public Iterable<String> keys() {
        return this.KEYS;
    }

    @Override
    public boolean hasKey(String key) {
        Objects.requireNonNull(key, "Key cannot be null");
        int keyAsIndex = this.strAsIndex(key);
        return this.ROOT.get(obj -> obj.has(key) && !obj.get(key).isJsonNull(), array -> keyAsIndex >= 0 && keyAsIndex < this.SIZE);
    }

    @Override
    public boolean hasKey(int index) {
        if (index < 0) {
            throw new NegativeKeyIndexException(index);
        }
        return index < this.SIZE;
    }

    @Override
    public Optional<String> stringValue(String key) {
        return this.primitiveFromKey(key, element -> true, JsonPrimitive::getAsString);
    }

    @Override
    public Optional<String> stringValue(int index) {
        return this.primitiveFromIndex(index, element -> true, JsonPrimitive::getAsString);
    }

    @Override
    public Optional<Integer> integerValue(String key) {
        return this.primitiveFromKey(key, primitive -> primitive.isNumber() && this.isSignedInteger(primitive.getAsBigDecimal()), JsonPrimitive::getAsInt);
    }

    @Override
    public Optional<Integer> integerValue(int index) {
        return this.primitiveFromIndex(index, primitive -> primitive.isNumber() && this.isSignedInteger(primitive.getAsBigDecimal()), JsonPrimitive::getAsInt);
    }

    @Override
    public Optional<Long> longValue(String key) {
        return this.primitiveFromKey(key, primitive -> primitive.isNumber() && this.isSignedLong(primitive.getAsBigDecimal()), JsonPrimitive::getAsLong);
    }

    @Override
    public Optional<Long> longValue(int index) {
        return this.primitiveFromIndex(index, primitive -> primitive.isNumber() && this.isSignedLong(primitive.getAsBigDecimal()), JsonPrimitive::getAsLong);
    }

    @Override
    public Optional<Float> floatValue(String key) {
        return this.primitiveFromKey(key, primitive -> primitive.isNumber() && Float.isFinite(primitive.getAsBigDecimal().floatValue()), JsonPrimitive::getAsFloat);
    }

    @Override
    public Optional<Float> floatValue(int index) {
        return this.primitiveFromIndex(index, primitive -> primitive.isNumber() && Float.isFinite(primitive.getAsBigDecimal().floatValue()), JsonPrimitive::getAsFloat);
    }

    @Override
    public Optional<Double> doubleValue(String key) {
        return this.primitiveFromKey(key, primitive -> primitive.isNumber() && Double.isFinite(primitive.getAsBigDecimal().doubleValue()), JsonPrimitive::getAsDouble);
    }

    @Override
    public Optional<Double> doubleValue(int index) {
        return this.primitiveFromIndex(index, primitive -> primitive.isNumber() && Double.isFinite(primitive.getAsBigDecimal().doubleValue()), JsonPrimitive::getAsDouble);
    }

    @Override
    public Optional<Boolean> booleanValue(String key) {
        return this.primitiveFromKey(key, element -> true, JsonPrimitive::getAsBoolean);
    }

    @Override
    public Optional<Boolean> booleanValue(int index) {
        return this.primitiveFromIndex(index, element -> true, JsonPrimitive::getAsBoolean);
    }

    @Override
    public Optional<InputStream> byteStreamValue(String key) {
        return Optional.empty();
    }

    @Override
    public Optional<InputStream> byteStreamValue(int index) {
        if (index < 0) {
            throw new NegativeKeyIndexException(index);
        }
        return Optional.empty();
    }

    @Override
    public Optional<MetadataView> subView(String key) {
        return this.ROOT.get(obj -> {
            if (!obj.has(key)) {
                return Optional.empty();
            }
            return this.convertToSubView(obj.get(key));
        }, array -> {
            int keyAsIndex = this.strAsIndex(key);
            if (keyAsIndex < 0 || keyAsIndex >= this.SIZE) {
                return Optional.empty();
            }
            return this.convertToSubView(array.get(keyAsIndex));
        });
    }

    @Override
    public Optional<MetadataView> subView(int index) {
        if (!this.hasKey(index)) {
            return Optional.empty();
        }
        return this.ROOT.get(obj -> this.convertToSubView(this.objectElementByIndex((JsonObject)obj, index)), array -> this.convertToSubView(array.get(index)));
    }

    private int strAsIndex(String str) {
        int index = Optional.of(str).map(Ints::tryParse).orElse(-1);
        return index;
    }

    private <T> Optional<T> primitiveFromKey(String key, Function<JsonPrimitive, Boolean> checkFunction, Function<JsonPrimitive, T> convertFunction) {
        Objects.requireNonNull(key, "Key cannot be null");
        if (!this.hasKey(key)) {
            return Optional.empty();
        }
        int keyAsIndex = this.strAsIndex(key);
        return this.ROOT.get(obj -> this.primitiveOfType(obj.get(key), checkFunction, convertFunction), array -> this.primitiveOfType(array.get(keyAsIndex), checkFunction, convertFunction));
    }

    private <T> Optional<T> primitiveFromIndex(int index, Function<JsonPrimitive, Boolean> checkFunction, Function<JsonPrimitive, T> convertFunction) {
        if (!this.hasKey(index)) {
            return Optional.empty();
        }
        return this.ROOT.get(obj -> this.primitiveOfType(this.objectElementByIndex((JsonObject)obj, index), checkFunction, convertFunction), array -> this.primitiveOfType(array.get(index), checkFunction, convertFunction));
    }

    private <T> Optional<T> primitiveOfType(JsonElement element, Function<JsonPrimitive, Boolean> checkFunction, Function<JsonPrimitive, T> convertFunction) {
        if (!element.isJsonPrimitive()) {
            return Optional.empty();
        }
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (!checkFunction.apply(primitive).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of(convertFunction.apply(primitive));
    }

    private JsonElement objectElementByIndex(JsonObject obj, int index) {
        return obj.get(this.KEYS.get(index));
    }

    private boolean isSignedInteger(BigDecimal num) {
        return num.stripTrailingZeros().scale() <= 0 && this.isBetweenInclusive(num, BigDecimal.valueOf(Integer.MIN_VALUE), BigDecimal.valueOf(Integer.MAX_VALUE));
    }

    private boolean isSignedLong(BigDecimal num) {
        return num.stripTrailingZeros().scale() <= 0 && this.isBetweenInclusive(num, BigDecimal.valueOf(Long.MIN_VALUE), BigDecimal.valueOf(Long.MAX_VALUE));
    }

    private <T extends Comparable<? super T>> boolean isBetweenInclusive(T value, T lower, T upper) {
        return value.compareTo(lower) >= 0 && value.compareTo(upper) <= 0;
    }

    private Optional<MetadataView> convertToSubView(JsonElement element) {
        if (element.isJsonObject()) {
            return Optional.of(new JsonMetadataView(element.getAsJsonObject(), String::compareTo));
        }
        if (element.isJsonArray()) {
            return Optional.of(new JsonMetadataView(element.getAsJsonArray()));
        }
        return Optional.empty();
    }

    private static class Root {
        private final JsonObject OBJECT;
        private final JsonArray ARRAY;

        public Root(JsonObject object) {
            this.OBJECT = object;
            this.ARRAY = null;
        }

        public Root(JsonArray array) {
            this.OBJECT = null;
            this.ARRAY = array;
        }

        public <T> T get(Function<JsonObject, T> objectFunction, Function<JsonArray, T> arrayFunction) {
            if (this.OBJECT != null) {
                return objectFunction.apply(this.OBJECT);
            }
            if (this.ARRAY != null) {
                return arrayFunction.apply(this.ARRAY);
            }
            throw new IllegalStateException("Either object or array must be present");
        }
    }
}

