/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.api.client.metadata;

import io.github.moremcmeta.moremcmeta.api.client.metadata.InvalidRootResourceNameException;
import java.util.Objects;

public final class RootResourceName {
    private final String NAME;

    public RootResourceName(String name) {
        this.NAME = Objects.requireNonNull(name, "Root metadata name cannot be null");
        String regex = "[a-z0-9_.-]+";
        if (!name.matches(regex)) {
            throw new InvalidRootResourceNameException("Root metadata name must match " + regex + ", but was: " + name);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof RootResourceName)) {
            return false;
        }
        RootResourceName otherName = (RootResourceName)other;
        return this.NAME.equals(otherName.NAME);
    }

    public int hashCode() {
        return this.NAME.hashCode();
    }

    public String toString() {
        return this.NAME;
    }
}

