/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.api.client.texture;

import io.github.moremcmeta.moremcmeta.api.client.texture.IllegalRGBAComponentException;
import io.github.moremcmeta.moremcmeta.impl.client.texture.ColorBlender;

public final class Color {
    private static final int COMPONENT_MASK = 255;
    private static final int RED_OFFSET = 0;
    private static final int GREEN_OFFSET = 8;
    private static final int BLUE_OFFSET = 16;
    private static final int ALPHA_OFFSET = 24;

    public static int pack(int red, int green, int blue, int alpha) {
        Color.checkComponent(red);
        Color.checkComponent(green);
        Color.checkComponent(blue);
        Color.checkComponent(alpha);
        return alpha << 24 | red << 0 | green << 8 | blue << 16;
    }

    public static int red(int color) {
        return color >> 0 & 0xFF;
    }

    public static int green(int color) {
        return color >> 8 & 0xFF;
    }

    public static int blue(int color) {
        return color >> 16 & 0xFF;
    }

    public static int alpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static int alphaBlend(int topColor, int bottomColor) {
        return ColorBlender.alphaBlend(topColor, bottomColor);
    }

    public static boolean equalsOrBothInvisible(int color1, int color2) {
        return color1 == color2 || Color.alpha(color1) == 0 && Color.alpha(color2) == 0;
    }

    private Color() {
    }

    private static void checkComponent(int component) {
        if (component < 0 || component > 255) {
            throw new IllegalRGBAComponentException(component);
        }
    }
}

