/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.adapter;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.moremcmeta.moremcmeta.api.client.texture.PixelOutOfBoundsException;
import io.github.moremcmeta.moremcmeta.impl.client.texture.CloseableImage;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1011;

public final class NativeImageAdapter
implements CloseableImage {
    private final class_1011 IMAGE;
    private final int X_OFFSET;
    private final int Y_OFFSET;
    private final int WIDTH;
    private final int HEIGHT;
    private final int MIPMAP_LEVEL;
    private final boolean AUTO_CLOSE;
    private final AtomicBoolean CLOSED;
    private boolean blur;
    private boolean clamp;

    public NativeImageAdapter(class_1011 image, int mipmapLevel) {
        this(image, 0, 0, image.method_4307(), image.method_4323(), mipmapLevel, false, new AtomicBoolean());
    }

    public NativeImageAdapter(class_1011 image, int mipmapLevel, boolean blur, boolean clamp) {
        this(image, 0, 0, image.method_4307(), image.method_4323(), mipmapLevel, false, new AtomicBoolean());
        this.setBlur(blur);
        this.setClamp(clamp);
    }

    @Override
    public int color(int x, int y) {
        this.checkOpen();
        this.checkInBounds(x, y);
        return this.IMAGE.method_4315(x + this.X_OFFSET, y + this.Y_OFFSET);
    }

    @Override
    public void setColor(int x, int y, int color) {
        this.checkOpen();
        this.checkInBounds(x, y);
        this.IMAGE.method_4305(x + this.X_OFFSET, y + this.Y_OFFSET, color);
    }

    @Override
    public int width() {
        this.checkOpen();
        return this.WIDTH;
    }

    @Override
    public int height() {
        this.checkOpen();
        return this.HEIGHT;
    }

    @Override
    public void upload(int uploadX, int uploadY) {
        this.checkOpen();
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this.uploadImmediately(uploadX, uploadY));
        } else {
            this.uploadImmediately(uploadX, uploadY);
        }
    }

    @Override
    public CloseableImage subImage(int topLeftX, int topLeftY, int width, int height) {
        NativeImageAdapter subImage = new NativeImageAdapter(this.IMAGE, topLeftX, topLeftY, width, height, this.MIPMAP_LEVEL, this.AUTO_CLOSE, this.CLOSED);
        subImage.setBlur(this.blur());
        subImage.setClamp(this.clamp());
        return subImage;
    }

    @Override
    public void close() {
        this.CLOSED.set(true);
        this.IMAGE.close();
    }

    public boolean blur() {
        return this.blur;
    }

    public void setBlur(boolean blur) {
        this.blur = blur;
    }

    public boolean clamp() {
        return this.clamp;
    }

    public void setClamp(boolean clamp) {
        this.clamp = clamp;
    }

    public class_1011 image() {
        this.checkOpen();
        return this.IMAGE;
    }

    private NativeImageAdapter(class_1011 image, int xOffset, int yOffset, int width, int height, int mipmapLevel, boolean autoClose, AtomicBoolean sharedCloseStatus) {
        this.IMAGE = Objects.requireNonNull(image, "Image cannot be null");
        if (xOffset < 0) {
            throw new IllegalArgumentException("X offset cannot be negative");
        }
        if (yOffset < 0) {
            throw new IllegalArgumentException("Y offset cannot be negative");
        }
        if (width < 0) {
            throw new IllegalArgumentException("Width cannot be negative");
        }
        if (height < 0) {
            throw new IllegalArgumentException("Height cannot be negative");
        }
        if (mipmapLevel < 0) {
            throw new IllegalArgumentException("Mipmap level cannot be negative");
        }
        if (xOffset + width < 0 || xOffset + width > image.method_4307() || yOffset + height < 0 || yOffset + height > image.method_4323()) {
            throw new IllegalArgumentException("Sub image extends beyond original image");
        }
        this.X_OFFSET = xOffset;
        this.Y_OFFSET = yOffset;
        this.WIDTH = width;
        this.HEIGHT = height;
        this.MIPMAP_LEVEL = mipmapLevel;
        this.AUTO_CLOSE = autoClose;
        this.CLOSED = Objects.requireNonNull(sharedCloseStatus, "Close status cannot be null");
    }

    private void uploadImmediately(int uploadX, int uploadY) {
        this.IMAGE.method_22619(this.MIPMAP_LEVEL, uploadX, uploadY, this.X_OFFSET, this.Y_OFFSET, this.WIDTH, this.HEIGHT, this.blur, this.clamp, this.MIPMAP_LEVEL > 0, this.AUTO_CLOSE);
    }

    private void checkOpen() {
        if (this.CLOSED.get()) {
            throw new IllegalStateException("Image is closed");
        }
    }

    private void checkInBounds(int x, int y) {
        if (x < 0 || y < 0 || x >= this.WIDTH || y >= this.HEIGHT) {
            throw new PixelOutOfBoundsException(x, y);
        }
    }
}

