/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.io;

import io.github.moremcmeta.moremcmeta.api.client.MoreMcmetaTexturePlugin;
import io.github.moremcmeta.moremcmeta.api.client.metadata.AnalyzedMetadata;
import io.github.moremcmeta.moremcmeta.api.client.metadata.InvalidMetadataException;
import io.github.moremcmeta.moremcmeta.api.client.metadata.MetadataView;
import io.github.moremcmeta.moremcmeta.api.client.texture.ComponentBuilder;
import io.github.moremcmeta.moremcmeta.impl.client.io.BlurClampApplier;
import io.github.moremcmeta.moremcmeta.impl.client.io.ImageReader;
import io.github.moremcmeta.moremcmeta.impl.client.io.TextureData;
import io.github.moremcmeta.moremcmeta.impl.client.io.TextureReader;
import io.github.moremcmeta.moremcmeta.impl.client.texture.CloseableImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Triple;

public final class TextureDataReader<I extends CloseableImage>
implements TextureReader<TextureData<I>> {
    private static final int MAX_PLUGINS_APPLIED = 100;
    private final Map<String, MoreMcmetaTexturePlugin> SECTION_TO_PLUGIN;
    private final ImageReader<? extends I> IMAGE_READER;
    private final BlurClampApplier<? super I, ? extends I> BLUR_CLAMP_APPLIER;

    public TextureDataReader(Iterable<? extends MoreMcmetaTexturePlugin> plugins, ImageReader<? extends I> imageReader, BlurClampApplier<? super I, ? extends I> blurClampApplier) {
        Objects.requireNonNull(plugins, "Plugins cannot be null");
        this.SECTION_TO_PLUGIN = new HashMap<String, MoreMcmetaTexturePlugin>();
        plugins.forEach(plugin -> this.SECTION_TO_PLUGIN.put(plugin.sectionName(), (MoreMcmetaTexturePlugin)plugin));
        this.IMAGE_READER = Objects.requireNonNull(imageReader, "Image reader cannot be null");
        this.BLUR_CLAMP_APPLIER = Objects.requireNonNull(blurClampApplier, "Blur-clamp applier cannot be null");
    }

    @Override
    public TextureData<I> read(InputStream textureStream, MetadataView metadata) throws IOException, InvalidMetadataException {
        Objects.requireNonNull(textureStream, "Texture stream cannot be null");
        Objects.requireNonNull(metadata, "Metadata cannot be null");
        CloseableImage image = (CloseableImage)this.IMAGE_READER.read(textureStream);
        Objects.requireNonNull(image, "Image read cannot be null. Throw an IOException instead.");
        ArrayList<Triple<String, AnalyzedMetadata, ComponentBuilder>> analyzedSections = new ArrayList<Triple<String, AnalyzedMetadata, ComponentBuilder>>();
        Optional<Integer> frameWidthOptional = Optional.empty();
        Optional<Integer> frameHeightOptional = Optional.empty();
        Optional<Boolean> blurOptional = Optional.empty();
        Optional<Boolean> clampOptional = Optional.empty();
        for (String section : metadata.keys()) {
            AnalyzedMetadata sectionData;
            MoreMcmetaTexturePlugin plugin = this.SECTION_TO_PLUGIN.get(section);
            Optional<MetadataView> sectionView = metadata.subView(section);
            if (plugin == null || sectionView.isEmpty()) continue;
            try {
                sectionData = plugin.analyzer().analyze(sectionView.get(), image.width(), image.height());
            }
            catch (InvalidMetadataException err) {
                throw new InvalidMetadataException(String.format("%s marked metadata as invalid: %s", plugin.id(), err.getMessage()), err);
            }
            Objects.requireNonNull(sectionData, "Plugin " + plugin.id() + " returned null for analyzed metadata");
            analyzedSections.add(Triple.of((Object)plugin.id(), (Object)sectionData, (Object)plugin.componentBuilder()));
            frameWidthOptional = this.unwrapIfCompatible(frameWidthOptional, sectionData.frameWidth(), "frame width");
            frameHeightOptional = this.unwrapIfCompatible(frameHeightOptional, sectionData.frameHeight(), "frame width");
            blurOptional = this.unwrapIfCompatible(blurOptional, sectionData.blur(), "blur");
            clampOptional = this.unwrapIfCompatible(clampOptional, sectionData.clamp(), "clamp");
        }
        boolean blur = blurOptional.orElse(false);
        boolean clamp = clampOptional.orElse(false);
        image = (CloseableImage)this.BLUR_CLAMP_APPLIER.apply(image, blur, clamp);
        Objects.requireNonNull(image, "Blurred and clamped image cannot be null");
        int frameWidth = frameWidthOptional.orElse(image.width());
        int frameHeight = frameHeightOptional.orElse(image.height());
        if (frameWidth > image.width() || frameHeight > image.height()) {
            throw new InvalidMetadataException(String.format("%sx%s larger than %sx%s image", frameWidth, frameHeight, image.width(), image.height()));
        }
        if (frameWidth <= 0) {
            throw new InvalidMetadataException("Frame width cannot be zero or negative: " + frameWidth);
        }
        if (frameHeight <= 0) {
            throw new InvalidMetadataException("Frame height cannot be zero or negative: " + frameHeight);
        }
        TextureData.FrameSize frameSize = new TextureData.FrameSize(frameWidth, frameHeight);
        if (analyzedSections.size() > 100) {
            throw new InvalidMetadataException(analyzedSections.size() + " plugins applied, but 100 is the maximum");
        }
        return new TextureData<CloseableImage>(frameSize, blur, clamp, image, analyzedSections);
    }

    private <T> Optional<T> unwrapIfCompatible(Optional<T> currentVal, Optional<T> newVal, String propName) throws InvalidMetadataException {
        if (currentVal.isPresent() && newVal.isPresent() && !currentVal.get().equals(newVal.get())) {
            throw new InvalidMetadataException(String.format("%s was given conflicting values by two plugins: %s %s", propName, currentVal.get(), newVal.get()));
        }
        if (newVal.isPresent()) {
            return newVal;
        }
        return currentVal;
    }
}

