/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.resource;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.github.moremcmeta.moremcmeta.api.client.metadata.AnalyzedMetadata;
import io.github.moremcmeta.moremcmeta.api.client.metadata.MetadataRegistry;
import io.github.moremcmeta.moremcmeta.api.client.texture.ComponentBuilder;
import io.github.moremcmeta.moremcmeta.api.client.texture.SpriteName;
import io.github.moremcmeta.moremcmeta.impl.client.io.TextureData;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Triple;

public final class MetadataRegistryImpl
implements MetadataRegistry {
    private ImmutableMap<String, ImmutableMap<class_2960, AnalyzedMetadata>> metadata = ImmutableMap.of();

    @Override
    public Optional<AnalyzedMetadata> metadataFromPath(String pluginName, class_2960 textureLocation) {
        Objects.requireNonNull(pluginName, "Plugin name cannot be null");
        Objects.requireNonNull(textureLocation, "Texture location cannot be null");
        return Optional.ofNullable((AnalyzedMetadata)Objects.requireNonNull((ImmutableMap)this.metadata.getOrDefault((Object)pluginName, (Object)ImmutableMap.of()), "Metadata should never be null").get((Object)textureLocation));
    }

    @Override
    public Optional<AnalyzedMetadata> metadataFromSpriteName(String pluginName, class_2960 spriteName) {
        Objects.requireNonNull(pluginName, "Plugin name cannot be null");
        Objects.requireNonNull(spriteName, "Sprite name cannot be null");
        if (!SpriteName.isSpriteName(spriteName)) {
            return Optional.empty();
        }
        return Optional.ofNullable((AnalyzedMetadata)Objects.requireNonNull((ImmutableMap)this.metadata.getOrDefault((Object)pluginName, (Object)ImmutableMap.of()), "Metadata should never be null").get((Object)SpriteName.toTexturePath(spriteName)));
    }

    public Map<class_2960, AnalyzedMetadata> metadataByPlugin(String pluginName) {
        Objects.requireNonNull(pluginName, "Plugin name cannot be null");
        return (Map)this.metadata.getOrDefault((Object)pluginName, (Object)ImmutableMap.of());
    }

    public void set(Map<? extends class_2960, ? extends TextureData<?>> textureData) {
        Objects.requireNonNull(textureData, "Texture data cannot be null");
        HashMap<String, ImmutableMap.Builder> builders = new HashMap<String, ImmutableMap.Builder>();
        for (Map.Entry<class_2960, TextureData<?>> entry : textureData.entrySet()) {
            class_2960 textureLocation = entry.getKey();
            for (Triple<String, AnalyzedMetadata, ComponentBuilder> pluginEntry : entry.getValue().analyzedMetadata()) {
                String pluginName = (String)pluginEntry.getLeft();
                AnalyzedMetadata sectionData = (AnalyzedMetadata)pluginEntry.getMiddle();
                builders.computeIfAbsent(pluginName, key -> new ImmutableMap.Builder()).put((Object)textureLocation, (Object)sectionData);
            }
        }
        this.metadata = ImmutableMap.copyOf((Map)Maps.transformValues(builders, ImmutableMap.Builder::build));
    }
}

