/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.resource;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.moremcmeta.moremcmeta.impl.client.resource.ResourceCollection;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_2960;
import net.minecraft.class_3264;

public class OrderedResourceRepository {
    private final class_3264 RESOURCE_TYPE;
    private final ImmutableList<ResourceCollection> COLLECTIONS;
    private final ImmutableMap<String, List<ResourceCollectionResult>> COLLECTIONS_BY_NAMESPACE;

    public OrderedResourceRepository(class_3264 resourceType, Collection<? extends ResourceCollection> resourceCollections) {
        this.RESOURCE_TYPE = Objects.requireNonNull(resourceType, "Resource type cannot be null");
        Objects.requireNonNull(resourceCollections, "Resource collection list cannot be null");
        if (resourceCollections.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("Individual resource collections cannot be null");
        }
        this.COLLECTIONS = ImmutableList.copyOf(resourceCollections);
        HashMap builders = new HashMap();
        IntStream.range(0, this.COLLECTIONS.size()).mapToObj(index -> new ResourceCollectionResult((ResourceCollection)this.COLLECTIONS.get(index), index)).forEach(collection -> collection.collection().namespaces(resourceType).forEach(namespace -> builders.computeIfAbsent(namespace, ns -> new ImmutableList.Builder()).add(collection)));
        this.COLLECTIONS_BY_NAMESPACE = ImmutableMap.copyOf(builders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ImmutableList.Builder)entry.getValue()).build())));
    }

    public class_3264 resourceType() {
        return this.RESOURCE_TYPE;
    }

    public List<ResourceCollection> collections() {
        return this.COLLECTIONS;
    }

    public ResourceCollectionResult firstCollectionWith(class_2960 location) throws IOException {
        Objects.requireNonNull(location, "Location cannot be null");
        Optional<ResourceCollectionResult> collectionWithResource = ((List)this.COLLECTIONS_BY_NAMESPACE.getOrDefault((Object)location.method_12836(), (Object)ImmutableList.of())).stream().filter(collectionResult -> collectionResult.collection().contains(this.RESOURCE_TYPE, location)).findFirst();
        if (collectionWithResource.isEmpty()) {
            throw new IOException("Resource not found in any collection: " + location);
        }
        return collectionWithResource.get();
    }

    public boolean contains(class_2960 location) {
        Objects.requireNonNull(location, "Location cannot be null");
        return ((List)this.COLLECTIONS_BY_NAMESPACE.getOrDefault((Object)location.method_12836(), (Object)ImmutableList.of())).stream().anyMatch(collectionResult -> collectionResult.collection().contains(this.RESOURCE_TYPE, location));
    }

    public Set<class_2960> list(String pathStart, Predicate<String> fileFilter) {
        Objects.requireNonNull(pathStart, "Path start cannot be null");
        Objects.requireNonNull(fileFilter, "Path filter cannot be null");
        return this.COLLECTIONS.stream().flatMap(collection -> collection.namespaces(this.RESOURCE_TYPE).stream().flatMap(namespace -> collection.list(this.RESOURCE_TYPE, (String)namespace, pathStart, fileFilter).stream())).collect(Collectors.toSet());
    }

    public static final class ResourceCollectionResult {
        private final ResourceCollection COLLECTION;
        private final int INDEX;

        private ResourceCollectionResult(ResourceCollection collection, int index) {
            this.COLLECTION = Objects.requireNonNull(collection, "Resource collection cannot be null");
            this.INDEX = index;
        }

        public ResourceCollection collection() {
            return this.COLLECTION;
        }

        public int collectionIndex() {
            return this.INDEX;
        }
    }
}

