/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.resource;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.github.moremcmeta.moremcmeta.api.client.metadata.InvalidMetadataException;
import io.github.moremcmeta.moremcmeta.api.client.metadata.MetadataParser;
import io.github.moremcmeta.moremcmeta.api.client.metadata.MetadataView;
import io.github.moremcmeta.moremcmeta.api.client.metadata.ResourceRepository;
import io.github.moremcmeta.moremcmeta.api.client.metadata.RootResourceName;
import io.github.moremcmeta.moremcmeta.impl.client.io.TextureReader;
import io.github.moremcmeta.moremcmeta.impl.client.resource.OrderedResourceRepository;
import io.github.moremcmeta.moremcmeta.impl.client.resource.ResourceCollection;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Logger;

public final class TextureLoader<R> {
    private final TextureReader<? extends R> TEXTURE_READER;
    private final Map<String, ? extends MetadataParser> PARSERS;
    private final Logger LOGGER;

    public TextureLoader(TextureReader<? extends R> textureReader, ImmutableMap<String, ? extends MetadataParser> metadataParsers, Logger logger) {
        this.TEXTURE_READER = Objects.requireNonNull(textureReader, "Texture reader cannot be null");
        this.PARSERS = (Map)Objects.requireNonNull(metadataParsers, "Metadata parsers cannot be null");
        if (this.PARSERS.keySet().stream().anyMatch(ext -> ext.lastIndexOf(46) != 0 || ext.length() < 2)) {
            throw new IllegalArgumentException("File extensions must contain only one period (.) at the start and contain least one other character");
        }
        this.LOGGER = Objects.requireNonNull(logger, "Logger cannot be null");
    }

    public ImmutableMap<class_2960, R> load(OrderedResourceRepository repository, String ... paths) {
        Objects.requireNonNull(repository, "Resource manager cannot be null");
        Objects.requireNonNull(paths, "Paths cannot be null");
        Optional<String> invalidPath = Arrays.stream(paths).filter(path -> path.isEmpty() || path.startsWith("/")).findAny();
        if (invalidPath.isPresent()) {
            throw new IllegalArgumentException("Path cannot be empty or start with a slash: " + invalidPath.get());
        }
        Set<class_2960> metadataCandidates = this.searchResources(repository, paths, fileName -> this.PARSERS.keySet().stream().anyMatch(fileName::endsWith));
        return this.makeTextures(metadataCandidates, repository, paths);
    }

    private Set<class_2960> searchResources(OrderedResourceRepository repository, String[] paths, Predicate<String> fileNameFilter) {
        HashSet<class_2960> results = new HashSet<class_2960>();
        for (String path : paths) {
            results.addAll(repository.list(path, fileNameFilter));
        }
        return results;
    }

    private ResourceRepository.Pack wrap(final ResourceCollection original, final class_3264 resourceType) {
        return new ResourceRepository.Pack(){

            @Override
            public Optional<InputStream> resource(class_2960 location) {
                try {
                    return Optional.of(original.find(resourceType, location));
                }
                catch (IOException err) {
                    return Optional.empty();
                }
            }

            @Override
            public class_2960 locateRootResource(RootResourceName rootResource) {
                return original.locateRootResource(rootResource.toString());
            }
        };
    }

    private ResourceRepository wrap(final OrderedResourceRepository original, final String[] paths) {
        final Function<class_2960, Optional> collectionFinder = location -> {
            try {
                return Optional.of(original.firstCollectionWith((class_2960)location));
            }
            catch (IOException err) {
                return Optional.empty();
            }
        };
        final BiFunction<class_2960, Integer, Optional> highestPackWith = (loc, maxIndex) -> {
            Optional result = (Optional)collectionFinder.apply((class_2960)loc);
            if (result.isEmpty() || ((OrderedResourceRepository.ResourceCollectionResult)result.get()).collectionIndex() > maxIndex) {
                return Optional.empty();
            }
            return Optional.of(this.wrap(((OrderedResourceRepository.ResourceCollectionResult)result.get()).collection(), original.resourceType()));
        };
        return new ResourceRepository(){

            @Override
            public Optional<ResourceRepository.Pack> highestPackWith(class_2960 location) {
                return (Optional)highestPackWith.apply(location, Integer.MAX_VALUE);
            }

            @Override
            public Optional<ResourceRepository.Pack> highestPackWith(class_2960 location, class_2960 floor) {
                int maxIndex = ((Optional)collectionFinder.apply(floor)).map(OrderedResourceRepository.ResourceCollectionResult::collectionIndex).orElse(Integer.MAX_VALUE);
                return (Optional)highestPackWith.apply(location, maxIndex);
            }

            public Set<class_2960> list(Predicate<String> fileFilter) {
                return TextureLoader.this.searchResources(original, paths, fileFilter);
            }
        };
    }

    private ImmutableMap<class_2960, R> makeTextures(Collection<? extends class_2960> candidates, OrderedResourceRepository repository, String ... paths) {
        ConcurrentHashMap<class_2960, ReadMetadataFile> locationToMetadata = new ConcurrentHashMap<class_2960, ReadMetadataFile>();
        this.readRootMetadata(repository, locationToMetadata);
        ((Stream)candidates.stream().distinct().parallel()).forEach(metadataLocation -> this.readMetadata(repository, (class_2960)metadataLocation, (Map<class_2960, ReadMetadataFile>)locationToMetadata, paths));
        ConcurrentHashMap textures = new ConcurrentHashMap();
        ((Stream)this.combineByTexture(repository, locationToMetadata).entrySet().stream().parallel()).forEach(entry -> this.readTexture(repository, (class_2960)entry.getKey(), (MetadataView)entry.getValue(), textures));
        return ImmutableMap.copyOf(textures);
    }

    private void readRootMetadata(OrderedResourceRepository repository, Map<class_2960, ReadMetadataFile> results) {
        List<ResourceCollection> collections = repository.collections();
        IntStream.range(0, collections.size()).parallel().forEach(index -> {
            ResourceRepository.Pack pack = this.wrap((ResourceCollection)collections.get(index), repository.resourceType());
            this.PARSERS.forEach((extension, parser) -> {
                Map<class_2960, ReadMetadataFile> metadata = parser.parse(pack).entrySet().stream().collect(Collectors.toMap(metadataEntry -> pack.locateRootResource((RootResourceName)metadataEntry.getKey()), metadataEntry -> new ReadMetadataFile((Map<? extends class_2960, ? extends MetadataView>)((Map)metadataEntry.getValue()).entrySet().stream().collect(Collectors.toMap(textureEntry -> pack.locateRootResource((RootResourceName)textureEntry.getKey()), Map.Entry::getValue)), index, (String)extension)));
                results.putAll(metadata);
            });
        });
    }

    private void readMetadata(OrderedResourceRepository repository, class_2960 metadataLocation, Map<class_2960, ReadMetadataFile> results, String ... paths) {
        block3: {
            class_3264 resourceType = repository.resourceType();
            try {
                OrderedResourceRepository.ResourceCollectionResult metadataResources = repository.firstCollectionWith(metadataLocation);
                String metadataPath = metadataLocation.method_12832();
                String extension = metadataPath.substring(metadataPath.lastIndexOf(46));
                InputStream metadataStream = metadataResources.collection().find(resourceType, metadataLocation);
                Map<? extends class_2960, ? extends MetadataView> metadata = this.PARSERS.get(extension).parse(metadataLocation, metadataStream, this.wrap(repository, paths));
                metadataStream.close();
                results.put(metadataLocation, new ReadMetadataFile(metadata, metadataResources.collectionIndex(), extension));
            }
            catch (IOException ioException) {
                this.LOGGER.error("Texture associated with metadata in file {} is missing: {}", (Object)metadataLocation, (Object)ioException);
            }
            catch (InvalidMetadataException metadataError) {
                if (metadataError.silenced()) break block3;
                this.LOGGER.error("Invalid metadata in file {}: {}", (Object)metadataLocation, (Object)metadataError);
            }
        }
    }

    private Map<class_2960, MetadataView> combineByTexture(OrderedResourceRepository repository, Map<class_2960, ReadMetadataFile> metadataLocationToMetadata) {
        HashMap<class_2960, TextureMetadata> textureToAllMetadata = new HashMap<class_2960, TextureMetadata>();
        metadataLocationToMetadata.forEach((metadataLocation, file) -> file.METADATA_BY_TEXTURE.forEach((textureLocation, metadata) -> textureToAllMetadata.computeIfAbsent((class_2960)textureLocation, location -> new TextureMetadata()).put((class_2960)metadataLocation, file.METADATA_BY_TEXTURE.get(textureLocation), file.COLLECTION_INDEX, file.EXTENSION)));
        HashMap<class_2960, MetadataView> textureToCombinedMetadata = new HashMap<class_2960, MetadataView>();
        textureToAllMetadata.forEach((textureLocation, allMetadata) -> {
            MetadataView combinedMetadata;
            Optional<Integer> textureIndexOptional = this.findCollectionIndex(repository, (class_2960)textureLocation);
            if (textureIndexOptional.isEmpty()) {
                this.LOGGER.error("Unable to find texture {} (referenced by {})", textureLocation, (Object)TextureLoader.join(allMetadata.metadataLocations()));
                return;
            }
            int textureCollectionIndex = textureIndexOptional.get();
            Set<String> extensions = (allMetadata = allMetadata.metadataApplicableToTextureIn(textureCollectionIndex)).extensions();
            if (extensions.isEmpty()) {
                return;
            }
            if (extensions.size() != 1) {
                this.LOGGER.error("Cannot apply metadata in multiple formats to texture {} (applied {})", textureLocation, (Object)TextureLoader.join(allMetadata.metadataLocations()));
                return;
            }
            String extension = (String)Iterables.getOnlyElement(extensions);
            if (allMetadata.size() > 1) {
                try {
                    combinedMetadata = this.PARSERS.get(extension).combine((class_2960)textureLocation, (Map<? extends class_2960, ? extends MetadataView>)allMetadata.metadataByLocation());
                }
                catch (InvalidMetadataException err) {
                    if (!err.silenced()) {
                        this.LOGGER.error("Unable to combine metadata for texture {} (applied {}): {}", textureLocation, (Object)TextureLoader.join(allMetadata.metadataLocations()), (Object)err);
                    }
                    return;
                }
            } else {
                combinedMetadata = (MetadataView)Iterables.getOnlyElement(allMetadata.metadataByLocation().values());
            }
            textureToCombinedMetadata.put((class_2960)textureLocation, combinedMetadata);
        });
        return textureToCombinedMetadata;
    }

    private Optional<Integer> findCollectionIndex(OrderedResourceRepository repository, class_2960 location) {
        try {
            return Optional.of(repository.firstCollectionWith(location).collectionIndex());
        }
        catch (IOException err) {
            return Optional.empty();
        }
    }

    private void readTexture(OrderedResourceRepository repository, class_2960 textureLocation, MetadataView metadata, Map<class_2960, R> results) {
        block3: {
            class_3264 resourceType = repository.resourceType();
            try {
                OrderedResourceRepository.ResourceCollectionResult collectionResult = repository.firstCollectionWith(textureLocation);
                InputStream textureStream = collectionResult.collection().find(resourceType, textureLocation);
                R texture = this.TEXTURE_READER.read(textureStream, metadata);
                textureStream.close();
                results.put(textureLocation, texture);
            }
            catch (IOException err) {
                this.LOGGER.error("Unable to read texture {}: {}", (Object)textureLocation, (Object)err);
            }
            catch (InvalidMetadataException metadataError) {
                if (metadataError.silenced()) break block3;
                this.LOGGER.error("Invalid metadata for texture {}: {}", (Object)textureLocation, (Object)metadataError);
            }
        }
    }

    private static String join(Set<class_2960> locations) {
        return locations.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    private static class ReadMetadataFile {
        public final Map<? extends class_2960, ? extends MetadataView> METADATA_BY_TEXTURE;
        public final int COLLECTION_INDEX;
        public final String EXTENSION;

        public ReadMetadataFile(Map<? extends class_2960, ? extends MetadataView> metadataByTexture, int collection, String extension) {
            this.METADATA_BY_TEXTURE = metadataByTexture;
            this.COLLECTION_INDEX = collection;
            this.EXTENSION = extension;
        }
    }

    private static class TextureMetadata {
        private final Map<class_2960, Triple<MetadataView, Integer, String>> METADATA;

        public TextureMetadata() {
            this.METADATA = new HashMap<class_2960, Triple<MetadataView, Integer, String>>();
        }

        public void put(class_2960 metadataLocation, MetadataView metadata, int collection, String extension) {
            this.METADATA.put(metadataLocation, (Triple<MetadataView, Integer, String>)Triple.of((Object)metadata, (Object)collection, (Object)extension));
        }

        public Set<class_2960> metadataLocations() {
            return ImmutableSet.copyOf(this.METADATA.keySet());
        }

        public Set<String> extensions() {
            return ImmutableSet.copyOf((Collection)this.METADATA.values().stream().map(Triple::getRight).collect(Collectors.toSet()));
        }

        public Map<class_2960, MetadataView> metadataByLocation() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            this.METADATA.forEach((location, triple) -> builder.put(location, (Object)((MetadataView)triple.getLeft())));
            return builder.build();
        }

        public int size() {
            return this.METADATA.size();
        }

        public TextureMetadata metadataApplicableToTextureIn(int collection) {
            return new TextureMetadata(this.METADATA.entrySet().stream().filter(entry -> (Integer)((Triple)entry.getValue()).getMiddle() <= collection).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }

        private TextureMetadata(Map<class_2960, Triple<MetadataView, Integer, String>> metadata) {
            this.METADATA = metadata;
        }
    }
}

