/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.texture;

import com.google.common.collect.ImmutableSet;
import io.github.moremcmeta.moremcmeta.impl.client.texture.Atlas;
import io.github.moremcmeta.moremcmeta.impl.client.texture.Sprite;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2960;

public final class SpriteFinder {
    private static final ImmutableSet<class_2960> ATLAS_LOCATIONS = ImmutableSet.of((Object)new class_2960("textures/atlas/blocks.png"), (Object)new class_2960("textures/atlas/signs.png"), (Object)new class_2960("textures/atlas/banner_patterns.png"), (Object)new class_2960("textures/atlas/shield_patterns.png"), (Object)new class_2960("textures/atlas/chest.png"), (Object)new class_2960("textures/atlas/beds.png"), (Object[])new class_2960[]{new class_2960("textures/atlas/particles.png"), new class_2960("textures/atlas/paintings.png"), new class_2960("textures/atlas/mob_effects.png")});
    private final Function<class_2960, ? extends Atlas> ATLAS_GETTER;

    public SpriteFinder(Function<class_2960, ? extends Atlas> atlasGetter) {
        this.ATLAS_GETTER = Objects.requireNonNull(atlasGetter, "Atlas getter cannot be null");
    }

    public Optional<Sprite> findSprite(class_2960 location) {
        Objects.requireNonNull(location, "Location cannot be null");
        return this.findNew(location);
    }

    private Optional<Sprite> findNew(class_2960 location) {
        for (class_2960 atlasLocation : ATLAS_LOCATIONS) {
            Atlas atlas = this.ATLAS_GETTER.apply(atlasLocation);
            Objects.requireNonNull(atlas, "Atlas getter cannot supply null");
            Optional<Sprite> sprite = atlas.sprite(location);
            if (!sprite.isPresent()) continue;
            return sprite;
        }
        return Optional.empty();
    }
}

