/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.texture;

import io.github.moremcmeta.moremcmeta.impl.client.texture.CustomTickable;
import io.github.moremcmeta.moremcmeta.impl.client.texture.Manager;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1044;
import net.minecraft.class_2960;

public final class TextureManagerWrapper<T extends class_1044>
implements Manager<T> {
    private final Manager<? super class_1044> DELEGATE;
    private final Map<class_2960, CustomTickable> TICKABLE_TEXTURES;

    public TextureManagerWrapper(Manager<? super class_1044> delegate) {
        this.DELEGATE = Objects.requireNonNull(delegate, "Delegate manager cannot be null");
        this.TICKABLE_TEXTURES = new ConcurrentHashMap<class_2960, CustomTickable>();
    }

    @Override
    public void register(class_2960 textureLocation, T texture) {
        Objects.requireNonNull(textureLocation, "Texture location cannot be null");
        Objects.requireNonNull(texture, "Texture cannot be null");
        this.TICKABLE_TEXTURES.put(textureLocation, (CustomTickable)texture);
        this.DELEGATE.register(textureLocation, (class_1044)texture);
    }

    @Override
    public void unregister(class_2960 textureLocation) {
        Objects.requireNonNull(textureLocation, "Texture location cannot be null");
        this.DELEGATE.unregister(textureLocation);
        this.TICKABLE_TEXTURES.remove(textureLocation);
    }

    @Override
    public void tick() {
        this.TICKABLE_TEXTURES.values().forEach(CustomTickable::tick);
    }
}

