/*
 * Decompiled with CFR 0.152.
 */
package com.chefsdelights.farmersrespite.integration.emi;

import com.chefsdelights.farmersrespite.common.crafting.KettleRecipe;
import com.chefsdelights.farmersrespite.core.FarmersRespite;
import com.chefsdelights.farmersrespite.integration.emi.EMIPlugin;
import com.google.common.collect.ImmutableList;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class KettleEMIRecipe
implements EmiRecipe {
    private static final class_2960 GUI_TEXTURE = new class_2960("farmersrespite", "textures/gui/rei/kettle_rei.png");
    private final class_2960 id;
    private final EmiIngredient containerOutput;
    private final List<EmiIngredient> ingredient;
    private final int brewTime;
    private final boolean needWater;
    private final EmiStack output;

    public KettleEMIRecipe(KettleRecipe recipe) {
        this.id = recipe.method_8114();
        this.ingredient = recipe.method_8117().stream().map(EmiIngredient::of).toList();
        this.output = EmiStack.of((class_1799)recipe.method_8110(null));
        this.containerOutput = EmiStack.of((class_1799)recipe.getOutputContainer());
        this.brewTime = recipe.getBrewTime();
        this.needWater = recipe.getNeedWater();
    }

    public EmiRecipeCategory getCategory() {
        return EMIPlugin.BREWING_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        ArrayList<EmiIngredient> inputEntryList = new ArrayList<EmiIngredient>(this.ingredient);
        inputEntryList.add(this.getContainerOutput());
        return ImmutableList.copyOf(inputEntryList);
    }

    public EmiIngredient getContainerOutput() {
        return this.containerOutput;
    }

    public int getBrewTime() {
        return this.brewTime;
    }

    public boolean getNeedWater() {
        return this.needWater;
    }

    public List<EmiStack> getOutputs() {
        return this.containerOutput.getEmiStacks();
    }

    public int getDisplayWidth() {
        return 116;
    }

    public int getDisplayHeight() {
        return 56;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addDrawable(0, 0, 116, 56, (draw, mouseX, mouseY, delta) -> draw.method_25290(GUI_TEXTURE, 0, 0, 29.0f, 16.0f, 116, 56, 256, 256));
        List<EmiIngredient> ingredientEntries = this.getInputs();
        if (ingredientEntries != null) {
            if (!ingredientEntries.isEmpty()) {
                widgets.addSlot(ingredientEntries.get(0), 12, 0).drawBack(false);
            }
            if (ingredientEntries.size() > 1) {
                widgets.addSlot(ingredientEntries.get(1), 12, 18).drawBack(false);
            }
        }
        widgets.addSlot(this.getContainerOutput(), 56, 38).drawBack(false);
        widgets.addSlot((EmiIngredient)this.output, 88, 11).drawBack(false);
        widgets.addSlot((EmiIngredient)this.output, 88, 38).drawBack(false);
        widgets.addFillingArrow(42, 10, this.getBrewTime() * 20);
        widgets.addDrawable(13, 39, 17, 15, (draw, mouseX, mouseY, delta) -> draw.method_25302(GUI_TEXTURE, 0, 0, 176, 0, 17, 15));
        if (this.getNeedWater()) {
            widgets.addDrawable(5, 23, 5, 11, (draw, mouseX, mouseY, delta) -> draw.method_25302(GUI_TEXTURE, 0, 0, 176, 15, 5, 11)).tooltipText(FarmersRespite.i18n("rei.brewing.needWater", new Object[0]).method_44746());
        } else {
            widgets.addDrawable(5, 23, 5, 11, (draw, mouseX, mouseY, delta) -> {}).tooltipText(FarmersRespite.i18n("rei.brewing.noWater", new Object[0]).method_44746());
        }
    }
}

