/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.api;

import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.api.MeshHelper;
import dev.tr7zw.skinlayers.api.MeshProvider;
import dev.tr7zw.skinlayers.api.MeshTransformerProvider;
import dev.tr7zw.skinlayers.api.PlayerData;
import dev.tr7zw.skinlayers.render.SolidPixelWrapper;
import net.minecraft.class_1011;
import net.minecraft.class_742;

public class SkinLayersAPI {
    private static final MeshHelper meshHelper = new MeshHelperImplementation();
    private static final MeshProvider meshProvider = new MeshProviderImplementation();
    private static MeshTransformerProvider meshTransformerProvider = MeshTransformerProvider.EMPTY_PROVIDER;

    private SkinLayersAPI() {
    }

    public static MeshHelper getMeshHelper() {
        return meshHelper;
    }

    public static MeshProvider getMeshProvider() {
        return meshProvider;
    }

    public static void setupMeshTransformerProvider(MeshTransformerProvider provider) {
        meshTransformerProvider = provider;
    }

    public static MeshTransformerProvider getMeshTransformerProvider() {
        return meshTransformerProvider;
    }

    private static class MeshHelperImplementation
    implements MeshHelper {
        private MeshHelperImplementation() {
        }

        @Override
        public Mesh create3DMesh(class_1011 natImage, int width, int height, int depth, int textureU, int textureV, boolean topPivot, float rotationOffset) {
            return SolidPixelWrapper.wrapBox(natImage, width, height, depth, textureU, textureV, topPivot, rotationOffset);
        }
    }

    private static class MeshProviderImplementation
    implements MeshProvider {
        private MeshProviderImplementation() {
        }

        @Override
        public PlayerData getPlayerMesh(class_742 abstractClientPlayerEntity) {
            if (abstractClientPlayerEntity instanceof PlayerData) {
                PlayerData data = (PlayerData)abstractClientPlayerEntity;
                return data;
            }
            return null;
        }
    }
}

